/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.movie.tasks.MovieFindMissingTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;

public class MovieFindMissingAction
extends AbstractAction {
    private static final long serialVersionUID = 7873846965534352231L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private String datasource = null;

    public MovieFindMissingAction(String datasource) {
        this.datasource = datasource;
        this.setValues();
    }

    public MovieFindMissingAction() {
        this.setValues();
    }

    private void setValues() {
        if (StringUtils.isNotBlank((CharSequence)this.datasource)) {
            this.putValue("Name", this.datasource);
        } else {
            this.putValue("Name", BUNDLE.getString("movie.findmissing.all"));
        }
        if (!Globals.isDonator()) {
            this.setEnabled(false);
            this.putValue("ShortDescription", BUNDLE.getString("tmm.donatorfunction.hint"));
        }
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        MovieFindMissingTask task = null;
        task = StringUtils.isNotBlank((CharSequence)this.datasource) ? new MovieFindMissingTask(this.datasource) : new MovieFindMissingTask();
        if (TmmTaskManager.getInstance().addMainTask(task)) {
            JOptionPane.showMessageDialog(null, BUNDLE.getString("onlyoneoperation"));
        }
    }
}

