/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.movie.MovieSearchOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.movies.MovieExtendedComparator;
import org.tinymediamanager.ui.movies.MovieMatcherEditor;

public class MovieSelectionModel
extends AbstractModelObject
implements ListSelectionListener {
    private static final String SELECTED_MOVIE = "selectedMovie";
    private List<Movie> selectedMovies;
    private Movie selectedMovie;
    private Movie initialMovie = new Movie();
    private DefaultEventSelectionModel<Movie> selectionModel;
    private MovieMatcherEditor matcherEditor;
    private TableComparatorChooser<Movie> tableComparatorChooser;
    private SortedList<Movie> sortedList;
    private PropertyChangeListener propertyChangeListener;

    public MovieSelectionModel(SortedList<Movie> sortedList, EventList<Movie> source, MovieMatcherEditor matcher) {
        this.sortedList = sortedList;
        this.selectionModel = new DefaultEventSelectionModel(source);
        this.selectionModel.addListSelectionListener((ListSelectionListener)this);
        this.matcherEditor = matcher;
        this.selectedMovies = this.selectionModel.getSelected();
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() == MovieSelectionModel.this.selectedMovie) {
                    MovieSelectionModel.this.firePropertyChange(evt);
                }
            }
        };
    }

    public MovieSelectionModel() {
    }

    public void setSelectedMovie(Movie movie) {
        Movie oldValue = this.selectedMovie;
        this.selectedMovie = movie == null ? this.initialMovie : movie;
        if (oldValue != null) {
            oldValue.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.selectedMovie != null) {
            this.selectedMovie.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.firePropertyChange(SELECTED_MOVIE, oldValue, this.selectedMovie);
    }

    public MovieMatcherEditor getMatcherEditor() {
        return this.matcherEditor;
    }

    public DefaultEventSelectionModel<Movie> getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Movie oldValue;
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.selectedMovies.size() > 0 && this.selectedMovie != this.selectedMovies.get(0)) {
            oldValue = this.selectedMovie;
            this.selectedMovie = this.selectedMovies.get(0);
            if (oldValue != null && oldValue != this.initialMovie) {
                oldValue.removePropertyChangeListener(this.propertyChangeListener);
            }
            if (this.selectedMovie != null && this.selectedMovie != this.initialMovie) {
                this.selectedMovie.addPropertyChangeListener(this.propertyChangeListener);
            }
            this.firePropertyChange(SELECTED_MOVIE, oldValue, this.selectedMovie);
        }
        if (this.selectedMovies.size() == 0) {
            oldValue = this.selectedMovie;
            this.selectedMovie = this.initialMovie;
            if (oldValue != null && oldValue != this.initialMovie) {
                oldValue.removePropertyChangeListener(this.propertyChangeListener);
            }
            this.firePropertyChange(SELECTED_MOVIE, oldValue, this.selectedMovie);
        }
    }

    public Movie getSelectedMovie() {
        if (this.selectedMovie == null) {
            return this.initialMovie;
        }
        return this.selectedMovie;
    }

    public List<Movie> getSelectedMovies() {
        return this.selectedMovies;
    }

    public void setSelectedMovies(List<Movie> selectedMovies) {
        this.selectedMovies = selectedMovies;
    }

    public void filterMovies(Map<MovieSearchOptions, Object> filter) {
        this.matcherEditor.filterMovies(filter);
        this.firePropertyChange("filterChanged", filter.isEmpty(), !filter.isEmpty());
    }

    public TableComparatorChooser<Movie> getTableComparatorChooser() {
        return this.tableComparatorChooser;
    }

    public void setTableComparatorChooser(TableComparatorChooser<Movie> tableComparatorChooser) {
        this.tableComparatorChooser = tableComparatorChooser;
    }

    public void sortMovies(MovieExtendedComparator.SortColumn column, boolean ascending) {
        MovieExtendedComparator comparator = new MovieExtendedComparator(column, ascending);
        this.sortedList.setComparator((Comparator)comparator);
    }
}

