/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.scraper.kodi.RegExp;
import org.tinymediamanager.scraper.kodi.RegExpContainer;

class ScraperFunction
implements RegExpContainer {
    private boolean clearBuffers = true;
    private int dest = 0;
    private boolean appendBuffer = false;
    private String name;
    private List<RegExp> regexps = new ArrayList<RegExp>();

    public ScraperFunction clone() {
        ScraperFunction c = new ScraperFunction();
        c.setClearBuffers(this.clearBuffers);
        c.setDest(this.dest);
        c.setAppendBuffer(this.appendBuffer);
        c.setName(this.name);
        for (RegExp r : this.regexps) {
            c.addRegExp(r.clone());
        }
        return c;
    }

    public boolean isClearBuffers() {
        return this.clearBuffers;
    }

    public void setClearBuffers(boolean clearBuffers) {
        this.clearBuffers = clearBuffers;
    }

    public int getDest() {
        return this.dest;
    }

    public void setDest(int dest) {
        this.dest = dest;
    }

    public void setName(String nodeName) {
        this.name = nodeName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void addRegExp(RegExp regexp) {
        this.regexps.add(regexp);
    }

    @Override
    public RegExp[] getRegExps() {
        return this.regexps.toArray(new RegExp[this.regexps.size()]);
    }

    @Override
    public boolean hasRegExps() {
        return this.regexps != null && this.regexps.size() > 0;
    }

    public boolean isAppendBuffer() {
        return this.appendBuffer;
    }

    public void setAppendBuffer(boolean appendBuffer) {
        this.appendBuffer = appendBuffer;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

