/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.managers;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.jcores.jre.interfaces.functions.F0;
import net.jcores.jre.managers.Manager;
import net.jcores.jre.utils.internal.structures.ProfileInformation;

public class ManagerExecution
extends Manager {
    ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    });
    ProfileInformation profile = this.profile();

    public ExecutorService getExecutor() {
        return this.executor;
    }

    private ProfileInformation profile() {
        int n;
        ProfileInformation profileInformation = new ProfileInformation();
        long[] lArray = new long[10];
        for (n = 0; n < 10; ++n) {
            lArray[n] = this.measure(new F0(){

                @Override
                public void f() {
                    final CyclicBarrier cyclicBarrier = new CyclicBarrier(2);
                    ManagerExecution.this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                cyclicBarrier.await();
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                            catch (BrokenBarrierException brokenBarrierException) {
                                brokenBarrierException.printStackTrace();
                            }
                        }
                    });
                    try {
                        cyclicBarrier.await();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    catch (BrokenBarrierException brokenBarrierException) {
                        brokenBarrierException.printStackTrace();
                    }
                }
            });
        }
        for (n = 5; n < lArray.length; ++n) {
            profileInformation.forkTime += lArray[n];
        }
        profileInformation.forkTime /= 5L;
        profileInformation.numCPUs = Runtime.getRuntime().availableProcessors();
        return profileInformation;
    }

    private long measure(F0 f0) {
        long l = System.nanoTime();
        f0.f();
        long l2 = System.nanoTime();
        return l2 - l;
    }

    public ProfileInformation getProfile() {
        return this.profile;
    }
}

