/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BaseTabbedPaneUI
extends TabbedPaneUI
implements SwingConstants {
    protected static final Insets NULL_BORDER_INSETS = new Insets(0, 0, 0, 0);
    protected static final int GAP = 5;
    protected JTabbedPane tabPane;
    protected Color tabAreaBackground;
    protected Color selectedColor;
    protected int textIconGap;
    protected int tabRunOverlay;
    protected Insets tabInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets contentBorderInsets;
    protected int[] tabRuns = new int[10];
    protected int runCount = 0;
    protected int selectedRun = -1;
    protected Rectangle[] rects = new Rectangle[0];
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected ChangeListener tabChangeListener;
    protected ComponentListener tabComponentListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected MouseMotionListener mouseMotionListener;
    protected FocusListener focusListener;
    private ContainerListener containerListener;
    private Insets currentPadInsets = new Insets(0, 0, 0, 0);
    private Insets currentTabAreaInsets = new Insets(0, 0, 0, 0);
    private Component visibleComponent;
    private ArrayList htmlViews;
    private HashMap mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    private ScrollableTabSupport tabScroller;
    private TabContainer tabContainer;
    protected transient Rectangle calcRect = new Rectangle(0, 0, 0, 0);
    private int tabCount;
    protected int oldRolloverIndex = -1;
    protected int rolloverIndex = -1;
    protected boolean roundedTabs = true;
    protected boolean simpleButtonBorder = false;
    private int[] xCropLen = new int[]{1, 1, 0, 0, 1, 1, 2, 2};
    private int[] yCropLen = new int[]{0, 3, 3, 6, 6, 9, 9, 12};
    private static final int CROP_SEGMENT = 12;

    public static ComponentUI createUI(JComponent c) {
        return new BaseTabbedPaneUI();
    }

    public void installUI(JComponent c) {
        this.tabPane = (JTabbedPane)c;
        c.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        c.setLayout(null);
        this.tabPane = null;
    }

    protected LayoutManager createLayoutManager() {
        if (JTattooUtilities.getJavaVersion() >= 1.4 && this.tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout();
        }
        return new TabbedPaneLayout();
    }

    protected boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
            this.tabPane.add(this.tabScroller.scrollForwardButton);
            this.tabPane.add(this.tabScroller.scrollBackwardButton);
            this.tabPane.add(this.tabScroller.popupMenuButton);
            this.tabScroller.tabPanel.setBackground(this.tabAreaBackground);
        }
        this.installTabContainer();
    }

    private Component getTabComponentAt(int index) {
        if (JTattooUtilities.getJavaVersion() >= 1.6) {
            return this.tabPane.getTabComponentAt(index);
        }
        return null;
    }

    private void installTabContainer() {
        if (JTattooUtilities.getJavaVersion() >= 1.6) {
            for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                Component tabComponent = this.getTabComponentAt(i);
                if (tabComponent == null) continue;
                if (this.tabContainer == null) {
                    this.tabContainer = new TabContainer();
                }
                this.tabContainer.add(tabComponent);
                this.addMyPropertyChangeListeners(tabComponent);
            }
            if (this.tabContainer == null) {
                return;
            }
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.add(this.tabContainer);
            } else {
                this.tabPane.add(this.tabContainer);
            }
        }
    }

    protected void uninstallComponents() {
        this.uninstallTabContainer();
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabPane.remove(this.tabScroller.scrollForwardButton);
            this.tabPane.remove(this.tabScroller.scrollBackwardButton);
            this.tabPane.remove(this.tabScroller.popupMenuButton);
            this.tabScroller = null;
        }
    }

    private void addMyPropertyChangeListeners(Component component) {
        component.addPropertyChangeListener(new MyTabComponentListener());
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component c = container.getComponent(i);
                this.addMyPropertyChangeListeners(c);
            }
        }
    }

    private void removeMyPropertyChangeListeners(Component component) {
        PropertyChangeListener[] listeners = component.getPropertyChangeListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof MyTabComponentListener)) continue;
            component.removePropertyChangeListener(listeners[i]);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component c = container.getComponent(i);
                this.removeMyPropertyChangeListeners(c);
            }
        }
    }

    private void uninstallTabContainer() {
        if (JTattooUtilities.getJavaVersion() >= 1.6) {
            if (this.tabContainer == null) {
                return;
            }
            this.tabContainer.notifyTabbedPane = false;
            for (int i = 0; i < this.tabContainer.getComponentCount(); ++i) {
                Component c = this.tabContainer.getComponent(i);
                this.removeMyPropertyChangeListeners(c);
            }
            this.tabContainer.removeAll();
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.remove(this.tabContainer);
            } else {
                this.tabPane.remove(this.tabContainer);
            }
            this.tabContainer = null;
        }
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tabPane, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this.tabAreaBackground = UIManager.getColor("TabbedPane.tabAreaBackground");
        this.selectedColor = UIManager.getColor("TabbedPane.selected");
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this.tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
        this.selectedTabPadInsets = UIManager.getInsets("TabbedPane.selectedTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
        this.contentBorderInsets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        this.tabRunOverlay = UIManager.getInt("TabbedPane.tabRunOverlay");
        this.tabPane.setBorder(UIManager.getBorder("TabbedPane.boder"));
    }

    protected void uninstallDefaults() {
        this.tabInsets = null;
        this.selectedTabPadInsets = null;
        this.tabAreaInsets = null;
        this.contentBorderInsets = null;
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.tabComponentListener = this.createComponentListener()) != null) {
            this.tabPane.addComponentListener(this.tabComponentListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.addMouseListener(this.mouseListener);
            } else {
                this.tabPane.addMouseListener(this.mouseListener);
            }
        }
        if ((this.mouseMotionListener = this.createMouseMotionListener()) != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.addMouseMotionListener(this.mouseMotionListener);
            } else {
                this.tabPane.addMouseMotionListener(this.mouseMotionListener);
            }
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        this.containerListener = new ContainerHandler();
        this.tabPane.addContainerListener(this.containerListener);
        if (this.tabPane.getTabCount() > 0) {
            this.htmlViews = this.createHTMLViewList();
        }
    }

    protected void uninstallListeners() {
        if (this.mouseListener != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.removeMouseListener(this.mouseListener);
            } else {
                this.tabPane.removeMouseListener(this.mouseListener);
            }
            this.mouseListener = null;
        }
        if (this.mouseMotionListener != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.removeMouseMotionListener(this.mouseMotionListener);
            } else {
                this.tabPane.removeMouseMotionListener(this.mouseMotionListener);
            }
            this.mouseMotionListener = null;
        }
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.containerListener != null) {
            this.tabPane.removeContainerListener(this.containerListener);
            this.containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.clear();
                this.htmlViews = null;
            }
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.tabComponentListener != null) {
            this.tabPane.removeComponentListener(this.tabComponentListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new MouseMotionHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    protected ComponentListener createComponentListener() {
        return new TabComponentHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, km);
        km = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, km);
        ActionMap am = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.tabPane, am);
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.scrollForwardButton.setAction(am.get("scrollTabsForwardAction"));
            this.tabScroller.scrollBackwardButton.setAction(am.get("scrollTabsBackwardAction"));
            this.tabScroller.popupMenuButton.setAction(am.get("scrollTabsPopupMenuAction"));
        }
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIManager.get("TabbedPane.ancestorInputMap");
        }
        if (condition == 0) {
            return (InputMap)UIManager.get("TabbedPane.focusInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap map = (ActionMap)UIManager.get("TabbedPane.actionMap");
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("TabbedPane.actionMap", map);
        }
        return map;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("navigateNext", new NextAction());
        map.put("navigatePrevious", new PreviousAction());
        map.put("navigateRight", new RightAction());
        map.put("navigateLeft", new LeftAction());
        map.put("navigateUp", new UpAction());
        map.put("navigateDown", new DownAction());
        map.put("navigatePageUp", new PageUpAction());
        map.put("navigatePageDown", new PageDownAction());
        map.put("requestFocus", new RequestFocusAction());
        map.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction());
        map.put("setSelectedIndex", new SetSelectedIndexAction());
        map.put("scrollTabsForwardAction", new ScrollTabsForwardAction());
        map.put("scrollTabsBackwardAction", new ScrollTabsBackwardAction());
        map.put("scrollTabsPopupMenuAction", new ScrollTabsPopupMenuAction());
        return map;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 2, null);
    }

    private void updateMnemonics() {
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            this.resetMnemonics();
            for (int counter = this.tabPane.getTabCount() - 1; counter >= 0; --counter) {
                int mnemonic = this.tabPane.getMnemonicAt(counter);
                if (mnemonic <= 0) continue;
                this.addMnemonic(counter, mnemonic);
            }
        }
    }

    private void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int index, int mnemonic) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(mnemonic, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(new Integer(mnemonic), new Integer(index));
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new HashMap();
        this.mnemonicInputMap = new ComponentInputMapUIResource(this.tabPane);
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 2));
        SwingUtilities.replaceUIInputMap(this.tabPane, 2, this.mnemonicInputMap);
    }

    protected boolean isContentOpaque() {
        if (!this.tabPane.isOpaque() && UIManager.get("TabbedPane.contentOpaque") != null) {
            return UIManager.getBoolean("TabbedPane.contentOpaque");
        }
        return true;
    }

    protected boolean isTabOpaque() {
        if (!this.tabPane.isOpaque() && UIManager.get("TabbedPane.tabsOpaque") != null) {
            return UIManager.getBoolean("TabbedPane.tabsOpaque");
        }
        return true;
    }

    protected boolean hasInnerBorder() {
        return false;
    }

    protected Color[] getTabColors(int tabIndex, boolean isSelected, boolean isRollover) {
        Color[] colorArr = AbstractLookAndFeel.getTheme().getTabColors();
        if (tabIndex >= 0 && tabIndex < this.tabPane.getTabCount()) {
            boolean isEnabled = this.tabPane.isEnabledAt(tabIndex);
            Color backColor = this.tabPane.getBackgroundAt(tabIndex);
            if (backColor instanceof UIResource) {
                colorArr = isSelected ? AbstractLookAndFeel.getTheme().getSelectedColors() : (isRollover && isEnabled ? AbstractLookAndFeel.getTheme().getRolloverColors() : (JTattooUtilities.isFrameActive(this.tabPane) ? AbstractLookAndFeel.getTheme().getTabColors() : AbstractLookAndFeel.getTheme().getInActiveColors()));
            } else if (backColor != null) {
                colorArr = isSelected ? ColorHelper.createColorArr(ColorHelper.brighter(backColor, 60.0), backColor, 20) : (isRollover && isEnabled ? ColorHelper.createColorArr(ColorHelper.brighter(backColor, 80.0), ColorHelper.brighter(backColor, 20.0), 20) : ColorHelper.createColorArr(ColorHelper.brighter(backColor, 40.0), ColorHelper.darker(backColor, 10.0), 20));
            }
        }
        return colorArr;
    }

    protected Color getLoBorderColor(int tabIndex) {
        return AbstractLookAndFeel.getControlDarkShadow();
    }

    protected Color getHiBorderColor(int tabIndex) {
        Color backColor = this.tabPane.getBackgroundAt(tabIndex);
        if (tabIndex == this.tabPane.getSelectedIndex()) {
            if (backColor instanceof UIResource) {
                return AbstractLookAndFeel.getControlHighlight();
            }
            return ColorHelper.brighter(backColor, 40.0);
        }
        if (tabIndex >= 0 && tabIndex <= this.tabCount) {
            if (!this.isTabOpaque() || backColor instanceof UIResource) {
                return AbstractLookAndFeel.getControlHighlight();
            }
            return ColorHelper.brighter(backColor, 40.0);
        }
        return AbstractLookAndFeel.getControlHighlight();
    }

    protected Color[] getContentBorderColors(int tabPlacement) {
        int sepHeight = this.tabAreaInsets.bottom;
        Color[] selColors = AbstractLookAndFeel.getTheme().getSelectedColors();
        Color loColor = selColors[selColors.length - 1];
        Color darkLoColor = ColorHelper.darker(loColor, 20.0);
        return ColorHelper.createColorArr(loColor, darkLoColor, sepHeight);
    }

    protected Color getContentBorderColor() {
        return AbstractLookAndFeel.getFrameColor();
    }

    protected Color getGapColor(int tabIndex) {
        if ((this.isTabOpaque() || tabIndex == this.tabPane.getSelectedIndex()) && tabIndex >= 0 && tabIndex < this.tabCount) {
            Color[] tabColors = this.getTabColors(tabIndex, tabIndex == this.tabPane.getSelectedIndex(), false);
            if (tabColors != null && tabColors.length > 0) {
                return tabColors[tabColors.length - 1];
            }
            return this.tabPane.getBackgroundAt(tabIndex);
        }
        if (!this.tabPane.isOpaque()) {
            for (Container parent = this.tabPane.getParent(); parent != null; parent = parent.getParent()) {
                if (!parent.isOpaque()) continue;
                return parent.getBackground();
            }
        }
        return this.tabAreaBackground;
    }

    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    public void paint(Graphics g, JComponent c) {
        int tc = this.tabPane.getTabCount();
        if (this.tabCount != tc) {
            this.tabCount = tc;
            this.updateMnemonics();
        }
        int selectedIndex = this.tabPane.getSelectedIndex();
        int tabPlacement = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        this.paintContentBorder(g, tabPlacement, selectedIndex, 0, 0, c.getWidth(), c.getHeight());
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(g, tabPlacement, selectedIndex);
        }
    }

    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        int tc = this.tabPane.getTabCount();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Shape savedClip = g.getClip();
        Rectangle clipRect = g.getClipBounds();
        if (this.scrollableTabLayoutEnabled() && this.tabScroller.scrollBackwardButton.isVisible()) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                g.setClip(clipRect.x, clipRect.y, clipRect.width + 1, clipRect.height);
            } else {
                g.setClip(clipRect.x, clipRect.y, clipRect.width, clipRect.height + 1);
            }
        }
        for (int i = this.runCount - 1; i >= 0; --i) {
            int start = this.tabRuns[i];
            int next = this.tabRuns[i == this.runCount - 1 ? 0 : i + 1];
            int end = next != 0 ? next - 1 : tc - 1;
            for (int j = start; j <= end; ++j) {
                if (!this.rects[j].intersects(clipRect)) continue;
                this.paintTab(g, tabPlacement, this.rects, j, iconRect, textRect);
            }
        }
        if (selectedIndex >= 0 && selectedIndex < this.rects.length && this.getRunForTab(tc, selectedIndex) == 0 && this.rects[selectedIndex].intersects(clipRect)) {
            this.paintTab(g, tabPlacement, this.rects, selectedIndex, iconRect, textRect);
        }
        g.setClip(savedClip);
    }

    protected Font getTabFont(boolean isSelected) {
        return this.tabPane.getFont();
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        Rectangle tabRect = rects[tabIndex];
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        Graphics2D g2D = null;
        Polygon cropShape = null;
        Shape savedClip = null;
        int cropx = 0;
        int cropy = 0;
        if (this.scrollableTabLayoutEnabled() && g instanceof Graphics2D) {
            g2D = (Graphics2D)g;
            Rectangle viewRect = this.tabScroller.viewport.getViewRect();
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    int cropline = viewRect.y + viewRect.height;
                    if (tabRect.y >= cropline || tabRect.y + tabRect.height <= cropline) break;
                    cropShape = this.createCroppedTabClip(tabPlacement, tabRect, cropline);
                    cropx = tabRect.x;
                    cropy = cropline - 1;
                    break;
                }
                default: {
                    int cropline = viewRect.x + viewRect.width;
                    if (tabRect.x >= cropline || tabRect.x + tabRect.width <= cropline) break;
                    cropShape = this.createCroppedTabClip(tabPlacement, tabRect, cropline);
                    cropx = cropline - 1;
                    cropy = tabRect.y;
                }
            }
            if (cropShape != null) {
                savedClip = g2D.getClip();
                g2D.clip(cropShape);
            }
        }
        this.paintTabBackground(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        this.paintTabBorder(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        try {
            boolean doPaintContent;
            boolean bl = doPaintContent = this.getTabComponentAt(tabIndex) == null;
            if (doPaintContent) {
                String title = this.tabPane.getTitleAt(tabIndex);
                Font font = this.getTabFont(isSelected);
                FontMetrics fm = JTattooUtilities.getFontMetrics(this.tabPane, g, font);
                Icon icon = this.getIconForTab(tabIndex);
                this.layoutLabel(tabPlacement, fm, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
                this.paintText(g, tabPlacement, font, fm, tabIndex, title, textRect, isSelected);
                this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
            }
            this.paintFocusIndicator(g, tabPlacement, rects, tabIndex, iconRect, textRect, isSelected);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (cropShape != null) {
            this.paintCroppedTabEdge(g, tabPlacement, tabIndex, cropx, cropy);
            if (g2D != null && savedClip != null) {
                g2D.setClip(savedClip);
            }
        }
    }

    private Polygon createCroppedTabClip(int tabPlacement, Rectangle tabRect, int cropline) {
        int ostart;
        int end;
        int start;
        int rlen;
        switch (tabPlacement) {
            case 2: 
            case 4: {
                rlen = tabRect.width;
                start = tabRect.x;
                end = tabRect.x + tabRect.width;
                ostart = tabRect.y;
                break;
            }
            default: {
                rlen = tabRect.height;
                start = tabRect.y;
                end = tabRect.y + tabRect.height;
                ostart = tabRect.x;
            }
        }
        int rcnt = rlen / 12;
        if (rlen % 12 > 0) {
            ++rcnt;
        }
        int npts = 2 + rcnt * 8;
        int[] xp = new int[npts];
        int[] yp = new int[npts];
        int pcnt = 0;
        xp[pcnt] = ostart;
        yp[pcnt++] = end;
        xp[pcnt] = ostart;
        yp[pcnt++] = start;
        block3: for (int i = 0; i < rcnt; ++i) {
            for (int j = 0; j < this.xCropLen.length; ++j) {
                xp[pcnt] = cropline - this.xCropLen[j];
                yp[pcnt] = start + i * 12 + this.yCropLen[j];
                if (yp[pcnt] >= end) {
                    yp[pcnt] = end;
                    ++pcnt;
                    continue block3;
                }
                ++pcnt;
            }
        }
        if (tabPlacement == 1 || tabPlacement == 3) {
            return new Polygon(xp, yp, pcnt);
        }
        return new Polygon(yp, xp, pcnt);
    }

    private void paintCroppedTabEdge(Graphics g, int tabPlacement, int tabIndex, int x, int y) {
        g.setColor(Color.gray);
        switch (tabPlacement) {
            case 2: 
            case 4: {
                for (int xx = x; xx <= x + this.rects[tabIndex].width; xx += 12) {
                    for (int i = 0; i < this.xCropLen.length; i += 2) {
                        g.drawLine(xx + this.yCropLen[i], y - this.xCropLen[i], xx + this.yCropLen[i + 1] - 1, y - this.xCropLen[i + 1]);
                    }
                }
                break;
            }
            default: {
                for (int yy = y; yy <= y + this.rects[tabIndex].height; yy += 12) {
                    for (int i = 0; i < this.xCropLen.length; i += 2) {
                        g.drawLine(x - this.xCropLen[i], yy + this.yCropLen[i], x - this.xCropLen[i + 1], yy + this.yCropLen[i + 1] - 1);
                    }
                }
            }
        }
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        if (!isSelected) {
            if (tabPlacement == 1) {
                return 1;
            }
            if (tabPlacement == 3) {
                return -1;
            }
        }
        return 0;
    }

    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        if (icon != null) {
            icon.paintIcon(this.tabPane, g, iconRect.x, iconRect.y);
        }
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            Graphics2D g2D = (Graphics2D)g;
            Object savedRenderingHint = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            v.paint(g, textRect);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
            }
        } else {
            int mnemIndex = -1;
            if (JTattooUtilities.getJavaVersion() >= 1.4) {
                mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            }
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                if (isSelected) {
                    Color backColor = this.tabPane.getBackgroundAt(tabIndex);
                    if (backColor instanceof UIResource) {
                        g.setColor(AbstractLookAndFeel.getTabSelectionForegroundColor());
                    } else {
                        g.setColor(this.tabPane.getForegroundAt(tabIndex));
                    }
                } else if (tabIndex == this.rolloverIndex) {
                    g.setColor(AbstractLookAndFeel.getTheme().getRolloverForegroundColor());
                } else {
                    g.setColor(this.tabPane.getForegroundAt(tabIndex));
                }
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            }
        }
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        if (this.tabPane.isRequestFocusEnabled() && this.tabPane.hasFocus() && isSelected && tabIndex >= 0 && textRect.width > 8) {
            g.setColor(AbstractLookAndFeel.getTheme().getFocusColor());
            BasicGraphicsUtils.drawDashedRect(g, textRect.x - 4, textRect.y + 1, textRect.width + 8, textRect.height);
        }
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int x2 = x + w;
        int y2 = y + h;
        switch (tabPlacement) {
            case 2: {
                this.paintLeftTabBorder(tabIndex, g, x, y, x2, y2, isSelected);
                break;
            }
            case 4: {
                this.paintRightTabBorder(tabIndex, g, x, y, x2, y2, isSelected);
                break;
            }
            case 3: {
                if (this.roundedTabs) {
                    this.paintRoundedBottomTabBorder(tabIndex, g, x, y, x2, y2 - 1, isSelected);
                    break;
                }
                this.paintBottomTabBorder(tabIndex, g, x, y, x2, y2 - 1, isSelected);
                break;
            }
            default: {
                if (this.roundedTabs) {
                    this.paintRoundedTopTabBorder(tabIndex, g, x, y, x2, y2, isSelected);
                    break;
                }
                this.paintTopTabBorder(tabIndex, g, x, y, x2, y2, isSelected);
            }
        }
    }

    protected void paintRoundedTopTabBorder(int tabIndex, Graphics g, int x1, int y1, int x2, int y2, boolean isSelected) {
        Graphics2D g2D = (Graphics2D)g;
        Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color borderColor = this.getLoBorderColor(tabIndex);
        g.setColor(borderColor);
        int d = 10;
        if (isSelected) {
            g.drawLine(x1 + 5, y1, x2 - 5, y1);
            g.drawArc(x1, y1, d, d, 90, 90);
            g.drawArc(x2 - d, y1, d, d, 0, 90);
            g.drawLine(x1, y1 + 5 + 1, x1, y2);
            g.drawLine(x2, y1 + 5 + 1, x2, y2);
        } else {
            g.drawLine(x1 + 5, y1, x2 - 5, y1);
            g.drawArc(x1, y1, d, d, 90, 90);
            g.drawArc(x2 - d, y1, d, d, 0, 90);
            g.drawLine(x1, y1 + 5 + 1, x1, y2 - 1);
            g.drawLine(x2, y1 + 5 + 1, x2, y2 - 1);
        }
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
    }

    protected void paintTopTabBorder(int tabIndex, Graphics g, int x1, int y1, int x2, int y2, boolean isSelected) {
        int tc = this.tabPane.getTabCount();
        int currentRun = this.getRunForTab(tc, tabIndex);
        int lastIndex = this.lastTabInRun(tc, currentRun);
        int firstIndex = this.tabRuns[currentRun];
        boolean leftToRight = JTattooUtilities.isLeftToRight(this.tabPane);
        Color loColor = this.getLoBorderColor(tabIndex);
        Color hiColor = this.getHiBorderColor(tabIndex);
        g.setColor(loColor);
        g.drawLine(x1 + 5, y1, x2, y1);
        g.drawLine(x1 + 5, y1, x1, y1 + 5);
        g.drawLine(x1, y1 + 5 + 1, x1, y2);
        g.drawLine(x2, y1, x2, y2);
        g.setColor(hiColor);
        g.drawLine(x1 + 5 + 1, y1 + 1, x2 - 1, y1 + 1);
        g.drawLine(x1 + 5 + 1, y1 + 1, x1 + 1, y1 + 5 + 1);
        g.drawLine(x1 + 1, y1 + 5 + 1, x1 + 1, y2 - 1);
        int gapTabIndex = this.getTabAtLocation(x1 + 2, y1 - 2);
        Color gapColor = this.getGapColor(gapTabIndex);
        g.setColor(gapColor);
        for (int i = 0; i < 5; ++i) {
            g.drawLine(x1, y1 + i, x1 + 5 - i - 1, y1 + i);
        }
        if (leftToRight) {
            if (tabIndex != firstIndex || currentRun != this.runCount - 1) {
                g.setColor(loColor);
                g.drawLine(x1, y1, x1, y1 + 5);
            }
            if (!isSelected && tabIndex == firstIndex && currentRun != this.runCount - 1) {
                g.setColor(hiColor);
                g.drawLine(x1 + 1, y1, x1 + 1, y1 + 5 - 2);
            }
        } else if (tabIndex != lastIndex || currentRun != this.runCount - 1) {
            g.setColor(loColor);
            g.drawLine(x1, y1, x1, y1 + 5);
        }
    }

    protected void paintLeftTabBorder(int tabIndex, Graphics g, int x1, int y1, int x2, int y2, boolean isSelected) {
        Graphics2D g2D = (Graphics2D)g;
        int tc = this.tabPane.getTabCount();
        int currentRun = this.getRunForTab(tc, tabIndex);
        int lastIndex = this.lastTabInRun(tc, currentRun);
        int firstIndex = this.tabRuns[currentRun];
        Color loColor = this.getLoBorderColor(tabIndex);
        Color hiColor = this.getHiBorderColor(tabIndex);
        g.setColor(hiColor);
        Composite savedComposite = g2D.getComposite();
        AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
        g2D.setComposite(alpha);
        g.drawLine(x1 + 5 + 1, y1 + 1, x2 - 1, y1 + 1);
        g.drawLine(x1 + 5, y1 + 1, x1 + 1, y1 + 5);
        g.drawLine(x1 + 1, y1 + 5 + 1, x1 + 1, y2 - 1);
        g2D.setComposite(savedComposite);
        g.setColor(loColor);
        g.drawLine(x1 + 5, y1, x2 - 1, y1);
        g.drawLine(x1 + 5, y1, x1, y1 + 5);
        g.drawLine(x1, y1 + 5, x1, y2);
        g.drawLine(x1 + 5, y2, x2 - 1, y2);
        if (tabIndex == lastIndex) {
            g.drawLine(x1, y2, x1 + 5, y2);
        }
        int gapTabIndex = this.getTabAtLocation(x1 + 2, y1 - 2);
        Color gapColor = this.getGapColor(gapTabIndex);
        g.setColor(gapColor);
        for (int i = 0; i < 5; ++i) {
            g.drawLine(x1, y1 + i, x1 + 5 - i - 1, y1 + i);
        }
        if (tabIndex != firstIndex || currentRun != this.runCount - 1) {
            loColor = this.getLoBorderColor(gapTabIndex);
            g.setColor(loColor);
            g.drawLine(x1, y1, x1, y1 + 5 - 1);
            if (tabIndex != firstIndex) {
                g2D.setComposite(alpha);
                hiColor = this.getHiBorderColor(gapTabIndex);
                g.setColor(hiColor);
                g.drawLine(x1 + 1, y1, x1 + 1, y1 + 5 - 2);
                g2D.setComposite(savedComposite);
            }
        }
    }

    protected void paintRoundedBottomTabBorder(int tabIndex, Graphics g, int x1, int y1, int x2, int y2, boolean isSelected) {
        Graphics2D g2D = (Graphics2D)g;
        Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color loColor = this.getLoBorderColor(tabIndex);
        int d = 10;
        g.setColor(loColor);
        g.drawLine(x1 + 5, y2, x2 - 5, y2);
        g.drawArc(x1, y2 - d, d, d, 180, 90);
        g.drawArc(x2 - d, y2 - d, d, d, -90, 90);
        g.drawLine(x1, y1, x1, y2 - 5 - 1);
        g.drawLine(x2, y1, x2, y2 - 5 - 1);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
    }

    protected void paintBottomTabBorder(int tabIndex, Graphics g, int x1, int y1, int x2, int y2, boolean isSelected) {
        int tc = this.tabPane.getTabCount();
        int currentRun = this.getRunForTab(tc, tabIndex);
        int lastIndex = this.lastTabInRun(tc, currentRun);
        int firstIndex = this.tabRuns[currentRun];
        boolean leftToRight = JTattooUtilities.isLeftToRight(this.tabPane);
        Color loColor = this.getLoBorderColor(tabIndex);
        Color hiColor = this.getHiBorderColor(tabIndex);
        g.setColor(loColor);
        g.drawLine(x1, y1, x1, y2 - 5);
        g.drawLine(x1, y2 - 5, x1 + 5, y2);
        g.drawLine(x1 + 5, y2, x2, y2);
        g.drawLine(x2, y2, x2, y1);
        g.setColor(hiColor);
        g.drawLine(x1 + 1, y1, x1 + 1, y2 - 5 - 1);
        g.drawLine(x1 + 1, y2 - 5, x1 + 5, y2 - 1);
        int gapTabIndex = this.getTabAtLocation(x1 + 2, y2 + 2);
        Color gapColor = this.getGapColor(gapTabIndex);
        g.setColor(gapColor);
        for (int i = 0; i < 5; ++i) {
            g.drawLine(x1, y2 - i, x1 + 5 - i - 1, y2 - i);
        }
        if (leftToRight) {
            if (tabIndex != firstIndex || currentRun != this.runCount - 1) {
                g.setColor(loColor);
                g.drawLine(x1, y2 - 5, x1, y2);
            }
        } else if (tabIndex != lastIndex || currentRun != this.runCount - 1) {
            g.setColor(loColor);
            g.drawLine(x1, y2 - 5, x1, y2);
        }
    }

    protected void paintRightTabBorder(int tabIndex, Graphics g, int x1, int y1, int x2, int y2, boolean isSelected) {
        Graphics2D g2D = (Graphics2D)g;
        int tc = this.tabPane.getTabCount();
        int currentRun = this.getRunForTab(tc, tabIndex);
        int lastIndex = this.lastTabInRun(tc, currentRun);
        int firstIndex = this.tabRuns[currentRun];
        Color loColor = this.getLoBorderColor(tabIndex);
        Color hiColor = this.getHiBorderColor(tabIndex);
        Composite savedComposite = g2D.getComposite();
        AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
        g2D.setComposite(alpha);
        g.setColor(hiColor);
        g.drawLine(x1, y1 + 1, x2 - 5 - 1, y1 + 1);
        g.drawLine(x2 - 5, y1 + 1, x2 - 1, y1 + 5);
        g2D.setComposite(savedComposite);
        g.setColor(loColor);
        g.drawLine(x1, y1, x2 - 5, y1);
        g.drawLine(x2 - 5, y1, x2, y1 + 5);
        g.drawLine(x2, y1 + 5, x2, y2);
        if (tabIndex == lastIndex) {
            g.drawLine(x2, y2, x1, y2);
        }
        int gapTabIndex = this.getTabAtLocation(x1 + 2, y1 - 2);
        Color gapColor = this.getGapColor(gapTabIndex);
        g.setColor(gapColor);
        for (int i = 0; i < 5; ++i) {
            g.drawLine(x2 - 5 + i + 1, y1 + i, x2, y1 + i);
        }
        if (tabIndex != firstIndex || currentRun != this.runCount - 1) {
            loColor = this.getLoBorderColor(gapTabIndex);
            g.setColor(loColor);
            g.drawLine(x2, y1, x2, y1 + 5 - 1);
        }
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (this.isTabOpaque() || isSelected) {
            Graphics2D g2D = (Graphics2D)g;
            Shape savedClip = g.getClip();
            Area orgClipArea = new Area(new Rectangle2D.Double(x, y, w, h));
            if (savedClip != null) {
                orgClipArea = new Area(savedClip);
            }
            Color[] colorArr = this.getTabColors(tabIndex, isSelected, tabIndex == this.rolloverIndex);
            int d = 10;
            switch (tabPlacement) {
                default: {
                    if (isSelected) {
                        Area clipArea = new Area(new RoundRectangle2D.Double(x, y, w, h + 4, d, d));
                        Area rectArea = new Area(new Rectangle2D.Double(x, y, w, h + 2));
                        clipArea.intersect(rectArea);
                        clipArea.intersect(orgClipArea);
                        g2D.setClip(clipArea);
                        JTattooUtilities.fillHorGradient(g, colorArr, x, y, w, h + 4);
                        g2D.setClip(savedClip);
                        break;
                    }
                    Area clipArea = new Area(new RoundRectangle2D.Double(x, y, w, h + 4, d, d));
                    Area rectArea = new Area(new Rectangle2D.Double(x, y, w, h));
                    clipArea.intersect(rectArea);
                    clipArea.intersect(orgClipArea);
                    g2D.setClip(clipArea);
                    JTattooUtilities.fillHorGradient(g, colorArr, x, y, w, h + 4);
                    g2D.setClip(savedClip);
                    break;
                }
                case 2: {
                    if (isSelected) {
                        JTattooUtilities.fillHorGradient(g, colorArr, x + 1, y + 1, w + 1, h - 1);
                        break;
                    }
                    JTattooUtilities.fillHorGradient(g, colorArr, x + 1, y + 1, w - 1, h - 1);
                    break;
                }
                case 3: {
                    if (isSelected) {
                        Area clipArea = new Area(new RoundRectangle2D.Double(x, y - 4, w, h + 4, d, d));
                        Area rectArea = new Area(new Rectangle2D.Double(x, y - 2, w, h + 1));
                        clipArea.intersect(rectArea);
                        clipArea.intersect(orgClipArea);
                        g2D.setClip(clipArea);
                        JTattooUtilities.fillHorGradient(g, colorArr, x, y - 4, w, h + 4);
                        g2D.setClip(savedClip);
                        break;
                    }
                    Area clipArea = new Area(new RoundRectangle2D.Double(x, y - 4, w, h + 4, d, d));
                    Area rectArea = new Area(new Rectangle2D.Double(x, y, w, h));
                    clipArea.intersect(rectArea);
                    clipArea.intersect(orgClipArea);
                    g2D.setClip(clipArea);
                    JTattooUtilities.fillHorGradient(g, colorArr, x, y - 4, w, h + 4);
                    g2D.setClip(savedClip);
                    break;
                }
                case 4: {
                    if (isSelected) {
                        JTattooUtilities.fillHorGradient(g, colorArr, x - 2, y + 1, w + 2, h - 1);
                        break;
                    }
                    JTattooUtilities.fillHorGradient(g, colorArr, x, y + 1, w + 1, h - 1);
                }
            }
        }
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        int ht;
        int wt;
        int yt;
        int xt;
        int tabAreaHeight = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
        int tabAreaWidth = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
        if (this.tabPane.isOpaque()) {
            xt = tabPlacement == 4 ? w - tabAreaWidth : 0;
            yt = tabPlacement == 3 ? h - tabAreaHeight : 0;
            wt = tabPlacement == 1 || tabPlacement == 3 ? w : tabAreaWidth;
            ht = tabPlacement == 2 || tabPlacement == 4 ? h : tabAreaHeight;
            g.setColor(this.tabAreaBackground);
            g.fillRect(xt, yt, wt, ht);
        }
        if (this.isContentOpaque()) {
            xt = tabPlacement == 2 ? tabAreaWidth : 0;
            yt = tabPlacement == 1 ? tabAreaHeight : 0;
            wt = tabPlacement == 2 || tabPlacement == 4 ? w - tabAreaWidth : w;
            ht = tabPlacement == 1 || tabPlacement == 3 ? h - tabAreaHeight : h;
            g.setColor(this.tabPane.getBackground());
            g.fillRect(xt, yt, wt, ht);
        }
        Insets bi = new Insets(0, 0, 0, 0);
        if (this.tabPane.getBorder() != null) {
            bi = this.tabPane.getBorder().getBorderInsets(this.tabPane);
        }
        if (this.hasInnerBorder()) {
            ColorUIResource loColor = AbstractLookAndFeel.getControlDarkShadow();
            ColorUIResource hiColor = AbstractLookAndFeel.getControlHighlight();
            g.setColor(loColor);
            switch (tabPlacement) {
                case 1: {
                    int x1 = x + bi.left - 1;
                    int y1 = y + tabAreaHeight + bi.top - 2;
                    int x2 = x1 + w - bi.left - bi.right + 1;
                    int y2 = h - bi.bottom;
                    int ws = w - bi.left - bi.right + 1;
                    int hs = h - tabAreaHeight - bi.top - bi.bottom + 2;
                    if (this.tabPane.getBorder() == null) {
                        g.drawLine(x1, y1, x2, y1);
                        g.setColor(hiColor);
                        g.drawLine(x1, y1 + 1, x2, y1 + 1);
                        break;
                    }
                    g.drawRect(x1, y1, ws, hs);
                    g.setColor(hiColor);
                    g.drawLine(x1 + 1, y1 + 1, x2 - 1, y1 + 1);
                    break;
                }
                case 2: {
                    int x1 = x + tabAreaWidth + bi.left - 2;
                    int y1 = y + bi.top - 1;
                    int y2 = y1 + h - bi.top - bi.bottom + 1;
                    int ws = w - tabAreaWidth - bi.left - bi.right + 2;
                    int hs = h - bi.top - bi.bottom + 1;
                    if (this.tabPane.getBorder() == null) {
                        g.drawLine(x1, y1, x1, y2);
                        g.setColor(hiColor);
                        g.drawLine(x1 + 1, y1, x1 + 1, y2);
                        break;
                    }
                    g.drawRect(x1, y1, ws, hs);
                    g.setColor(hiColor);
                    g.drawLine(x1 + 1, y1 + 1, x1 + 1, y2 - 1);
                    break;
                }
                case 3: {
                    int x1 = x + bi.left - 1;
                    int y1 = y + bi.top - 1;
                    int x2 = x1 + w - bi.left - bi.right + 1;
                    int y2 = h - tabAreaHeight - bi.bottom;
                    int ws = w - bi.left - bi.right + 1;
                    int hs = h - tabAreaHeight - bi.top - bi.bottom + 2;
                    if (this.tabPane.getBorder() == null) {
                        g.drawLine(x1, y2, x2, y2);
                        break;
                    }
                    g.drawRect(x1, y1, ws, hs);
                    break;
                }
                case 4: {
                    int x1 = x + bi.left - 1;
                    int y1 = y + bi.top - 1;
                    int x2 = w - tabAreaWidth - bi.right + 1;
                    int y2 = y1 + h - bi.top - bi.bottom + 1;
                    int ws = w - tabAreaWidth - bi.left - bi.right + 2;
                    int hs = h - bi.top - bi.bottom + 1;
                    if (this.tabPane.getBorder() == null) {
                        g.drawLine(x2, y1, x2, y2);
                        break;
                    }
                    g.drawRect(x1, y1, ws, hs);
                    break;
                }
            }
        } else {
            int sepHeight = this.tabAreaInsets.bottom;
            if (sepHeight > 0) {
                switch (tabPlacement) {
                    case 1: {
                        Color[] colors = this.getContentBorderColors(tabPlacement);
                        int ys = y + tabAreaHeight - sepHeight + bi.top;
                        for (int i = 0; i < colors.length; ++i) {
                            g.setColor(colors[i]);
                            g.drawLine(x, ys + i, x + w, ys + i);
                        }
                        break;
                    }
                    case 2: {
                        Color[] colors = this.getContentBorderColors(tabPlacement);
                        int xs = x + tabAreaWidth - sepHeight + bi.left;
                        for (int i = 0; i < colors.length; ++i) {
                            g.setColor(colors[i]);
                            g.drawLine(xs + i, y, xs + i, y + h);
                        }
                        break;
                    }
                    case 3: {
                        Color[] colors = this.getContentBorderColors(tabPlacement);
                        int ys = y + h - tabAreaHeight - bi.bottom;
                        for (int i = 0; i < colors.length; ++i) {
                            g.setColor(colors[i]);
                            g.drawLine(x, ys + i, x + w, ys + i);
                        }
                        break;
                    }
                    case 4: {
                        Color[] colors = this.getContentBorderColors(tabPlacement);
                        int xs = x + w - tabAreaWidth - bi.right;
                        for (int i = 0; i < colors.length; ++i) {
                            g.setColor(colors[i]);
                            g.drawLine(xs + i, y, xs + i, y + h);
                        }
                        break;
                    }
                }
            }
        }
    }

    protected void paintScrollContentBorder(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Insets bi = new Insets(0, 0, 0, 0);
        if (this.tabPane.getBorder() != null) {
            bi = this.tabPane.getBorder().getBorderInsets(this.tabPane);
        }
        if (this.tabPane.getTabPlacement() == 1) {
            this.paintContentBorder(g, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex(), x, y - bi.top, w, h);
        } else if (this.tabPane.getTabPlacement() == 3) {
            this.paintContentBorder(g, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex(), x, y + bi.bottom, w, h);
        } else if (this.tabPane.getTabPlacement() == 2) {
            this.paintContentBorder(g, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex(), x - bi.left, y, w, h);
        } else if (this.tabPane.getTabPlacement() == 4) {
            this.paintContentBorder(g, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex(), x + bi.right, y, w, h);
        }
    }

    private void ensureCurrentLayout() {
        ((TabbedPaneLayout)this.tabPane.getLayout()).calculateLayoutInfo();
    }

    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        this.ensureCurrentLayout();
        Rectangle tabRect = new Rectangle();
        return this.getTabBounds(i, tabRect);
    }

    public int getTabRunCount(JTabbedPane pane) {
        this.ensureCurrentLayout();
        return this.runCount;
    }

    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        this.ensureCurrentLayout();
        Point p = new Point(x, y);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(x, y, p);
        }
        int tc = this.tabPane.getTabCount();
        for (int i = 0; i < tc; ++i) {
            if (!this.rects[i].contains(p.x, p.y)) continue;
            return i;
        }
        return -1;
    }

    protected Rectangle getTabBounds(int tabIndex, Rectangle dest) {
        dest.width = this.rects[tabIndex].width;
        dest.height = this.rects[tabIndex].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point vpp = this.tabScroller.viewport.getLocation();
            Point viewp = this.tabScroller.viewport.getViewPosition();
            dest.x = this.rects[tabIndex].x + vpp.x - viewp.x;
            dest.y = this.rects[tabIndex].y + vpp.y - viewp.y;
        } else {
            dest.x = this.rects[tabIndex].x;
            dest.y = this.rects[tabIndex].y;
        }
        return dest;
    }

    protected int getTabAtLocation(int x, int y) {
        this.ensureCurrentLayout();
        int tc = this.tabPane.getTabCount();
        for (int i = 0; i < tc; ++i) {
            if (!this.rects[i].contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    protected int getClosestTab(int x, int y) {
        int want;
        int tc;
        int min = 0;
        int max = tc = Math.min(this.rects.length, this.tabPane.getTabCount());
        int tabPlacement = this.tabPane.getTabPlacement();
        boolean useX = tabPlacement == 1 || tabPlacement == 3;
        int n = want = useX ? x : y;
        while (min != max) {
            int maxLoc;
            int minLoc;
            int current = (max + min) / 2;
            if (useX) {
                minLoc = this.rects[current].x;
                maxLoc = minLoc + this.rects[current].width;
            } else {
                minLoc = this.rects[current].y;
                maxLoc = minLoc + this.rects[current].height;
            }
            if (want < minLoc) {
                max = current;
                if (min != max) continue;
                return Math.max(0, current - 1);
            }
            if (want >= maxLoc) {
                min = current;
                if (max - min > 1) continue;
                return Math.max(current + 1, tc - 1);
            }
            return current;
        }
        return min;
    }

    private Point translatePointToTabPanel(int srcx, int srcy, Point dest) {
        Point vpp = this.tabScroller.viewport.getLocation();
        Point viewp = this.tabScroller.viewport.getViewPosition();
        dest.x = srcx - vpp.x + viewp.x;
        dest.y = srcy - vpp.y + viewp.y;
        return dest;
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this.tabPane) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected void assureRectsCreated(int tabCount) {
        int rectArrayLen = this.rects.length;
        if (tabCount != rectArrayLen) {
            Rectangle[] tempRectArray = new Rectangle[tabCount];
            System.arraycopy(this.rects, 0, tempRectArray, 0, Math.min(rectArrayLen, tabCount));
            this.rects = tempRectArray;
            for (int rectIndex = rectArrayLen; rectIndex < tabCount; ++rectIndex) {
                this.rects[rectIndex] = new Rectangle();
            }
        }
    }

    protected void expandTabRunsArray() {
        int rectLen = this.tabRuns.length;
        int[] newArray = new int[rectLen + 10];
        System.arraycopy(this.tabRuns, 0, newArray, 0, this.runCount);
        this.tabRuns = newArray;
    }

    protected int getRunForTab(int tabCount, int tabIndex) {
        for (int i = 0; i < this.runCount; ++i) {
            int first = this.tabRuns[i];
            int last = this.lastTabInRun(tabCount, i);
            if (tabIndex < first || tabIndex > last) continue;
            return i;
        }
        return 0;
    }

    protected int lastTabInRun(int tabCount, int run) {
        int nextRun;
        if (this.runCount == 1) {
            return tabCount - 1;
        }
        int n = nextRun = run == this.runCount - 1 ? 0 : run + 1;
        if (this.tabRuns[nextRun] == 0) {
            return tabCount - 1;
        }
        return this.tabRuns[nextRun] - 1;
    }

    protected int getTabRunOverlay(int tabPlacement) {
        return this.tabRunOverlay;
    }

    protected int getTabRunIndent(int tabPlacement, int run) {
        return 0;
    }

    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return this.runCount > 1;
    }

    protected boolean shouldRotateTabRuns(int tabPlacement) {
        return true;
    }

    protected Icon getIconForTab(int tabIndex) {
        if (tabIndex >= 0 && tabIndex < this.tabCount) {
            return !this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(tabIndex) ? this.tabPane.getDisabledIconAt(tabIndex) : this.tabPane.getIconAt(tabIndex);
        }
        return null;
    }

    protected View getTextViewForTab(int tabIndex) {
        if (this.htmlViews != null && this.htmlViews.size() > tabIndex) {
            return (View)this.htmlViews.get(tabIndex);
        }
        return null;
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        int height = 0;
        Component tabComponent = this.getTabComponentAt(tabIndex);
        if (tabComponent != null) {
            height = tabComponent.getPreferredSize().height;
        } else {
            View v = this.getTextViewForTab(tabIndex);
            height = v != null ? (height += (int)v.getPreferredSpan(1)) : (height += fontHeight);
            Icon icon = this.getIconForTab(tabIndex);
            if (icon != null) {
                height = Math.max(height, icon.getIconHeight());
            }
        }
        Insets ti = this.getTabInsets(tabPlacement, tabIndex);
        return height += ti.top + ti.bottom + 2;
    }

    protected int calculateMaxTabHeight(int tabPlacement) {
        int tc = this.tabPane.getTabCount();
        int result = 0;
        int fontHeight = this.getFontMetrics().getHeight();
        for (int i = 0; i < tc; ++i) {
            result = Math.max(this.calculateTabHeight(tabPlacement, i, fontHeight), result);
        }
        return result;
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        Insets insets = this.getTabInsets(tabPlacement, tabIndex);
        int width = insets.left + insets.right + 3;
        Component tabComponent = this.getTabComponentAt(tabIndex);
        if (tabComponent != null) {
            width += tabComponent.getPreferredSize().width;
        } else {
            View v;
            Icon icon = this.getIconForTab(tabIndex);
            if (icon != null) {
                width += icon.getIconWidth() + this.textIconGap;
            }
            if ((v = this.getTextViewForTab(tabIndex)) != null) {
                width += (int)v.getPreferredSpan(0);
            } else {
                String title = this.tabPane.getTitleAt(tabIndex);
                width += SwingUtilities.computeStringWidth(metrics, title);
            }
        }
        return width;
    }

    protected int calculateMaxTabWidth(int tabPlacement) {
        int tc = this.tabPane.getTabCount();
        int result = 0;
        for (int i = 0; i < tc; ++i) {
            result = Math.max(this.calculateTabWidth(tabPlacement, i, this.getFontMetrics()), result);
        }
        return result;
    }

    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        if (tabPlacement == 1 || tabPlacement == 3) {
            Insets insets = this.getTabAreaInsets(tabPlacement);
            int overlay = this.getTabRunOverlay(tabPlacement);
            return horizRunCount > 0 ? horizRunCount * (maxTabHeight - overlay) + overlay + insets.top + insets.bottom : 0;
        }
        return this.tabPane.getHeight();
    }

    protected int calculateTabAreaWidth(int tabPlacement, int vertRunCount, int maxTabWidth) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            Insets insets = this.getTabAreaInsets(tabPlacement);
            int overlay = this.getTabRunOverlay(tabPlacement);
            return vertRunCount > 0 ? vertRunCount * (maxTabWidth - overlay) + overlay + insets.left + insets.right : 0;
        }
        return this.tabPane.getWidth();
    }

    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        return this.tabInsets;
    }

    protected Insets getSelectedTabPadInsets(int tabPlacement) {
        BaseTabbedPaneUI.rotateInsets(this.selectedTabPadInsets, this.currentPadInsets, tabPlacement);
        return this.currentPadInsets;
    }

    protected Insets getTabAreaInsets(int tabPlacement) {
        BaseTabbedPaneUI.rotateInsets(this.tabAreaInsets, this.currentTabAreaInsets, tabPlacement);
        return this.currentTabAreaInsets;
    }

    protected Insets getContentBorderInsets(int tabPlacement) {
        if (this.tabPane.getBorder() == null) {
            return NULL_BORDER_INSETS;
        }
        return this.contentBorderInsets;
    }

    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont().deriveFont(1);
        return JTattooUtilities.getFontMetrics(this.tabPane, null, font);
    }

    protected void navigateSelectedTab(int direction) {
        int tabPlacement = this.tabPane.getTabPlacement();
        int current = this.tabPane.getSelectedIndex();
        int tc = this.tabPane.getTabCount();
        boolean leftToRight = JTattooUtilities.isLeftToRight(this.tabPane);
        if (tc <= 0) {
            return;
        }
        block0 : switch (tabPlacement) {
            case 12: {
                this.selectNextTab(current);
                break;
            }
            case 13: {
                this.selectPreviousTab(current);
                break;
            }
            case 2: 
            case 4: {
                switch (direction) {
                    case 1: {
                        this.selectPreviousTabInRun(current);
                        break block0;
                    }
                    case 5: {
                        this.selectNextTabInRun(current);
                        break block0;
                    }
                    case 7: {
                        int offset = this.getTabRunOffset(tabPlacement, tc, current, false);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 3: {
                        int offset = this.getTabRunOffset(tabPlacement, tc, current, true);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (direction) {
                    case 1: {
                        int offset = this.getTabRunOffset(tabPlacement, tc, current, false);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 5: {
                        int offset = this.getTabRunOffset(tabPlacement, tc, current, true);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 3: {
                        if (leftToRight) {
                            this.selectNextTabInRun(current);
                            break block0;
                        }
                        this.selectPreviousTabInRun(current);
                        break block0;
                    }
                    case 7: {
                        if (leftToRight) {
                            this.selectPreviousTabInRun(current);
                            break block0;
                        }
                        this.selectNextTabInRun(current);
                        break block0;
                    }
                }
            }
        }
    }

    protected void selectNextTabInRun(int current) {
        int tc = this.tabPane.getTabCount();
        int tabIndex = this.getNextTabIndexInRun(tc, current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getNextTabIndexInRun(tc, tabIndex);
        }
        this.tabPane.setSelectedIndex(tabIndex);
    }

    protected void selectPreviousTabInRun(int current) {
        int tc = this.tabPane.getTabCount();
        int tabIndex = this.getPreviousTabIndexInRun(tc, current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getPreviousTabIndexInRun(tc, tabIndex);
        }
        this.tabPane.setSelectedIndex(tabIndex);
    }

    protected void selectNextTab(int current) {
        int tabIndex = this.getNextTabIndex(current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getNextTabIndex(tabIndex);
        }
        this.tabPane.setSelectedIndex(tabIndex);
    }

    protected void selectPreviousTab(int current) {
        int tabIndex = this.getPreviousTabIndex(current);
        while (tabIndex != current && !this.tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getPreviousTabIndex(tabIndex);
        }
        this.tabPane.setSelectedIndex(tabIndex);
    }

    protected void selectAdjacentRunTab(int tabPlacement, int tabIndex, int offset) {
        int newIndex;
        if (this.runCount < 2) {
            return;
        }
        Rectangle r = this.rects[tabIndex];
        switch (tabPlacement) {
            case 2: 
            case 4: {
                newIndex = this.getTabAtLocation(r.x + r.width / 2 + offset, r.y + r.height / 2);
                break;
            }
            default: {
                newIndex = this.getTabAtLocation(r.x + r.width / 2, r.y + r.height / 2 + offset);
            }
        }
        if (newIndex != -1) {
            while (!this.tabPane.isEnabledAt(newIndex) && newIndex != tabIndex) {
                newIndex = this.getNextTabIndex(newIndex);
            }
            this.tabPane.setSelectedIndex(newIndex);
        }
    }

    protected int getTabRunOffset(int tabPlacement, int tabCount, int tabIndex, boolean forward) {
        int offset;
        int run = this.getRunForTab(tabCount, tabIndex);
        switch (tabPlacement) {
            case 2: {
                if (run == 0) {
                    offset = forward ? -(this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                if (run == this.runCount - 1) {
                    offset = forward ? this.maxTabWidth : this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                offset = forward ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 4: {
                if (run == 0) {
                    offset = forward ? this.maxTabWidth : this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                if (run == this.runCount - 1) {
                    offset = forward ? -(this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                offset = forward ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 3: {
                if (run == 0) {
                    offset = forward ? this.maxTabHeight : this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight;
                    break;
                }
                if (run == this.runCount - 1) {
                    offset = forward ? -(this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight;
                    break;
                }
                offset = forward ? this.maxTabHeight : -this.maxTabHeight;
                break;
            }
            default: {
                offset = run == 0 ? (forward ? -(this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight) : (run == this.runCount - 1 ? (forward ? this.maxTabHeight : this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - this.maxTabHeight) : (forward ? this.maxTabHeight : -this.maxTabHeight));
            }
        }
        return offset;
    }

    protected int getPreviousTabIndex(int base) {
        int tabIndex = base - 1 >= 0 ? base - 1 : this.tabPane.getTabCount() - 1;
        return tabIndex >= 0 ? tabIndex : 0;
    }

    protected int getNextTabIndex(int base) {
        return (base + 1) % this.tabPane.getTabCount();
    }

    protected int getNextTabIndexInRun(int tabCount, int base) {
        if (this.runCount < 2) {
            return this.getNextTabIndex(base);
        }
        int currentRun = this.getRunForTab(tabCount, base);
        int next = this.getNextTabIndex(base);
        if (next == this.tabRuns[this.getNextTabRun(currentRun)]) {
            return this.tabRuns[currentRun];
        }
        return next;
    }

    protected int getPreviousTabIndexInRun(int tabCount, int base) {
        if (this.runCount < 2) {
            return this.getPreviousTabIndex(base);
        }
        int currentRun = this.getRunForTab(tabCount, base);
        if (base == this.tabRuns[currentRun]) {
            int previous = this.tabRuns[this.getNextTabRun(currentRun)] - 1;
            return previous != -1 ? previous : tabCount - 1;
        }
        return this.getPreviousTabIndex(base);
    }

    protected int getPreviousTabRun(int baseRun) {
        int runIndex = baseRun - 1 >= 0 ? baseRun - 1 : this.runCount - 1;
        return runIndex >= 0 ? runIndex : 0;
    }

    protected int getNextTabRun(int baseRun) {
        return (baseRun + 1) % this.runCount;
    }

    protected static void rotateInsets(Insets topInsets, Insets targetInsets, int targetPlacement) {
        switch (targetPlacement) {
            case 2: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.top;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.bottom;
                break;
            }
            case 3: {
                targetInsets.top = topInsets.bottom;
                targetInsets.left = topInsets.left;
                targetInsets.bottom = topInsets.top;
                targetInsets.right = topInsets.right;
                break;
            }
            case 4: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.bottom;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.top;
                break;
            }
            default: {
                targetInsets.top = topInsets.top;
                targetInsets.left = topInsets.left;
                targetInsets.bottom = topInsets.bottom;
                targetInsets.right = topInsets.right;
            }
        }
    }

    protected boolean requestFocusForVisibleComponent() {
        Component vc = this.getVisibleComponent();
        if (vc.isFocusTraversable()) {
            vc.requestFocus();
            return true;
        }
        return vc instanceof JComponent && ((JComponent)vc).requestDefaultFocus();
    }

    private ArrayList createHTMLViewList() {
        ArrayList<View> viewList = new ArrayList<View>();
        int count = this.tabPane.getTabCount();
        for (int i = 0; i < count; ++i) {
            String title = this.tabPane.getTitleAt(i);
            if (BasicHTML.isHTMLString(title)) {
                viewList.add(BasicHTML.createHTMLView(this.tabPane, title));
                continue;
            }
            viewList.add(null);
        }
        return viewList;
    }

    private class TabContainer
    extends JPanel
    implements UIResource {
        private boolean notifyTabbedPane = true;

        public TabContainer() {
            super(null);
            this.setOpaque(false);
        }

        public void remove(Component comp) {
            int index = BaseTabbedPaneUI.this.tabPane.indexOfTabComponent(comp);
            PropertyChangeListener[] listeners = comp.getPropertyChangeListeners();
            for (int j = 0; j < listeners.length; ++j) {
                if (!(listeners[j] instanceof MyTabComponentListener)) continue;
                comp.removePropertyChangeListener(listeners[j]);
            }
            super.remove(comp);
            if (this.notifyTabbedPane && index != -1) {
                BaseTabbedPaneUI.this.tabPane.setTabComponentAt(index, null);
            }
        }

        private void removeUnusedTabComponents() {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                int index;
                Component c = this.getComponent(i);
                if (c instanceof UIResource || (index = BaseTabbedPaneUI.this.tabPane.indexOfTabComponent(c)) != -1) continue;
                PropertyChangeListener[] listeners = c.getPropertyChangeListeners();
                for (int j = 0; j < listeners.length; ++j) {
                    if (!(listeners[j] instanceof MyTabComponentListener)) continue;
                    c.removePropertyChangeListener(listeners[j]);
                }
                super.remove(c);
            }
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        public void componentAdded(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            TabbedPaneLayout layout = (TabbedPaneLayout)tp.getLayout();
            layout.layoutContainer(tp);
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            int index = tp.indexOfComponent(child);
            String title = tp.getTitleAt(index);
            boolean isHTML = BasicHTML.isHTMLString(title);
            if (isHTML) {
                if (BaseTabbedPaneUI.this.htmlViews == null) {
                    BaseTabbedPaneUI.this.htmlViews = BaseTabbedPaneUI.this.createHTMLViewList();
                } else {
                    View v = BasicHTML.createHTMLView(tp, title);
                    BaseTabbedPaneUI.this.htmlViews.add(index, v);
                }
            } else if (BaseTabbedPaneUI.this.htmlViews != null) {
                BaseTabbedPaneUI.this.htmlViews.add(index, null);
            }
        }

        public void componentRemoved(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            Integer indexObj = (Integer)tp.getClientProperty("__index_to_remove__");
            if (indexObj != null) {
                int index = indexObj;
                if (BaseTabbedPaneUI.this.htmlViews != null && BaseTabbedPaneUI.this.htmlViews.size() >= index) {
                    BaseTabbedPaneUI.this.htmlViews.remove(index);
                }
            }
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        public void focusGained(FocusEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            int tabCount = tabPane.getTabCount();
            int selectedIndex = tabPane.getSelectedIndex();
            if (selectedIndex != -1 && tabCount > 0 && tabCount == BaseTabbedPaneUI.this.rects.length) {
                tabPane.repaint(BaseTabbedPaneUI.this.getTabBounds(tabPane, selectedIndex));
            }
        }

        public void focusLost(FocusEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            int tabCount = tabPane.getTabCount();
            int selectedIndex = tabPane.getSelectedIndex();
            if (selectedIndex != -1 && tabCount > 0 && tabCount == BaseTabbedPaneUI.this.rects.length) {
                tabPane.repaint(BaseTabbedPaneUI.this.getTabBounds(tabPane, selectedIndex));
            }
        }
    }

    public class MouseMotionHandler
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent e) {
            if (BaseTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                MouseMotionListener[] mml = BaseTabbedPaneUI.this.tabPane.getMouseMotionListeners();
                for (int i = 0; i < mml.length; ++i) {
                    mml[i].mouseDragged(e);
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (BaseTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                MouseMotionListener[] mml = BaseTabbedPaneUI.this.tabPane.getMouseMotionListeners();
                for (int i = 0; i < mml.length; ++i) {
                    mml[i].mouseMoved(e);
                }
            }
            BaseTabbedPaneUI.this.rolloverIndex = BaseTabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY());
            if (BaseTabbedPaneUI.this.rolloverIndex != BaseTabbedPaneUI.this.oldRolloverIndex) {
                if (BaseTabbedPaneUI.this.oldRolloverIndex >= 0 && BaseTabbedPaneUI.this.oldRolloverIndex < BaseTabbedPaneUI.this.tabPane.getTabCount()) {
                    BaseTabbedPaneUI.this.tabPane.repaint(BaseTabbedPaneUI.this.getTabBounds(BaseTabbedPaneUI.this.tabPane, BaseTabbedPaneUI.this.oldRolloverIndex));
                }
                if (BaseTabbedPaneUI.this.rolloverIndex >= 0 && BaseTabbedPaneUI.this.rolloverIndex < BaseTabbedPaneUI.this.tabPane.getTabCount()) {
                    BaseTabbedPaneUI.this.tabPane.repaint(BaseTabbedPaneUI.this.getTabBounds(BaseTabbedPaneUI.this.tabPane, BaseTabbedPaneUI.this.rolloverIndex));
                }
                BaseTabbedPaneUI.this.oldRolloverIndex = BaseTabbedPaneUI.this.rolloverIndex;
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if (BaseTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                MouseListener[] ml = BaseTabbedPaneUI.this.tabPane.getMouseListeners();
                for (int i = 0; i < ml.length; ++i) {
                    ml[i].mouseClicked(e);
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            if (BaseTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                MouseListener[] ml = BaseTabbedPaneUI.this.tabPane.getMouseListeners();
                for (int i = 0; i < ml.length; ++i) {
                    ml[i].mousePressed(e);
                }
            }
            if (!BaseTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = BaseTabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY());
            if (tabIndex >= 0 && BaseTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                if (tabIndex == BaseTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    if (BaseTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                        BaseTabbedPaneUI.this.tabPane.requestFocus();
                        BaseTabbedPaneUI.this.tabPane.repaint(BaseTabbedPaneUI.this.getTabBounds(BaseTabbedPaneUI.this.tabPane, tabIndex));
                    }
                } else {
                    BaseTabbedPaneUI.this.tabPane.setSelectedIndex(tabIndex);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (BaseTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                MouseListener[] ml = BaseTabbedPaneUI.this.tabPane.getMouseListeners();
                for (int i = 0; i < ml.length; ++i) {
                    ml[i].mouseReleased(e);
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (BaseTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                MouseListener[] ml = BaseTabbedPaneUI.this.tabPane.getMouseListeners();
                for (int i = 0; i < ml.length; ++i) {
                    ml[i].mouseEntered(e);
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            if (BaseTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                MouseListener[] ml = BaseTabbedPaneUI.this.tabPane.getMouseListeners();
                for (int i = 0; i < ml.length; ++i) {
                    ml[i].mouseExited(e);
                }
            }
            BaseTabbedPaneUI.this.rolloverIndex = -1;
            if (BaseTabbedPaneUI.this.rolloverIndex != BaseTabbedPaneUI.this.oldRolloverIndex) {
                if (BaseTabbedPaneUI.this.oldRolloverIndex >= 0 && BaseTabbedPaneUI.this.oldRolloverIndex < BaseTabbedPaneUI.this.tabPane.getTabCount()) {
                    BaseTabbedPaneUI.this.tabPane.repaint(BaseTabbedPaneUI.this.getTabBounds(BaseTabbedPaneUI.this.tabPane, BaseTabbedPaneUI.this.oldRolloverIndex));
                }
                if (BaseTabbedPaneUI.this.rolloverIndex >= 0 && BaseTabbedPaneUI.this.rolloverIndex < BaseTabbedPaneUI.this.tabPane.getTabCount()) {
                    BaseTabbedPaneUI.this.tabPane.repaint(BaseTabbedPaneUI.this.getTabBounds(BaseTabbedPaneUI.this.tabPane, BaseTabbedPaneUI.this.rolloverIndex));
                }
                BaseTabbedPaneUI.this.oldRolloverIndex = BaseTabbedPaneUI.this.rolloverIndex;
            }
        }
    }

    public class TabComponentHandler
    implements ComponentListener {
        public void componentResized(ComponentEvent ce) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (((TabComponentHandler)TabComponentHandler.this).BaseTabbedPaneUI.this.tabPane != null) {
                        ((TabComponentHandler)TabComponentHandler.this).BaseTabbedPaneUI.this.tabPane.doLayout();
                    }
                }
            });
        }

        public void componentMoved(ComponentEvent ce) {
        }

        public void componentShown(ComponentEvent ce) {
        }

        public void componentHidden(ComponentEvent ce) {
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            int index;
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            if (JTattooUtilities.getJavaVersion() >= 1.4 && tabPane.getTabLayoutPolicy() == 1 && (index = tabPane.getSelectedIndex()) >= 0) {
                BaseTabbedPaneUI ui = (BaseTabbedPaneUI)tabPane.getUI();
                ui.tabScroller.scrollTabToVisible(tabPane.getTabPlacement(), index);
            }
            tabPane.revalidate();
            tabPane.repaint();
        }
    }

    public class MyTabComponentListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            if ("font".equals(evt.getPropertyName()) || "text".equals(evt.getPropertyName())) {
                BaseTabbedPaneUI.this.tabPane.revalidate();
                BaseTabbedPaneUI.this.tabPane.repaint();
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            String name = e.getPropertyName();
            boolean isScrollLayout = BaseTabbedPaneUI.this.scrollableTabLayoutEnabled();
            if ("mnemonicAt".equals(name)) {
                BaseTabbedPaneUI.this.updateMnemonics();
                pane.repaint();
            } else if ("displayedMnemonicIndexAt".equals(name)) {
                pane.repaint();
            } else if ("indexForTitle".equals(name)) {
                int index = (Integer)e.getNewValue();
                String title = BaseTabbedPaneUI.this.tabPane.getTitleAt(index);
                if (BasicHTML.isHTMLString(title)) {
                    if (BaseTabbedPaneUI.this.htmlViews == null) {
                        BaseTabbedPaneUI.this.htmlViews = BaseTabbedPaneUI.this.createHTMLViewList();
                    } else {
                        View v = BasicHTML.createHTMLView(BaseTabbedPaneUI.this.tabPane, title);
                        BaseTabbedPaneUI.this.htmlViews.set(index, v);
                    }
                } else if (BaseTabbedPaneUI.this.htmlViews != null && BaseTabbedPaneUI.this.htmlViews.get(index) != null) {
                    BaseTabbedPaneUI.this.htmlViews.set(index, null);
                }
                BaseTabbedPaneUI.this.updateMnemonics();
            } else if ("tabLayoutPolicy".equals(name)) {
                BaseTabbedPaneUI.this.uninstallUI(pane);
                BaseTabbedPaneUI.this.installUI(pane);
            } else if ("background".equals(name) && isScrollLayout) {
                Color newVal = (Color)e.getNewValue();
                ((BaseTabbedPaneUI)BaseTabbedPaneUI.this).tabScroller.tabPanel.setBackground(newVal);
                ((BaseTabbedPaneUI)BaseTabbedPaneUI.this).tabScroller.viewport.setBackground(newVal);
                Color newColor = BaseTabbedPaneUI.this.selectedColor == null ? newVal : BaseTabbedPaneUI.this.selectedColor;
                ((BaseTabbedPaneUI)BaseTabbedPaneUI.this).tabScroller.scrollForwardButton.setBackground(newColor);
                ((BaseTabbedPaneUI)BaseTabbedPaneUI.this).tabScroller.scrollBackwardButton.setBackground(newColor);
            } else if ("indexForTabComponent".equals(name)) {
                if (BaseTabbedPaneUI.this.tabContainer != null) {
                    BaseTabbedPaneUI.this.tabContainer.removeUnusedTabComponents();
                }
                try {
                    Component tabComponent = BaseTabbedPaneUI.this.getTabComponentAt((Integer)e.getNewValue());
                    if (tabComponent != null) {
                        if (BaseTabbedPaneUI.this.tabContainer == null) {
                            BaseTabbedPaneUI.this.installTabContainer();
                        } else {
                            BaseTabbedPaneUI.this.addMyPropertyChangeListeners(tabComponent);
                            BaseTabbedPaneUI.this.tabContainer.add(tabComponent);
                        }
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                BaseTabbedPaneUI.this.tabPane.revalidate();
                BaseTabbedPaneUI.this.tabPane.repaint();
            } else if ("componentOrientation".equals(name)) {
                pane.revalidate();
                pane.repaint();
            } else if ("tabAreaBackground".equals(name)) {
                pane.revalidate();
                pane.repaint();
            }
        }
    }

    private class ScrollablePopupMenuTabButton
    extends ArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollablePopupMenuTabButton() {
            super(5);
        }
    }

    private class ScrollableTabButton
    extends ArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollableTabButton(int direction) {
            super(direction);
        }

        public boolean scrollsForward() {
            return this.direction == 3 || this.direction == 5;
        }
    }

    public class ArrowButton
    extends JButton
    implements SwingConstants {
        protected int direction;

        public ArrowButton(int direction) {
            this.direction = direction;
            this.setRequestFocusEnabled(false);
            if (BaseTabbedPaneUI.this.simpleButtonBorder) {
                Color cLo = BaseTabbedPaneUI.this.getLoBorderColor(0);
                ColorUIResource cHi = AbstractLookAndFeel.getTheme().getControlHighlight();
                this.setBorder(BorderFactory.createEtchedBorder(cHi, cLo));
            }
        }

        public int getDirection() {
            return this.direction;
        }

        public void setDirection(int dir) {
            this.direction = dir;
        }

        public void paint(Graphics g) {
            super.paint(g);
            int w = this.getSize().width;
            int h = this.getSize().height;
            int size = Math.min((h - 4) / 3, (w - 4) / 3);
            size = Math.max(size, 2);
            this.paintTriangle(g, (w - size) / 2 + 1, (h - size) / 2 + 1, size);
        }

        public Dimension getPreferredSize() {
            return new Dimension(17, 17);
        }

        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void paintTriangle(Graphics g, int x, int y, int size) {
            Color oldColor = g.getColor();
            size = Math.max(size, 2);
            int mid = size / 2 - 1;
            ColorUIResource enabledColor = AbstractLookAndFeel.getTheme().getButtonForegroundColor();
            ColorUIResource disabledColor = AbstractLookAndFeel.getTheme().getDisabledForegroundColor();
            g.translate(x, y);
            if (this.isEnabled()) {
                g.setColor(enabledColor);
            } else {
                g.setColor(disabledColor);
            }
            switch (this.direction) {
                case 1: {
                    for (int i = 0; i < size; ++i) {
                        g.drawLine(mid - i, i, mid + i, i);
                    }
                    break;
                }
                case 5: {
                    int j = 0;
                    for (int i = size - 1; i >= 0; --i) {
                        g.drawLine(mid - i, j, mid + i, j);
                        ++j;
                    }
                    break;
                }
                case 7: {
                    for (int i = 0; i < size; ++i) {
                        g.drawLine(i, mid - i, i, mid + i);
                    }
                    break;
                }
                case 3: {
                    int j = 0;
                    for (int i = size - 1; i >= 0; --i) {
                        g.drawLine(j, mid - i, j, mid + i);
                        ++j;
                    }
                    break;
                }
            }
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    private class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            this.setLayout(null);
            this.setOpaque(false);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            BaseTabbedPaneUI.this.paintScrollContentBorder(g, BaseTabbedPaneUI.this.tabPane.getTabPlacement(), BaseTabbedPaneUI.this.tabPane.getSelectedIndex(), 0, 0, this.getWidth(), this.getHeight());
            BaseTabbedPaneUI.this.paintTabArea(g, BaseTabbedPaneUI.this.tabPane.getTabPlacement(), BaseTabbedPaneUI.this.tabPane.getSelectedIndex());
        }

        public void doLayout() {
            if (this.getComponentCount() > 0) {
                Component child = this.getComponent(0);
                child.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    private class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setScrollMode(0);
            this.setOpaque(false);
        }
    }

    private class ScrollableTabSupport
    implements ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public ScrollableTabButton scrollForwardButton;
        public ScrollableTabButton scrollBackwardButton;
        public ScrollablePopupMenuTabButton popupMenuButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int tabPlacement) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            if (tabPlacement == 1 || tabPlacement == 3) {
                this.scrollForwardButton = new ScrollableTabButton(3);
                this.scrollBackwardButton = new ScrollableTabButton(7);
            } else {
                this.scrollForwardButton = new ScrollableTabButton(5);
                this.scrollBackwardButton = new ScrollableTabButton(1);
            }
            this.popupMenuButton = new ScrollablePopupMenuTabButton();
        }

        public void scrollForward(int tabPlacement) {
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            if (tabPlacement == 1 || tabPlacement == 3 ? viewRect.width >= viewSize.width - viewRect.x : viewRect.height >= viewSize.height - viewRect.y) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex + 1);
            if (BaseTabbedPaneUI.this.tabPane != null) {
                BaseTabbedPaneUI.this.tabPane.doLayout();
            }
        }

        public void scrollBackward(int tabPlacement) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex - 1);
            if (BaseTabbedPaneUI.this.tabPane != null) {
                BaseTabbedPaneUI.this.tabPane.doLayout();
            }
        }

        public void scrollTabToVisible(int tabPlacement, int index) {
            if (index <= this.leadingTabIndex) {
                this.setLeadingTabIndex(tabPlacement, index);
            } else {
                Rectangle viewRect = this.viewport.getViewRect();
                switch (tabPlacement) {
                    case 1: 
                    case 3: {
                        int i = index;
                        int x = viewRect.width - BaseTabbedPaneUI.this.rects[index].width;
                        while (i > 0 && x - BaseTabbedPaneUI.this.rects[i - 1].width >= 0) {
                            x -= BaseTabbedPaneUI.this.rects[--i].width;
                        }
                        if (this.leadingTabIndex >= i) break;
                        this.setLeadingTabIndex(tabPlacement, i);
                        break;
                    }
                    case 2: 
                    case 4: {
                        int i = index;
                        int y = viewRect.height - BaseTabbedPaneUI.this.rects[index].height;
                        while (i > 0 && y - BaseTabbedPaneUI.this.rects[i - 1].height > 0) {
                            y -= BaseTabbedPaneUI.this.rects[--i].height;
                        }
                        if (this.leadingTabIndex >= i) break;
                        this.setLeadingTabIndex(tabPlacement, i);
                        break;
                    }
                }
            }
        }

        public void setLeadingTabIndex(int tabPlacement, int index) {
            this.leadingTabIndex = index;
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            switch (tabPlacement) {
                case 1: 
                case 3: {
                    int n = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : BaseTabbedPaneUI.this.rects[this.leadingTabIndex].x;
                    if (viewSize.width - this.tabViewPosition.x >= viewRect.width) break;
                    Dimension extentSize = new Dimension(viewSize.width - this.tabViewPosition.x, viewRect.height);
                    this.viewport.setExtentSize(extentSize);
                    break;
                }
                case 2: 
                case 4: {
                    int n = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : BaseTabbedPaneUI.this.rects[this.leadingTabIndex].y;
                    if (viewSize.height - this.tabViewPosition.y >= viewRect.height) break;
                    Dimension extentSize = new Dimension(viewRect.width, viewSize.height - this.tabViewPosition.y);
                    this.viewport.setExtentSize(extentSize);
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        public void stateChanged(ChangeEvent e) {
            JViewport vp = (JViewport)e.getSource();
            int tabPlacement = BaseTabbedPaneUI.this.tabPane.getTabPlacement();
            int tc = BaseTabbedPaneUI.this.tabPane.getTabCount();
            Rectangle vpRect = vp.getBounds();
            Dimension viewSize = vp.getViewSize();
            Rectangle viewRect = vp.getViewRect();
            this.leadingTabIndex = BaseTabbedPaneUI.this.getClosestTab(viewRect.x, viewRect.y);
            if (this.leadingTabIndex >= BaseTabbedPaneUI.this.rects.length) {
                return;
            }
            if (this.leadingTabIndex + 1 < tc) {
                switch (tabPlacement) {
                    case 1: 
                    case 3: {
                        if (BaseTabbedPaneUI.this.rects[this.leadingTabIndex].x >= viewRect.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (BaseTabbedPaneUI.this.rects[this.leadingTabIndex].y >= viewRect.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets contentInsets = BaseTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            switch (tabPlacement) {
                case 2: {
                    BaseTabbedPaneUI.this.tabPane.repaint(vpRect.x + vpRect.width, vpRect.y, contentInsets.left, vpRect.height);
                    this.scrollBackwardButton.setEnabled(viewRect.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tc - 1 && viewSize.height - viewRect.y > viewRect.height);
                    break;
                }
                case 4: {
                    BaseTabbedPaneUI.this.tabPane.repaint(vpRect.x - contentInsets.right, vpRect.y, contentInsets.right, vpRect.height);
                    this.scrollBackwardButton.setEnabled(viewRect.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tc - 1 && viewSize.height - viewRect.y > viewRect.height);
                    break;
                }
                case 3: {
                    BaseTabbedPaneUI.this.tabPane.repaint(vpRect.x, vpRect.y - contentInsets.bottom, vpRect.width, contentInsets.bottom);
                    this.scrollBackwardButton.setEnabled(viewRect.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tc - 1 && viewSize.width - viewRect.x > viewRect.width);
                    break;
                }
                default: {
                    BaseTabbedPaneUI.this.tabPane.repaint(vpRect.x, vpRect.y + vpRect.height, vpRect.width, contentInsets.top);
                    this.scrollBackwardButton.setEnabled(viewRect.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tc - 1 && viewSize.width - viewRect.x > viewRect.width);
                }
            }
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        private TabbedPaneScrollLayout() {
        }

        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            return BaseTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
        }

        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            return BaseTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
        }

        public void layoutContainer(Container parent) {
            int tabPlacement = BaseTabbedPaneUI.this.tabPane.getTabPlacement();
            int tc = BaseTabbedPaneUI.this.tabPane.getTabCount();
            Insets insets = BaseTabbedPaneUI.this.tabPane.getInsets();
            int selectedIndex = BaseTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component visibleComponent = BaseTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            Component selectedComponent = null;
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    BaseTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                try {
                    selectedComponent = BaseTabbedPaneUI.this.tabPane.getComponentAt(selectedIndex);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            boolean shouldChangeFocus = false;
            if (selectedComponent != null) {
                if (selectedComponent != visibleComponent && visibleComponent != null && SwingUtilities.findFocusOwner(visibleComponent) != null) {
                    shouldChangeFocus = true;
                }
                BaseTabbedPaneUI.this.setVisibleComponent(selectedComponent);
            }
            Insets contentInsets = BaseTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            Rectangle bounds = BaseTabbedPaneUI.this.tabPane.getBounds();
            int numChildren = BaseTabbedPaneUI.this.tabPane.getComponentCount();
            int space = 60;
            if (numChildren > 0 && tc > 0) {
                int ch;
                int cw;
                int cy;
                int cx;
                int ty;
                int tx;
                int th;
                int tw;
                switch (tabPlacement) {
                    case 2: {
                        tw = BaseTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, BaseTabbedPaneUI.this.runCount, BaseTabbedPaneUI.this.maxTabWidth);
                        th = bounds.height - insets.top - insets.bottom;
                        tx = insets.left;
                        ty = insets.top;
                        cx = tx + tw + contentInsets.left;
                        cy = ty + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                        ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                        break;
                    }
                    case 4: {
                        tw = BaseTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, BaseTabbedPaneUI.this.runCount, BaseTabbedPaneUI.this.maxTabWidth);
                        th = bounds.height - insets.top - insets.bottom;
                        tx = bounds.width - insets.right - tw;
                        ty = insets.top;
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                        ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                        break;
                    }
                    case 3: {
                        tw = bounds.width - insets.left - insets.right;
                        th = BaseTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BaseTabbedPaneUI.this.runCount, BaseTabbedPaneUI.this.maxTabHeight);
                        tx = insets.left;
                        ty = bounds.height - insets.bottom - th;
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                        ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                        break;
                    }
                    default: {
                        tw = bounds.width - insets.left - insets.right;
                        th = BaseTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BaseTabbedPaneUI.this.runCount, BaseTabbedPaneUI.this.maxTabHeight);
                        tx = insets.left;
                        ty = insets.top;
                        cx = tx + contentInsets.left;
                        cy = ty + th + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                        ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                    }
                }
                for (int i = 0; i < numChildren; ++i) {
                    int totalTabWidth;
                    int totalTabHeight;
                    boolean visible;
                    int bh;
                    int bw;
                    int by;
                    int bx;
                    Dimension bsize;
                    Component child = BaseTabbedPaneUI.this.tabPane.getComponent(i);
                    if (child instanceof ScrollableTabViewport) {
                        JViewport viewport = (JViewport)child;
                        Rectangle viewRect = viewport.getViewRect();
                        int vw = tw;
                        int vh = th;
                        switch (tabPlacement) {
                            case 2: 
                            case 4: {
                                int totalTabHeight2 = BaseTabbedPaneUI.this.rects[tc - 1].y + BaseTabbedPaneUI.this.rects[tc - 1].height;
                                if (totalTabHeight2 <= th || totalTabHeight2 - viewRect.y > (vh = Math.max(th - space, space))) break;
                                vh = totalTabHeight2 - viewRect.y;
                                break;
                            }
                            default: {
                                int totalTabWidth2 = BaseTabbedPaneUI.this.rects[tc - 1].x + BaseTabbedPaneUI.this.rects[tc - 1].width;
                                if (totalTabWidth2 <= tw || totalTabWidth2 - viewRect.x > (vw = Math.max(tw - space, space))) break;
                                vw = totalTabWidth2 - viewRect.x;
                            }
                        }
                        child.setBounds(tx, ty, vw, vh);
                        continue;
                    }
                    if (child instanceof ScrollableTabButton) {
                        ScrollableTabButton scrollbutton = (ScrollableTabButton)child;
                        bsize = scrollbutton.getPreferredSize();
                        bx = 0;
                        by = 0;
                        bw = bsize.width;
                        bh = bsize.height;
                        visible = false;
                        switch (tabPlacement) {
                            case 2: 
                            case 4: {
                                totalTabHeight = BaseTabbedPaneUI.this.rects[tc - 1].y + BaseTabbedPaneUI.this.rects[tc - 1].height;
                                if (totalTabHeight <= th) break;
                                int dir = scrollbutton.scrollsForward() ? 5 : 1;
                                scrollbutton.setDirection(dir);
                                visible = true;
                                bx = tabPlacement == 2 ? tw - insets.left - BaseTabbedPaneUI.this.tabAreaInsets.bottom - bsize.width : bounds.width - insets.left - bsize.width;
                                by = dir == 5 ? bounds.height - insets.bottom - 2 * bsize.height - 2 : bounds.height - insets.bottom - 3 * bsize.height - 2;
                                break;
                            }
                            default: {
                                totalTabWidth = BaseTabbedPaneUI.this.rects[tc - 1].x + BaseTabbedPaneUI.this.rects[tc - 1].width;
                                if (totalTabWidth <= tw) break;
                                int dir = scrollbutton.scrollsForward() ? 3 : 7;
                                scrollbutton.setDirection(dir);
                                visible = true;
                                bx = dir == 3 ? bounds.width - insets.left - 2 * bsize.width - 2 : bounds.width - insets.left - 3 * bsize.width - 2;
                                by = ty + (th - bsize.height - BaseTabbedPaneUI.this.tabAreaInsets.bottom) / 2;
                                if (tabPlacement == 3) {
                                    by += BaseTabbedPaneUI.this.tabAreaInsets.bottom;
                                    break;
                                }
                                ++by;
                            }
                        }
                        child.setVisible(visible);
                        if (!visible) continue;
                        child.setBounds(bx, by, bw, bh);
                        continue;
                    }
                    if (child instanceof ScrollablePopupMenuTabButton) {
                        ScrollablePopupMenuTabButton button = (ScrollablePopupMenuTabButton)child;
                        bsize = button.getPreferredSize();
                        bx = 0;
                        by = 0;
                        bw = bsize.width;
                        bh = bsize.height;
                        visible = false;
                        switch (tabPlacement) {
                            case 2: 
                            case 4: {
                                totalTabHeight = BaseTabbedPaneUI.this.rects[tc - 1].y + BaseTabbedPaneUI.this.rects[tc - 1].height;
                                if (totalTabHeight <= th) break;
                                visible = true;
                                bx = tabPlacement == 2 ? tw - insets.left - BaseTabbedPaneUI.this.tabAreaInsets.bottom - bsize.width : bounds.width - insets.left - bsize.width;
                                by = bounds.height - insets.bottom - bsize.height;
                                break;
                            }
                            default: {
                                totalTabWidth = BaseTabbedPaneUI.this.rects[tc - 1].x + BaseTabbedPaneUI.this.rects[tc - 1].width;
                                if (totalTabWidth <= tw) break;
                                visible = true;
                                bx = bounds.width - insets.left - bsize.width;
                                by = ty + (th - bsize.height - BaseTabbedPaneUI.this.tabAreaInsets.bottom) / 2;
                                if (tabPlacement == 3) {
                                    by += BaseTabbedPaneUI.this.tabAreaInsets.bottom;
                                    break;
                                }
                                ++by;
                            }
                        }
                        child.setVisible(visible);
                        if (!visible) continue;
                        child.setBounds(bx, by, bw, bh);
                        continue;
                    }
                    child.setBounds(cx, cy, cw, ch);
                }
                ((TabbedPaneLayout)this).layoutTabComponents();
                if (shouldChangeFocus && !BaseTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                    BaseTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            FontMetrics fm = BaseTabbedPaneUI.this.getFontMetrics();
            Dimension size = BaseTabbedPaneUI.this.tabPane.getSize();
            Insets insets = BaseTabbedPaneUI.this.tabPane.getInsets();
            Insets tabAreaInsets = BaseTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            int fontHeight = fm.getHeight();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = JTattooUtilities.isLeftToRight(BaseTabbedPaneUI.this.tabPane);
            int x = tabAreaInsets.left;
            int y = tabAreaInsets.top;
            int totalWidth = 0;
            int totalHeight = 0;
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    BaseTabbedPaneUI.this.maxTabWidth = BaseTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    break;
                }
                default: {
                    BaseTabbedPaneUI.this.maxTabHeight = BaseTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                }
            }
            BaseTabbedPaneUI.this.runCount = 0;
            BaseTabbedPaneUI.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            BaseTabbedPaneUI.this.selectedRun = 0;
            BaseTabbedPaneUI.this.runCount = 1;
            for (int i = 0; i < tabCount; ++i) {
                Rectangle rect = BaseTabbedPaneUI.this.rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = BaseTabbedPaneUI.this.rects[i - 1].x + BaseTabbedPaneUI.this.rects[i - 1].width;
                    } else {
                        BaseTabbedPaneUI.this.tabRuns[0] = 0;
                        BaseTabbedPaneUI.this.maxTabWidth = 0;
                        totalHeight += BaseTabbedPaneUI.this.maxTabHeight;
                        rect.x = x;
                    }
                    rect.width = BaseTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, fm);
                    totalWidth = rect.x + rect.width;
                    BaseTabbedPaneUI.this.maxTabWidth = Math.max(BaseTabbedPaneUI.this.maxTabWidth, rect.width);
                    rect.y = y;
                    rect.height = BaseTabbedPaneUI.this.maxTabHeight;
                    continue;
                }
                if (i > 0) {
                    rect.y = BaseTabbedPaneUI.this.rects[i - 1].y + BaseTabbedPaneUI.this.rects[i - 1].height;
                } else {
                    BaseTabbedPaneUI.this.tabRuns[0] = 0;
                    BaseTabbedPaneUI.this.maxTabHeight = 0;
                    totalWidth = BaseTabbedPaneUI.this.maxTabWidth;
                    rect.y = y;
                }
                rect.height = BaseTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                totalHeight = rect.y + rect.height;
                BaseTabbedPaneUI.this.maxTabHeight = Math.max(BaseTabbedPaneUI.this.maxTabHeight, rect.height);
                rect.x = x;
                rect.width = BaseTabbedPaneUI.this.maxTabWidth;
            }
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                for (int i = 0; i < tabCount; ++i) {
                    BaseTabbedPaneUI.this.rects[i].x = rightMargin - BaseTabbedPaneUI.this.rects[i].x - BaseTabbedPaneUI.this.rects[i].width;
                }
            }
            ((BaseTabbedPaneUI)BaseTabbedPaneUI.this).tabScroller.tabPanel.setPreferredSize(new Dimension(totalWidth, totalHeight));
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.calculateSize(false);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.calculateSize(true);
        }

        protected Dimension calculateSize(boolean minimum) {
            int tabPlacement = BaseTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BaseTabbedPaneUI.this.tabPane.getInsets();
            Insets contentInsets = BaseTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            Insets tabAreaInsets = BaseTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Dimension zeroSize = new Dimension(0, 0);
            int height = contentInsets.top + contentInsets.bottom;
            int width = contentInsets.left + contentInsets.right;
            int cWidth = 0;
            int cHeight = 0;
            for (int i = 0; i < BaseTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                Dimension size;
                Component component = BaseTabbedPaneUI.this.tabPane.getComponentAt(i);
                if (component == null) continue;
                Dimension dimension = size = minimum ? component.getMinimumSize() : component.getPreferredSize();
                if (size == null) continue;
                cHeight = Math.max(size.height, cHeight);
                cWidth = Math.max(size.width, cWidth);
            }
            width += cWidth;
            height += cHeight;
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    height = Math.max(height, BaseTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement) + tabAreaInsets.top + tabAreaInsets.bottom);
                    int tabExtent = this.preferredTabAreaWidth(tabPlacement, height);
                    width += tabExtent;
                    break;
                }
                default: {
                    width = Math.max(width, BaseTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement) + tabAreaInsets.left + tabAreaInsets.right);
                    int tabExtent = this.preferredTabAreaHeight(tabPlacement, width);
                    height += tabExtent;
                }
            }
            return new Dimension(width + insets.left + insets.right, height + insets.bottom + insets.top);
        }

        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            FontMetrics fm = BaseTabbedPaneUI.this.getFontMetrics();
            int tc = BaseTabbedPaneUI.this.tabPane.getTabCount();
            int total = 0;
            if (tc > 0) {
                int rows = 1;
                int x = 0;
                int maxTabHeight = BaseTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                for (int i = 0; i < tc; ++i) {
                    int tabWidth = BaseTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, fm);
                    if (x != 0 && x + tabWidth > width) {
                        ++rows;
                        x = 0;
                    }
                    x += tabWidth;
                }
                total = BaseTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, rows, maxTabHeight);
            }
            return total;
        }

        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            FontMetrics fm = BaseTabbedPaneUI.this.getFontMetrics();
            int tc = BaseTabbedPaneUI.this.tabPane.getTabCount();
            int total = 0;
            if (tc > 0) {
                int columns = 1;
                int y = 0;
                int fontHeight = fm.getHeight();
                BaseTabbedPaneUI.this.maxTabWidth = BaseTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                for (int i = 0; i < tc; ++i) {
                    int tabHeight = BaseTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    if (y != 0 && y + tabHeight > height) {
                        ++columns;
                        y = 0;
                    }
                    y += tabHeight;
                }
                total = BaseTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, columns, BaseTabbedPaneUI.this.maxTabWidth);
            }
            return total;
        }

        public void layoutContainer(Container parent) {
            int tabPlacement = BaseTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BaseTabbedPaneUI.this.tabPane.getInsets();
            int selectedIndex = BaseTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component visibleComponent = BaseTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            Component selectedComponent = null;
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    BaseTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                try {
                    selectedComponent = BaseTabbedPaneUI.this.tabPane.getComponentAt(selectedIndex);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            int totalTabWidth = 0;
            int totalTabHeight = 0;
            Insets contentInsets = BaseTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            boolean shouldChangeFocus = false;
            if (selectedComponent != null) {
                if (selectedComponent != visibleComponent && visibleComponent != null && SwingUtilities.findFocusOwner(visibleComponent) != null) {
                    shouldChangeFocus = true;
                }
                BaseTabbedPaneUI.this.setVisibleComponent(selectedComponent);
            }
            Rectangle bounds = BaseTabbedPaneUI.this.tabPane.getBounds();
            int numChildren = BaseTabbedPaneUI.this.tabPane.getComponentCount();
            if (numChildren > 0) {
                int cy;
                int cx;
                switch (tabPlacement) {
                    case 2: {
                        totalTabWidth = BaseTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, BaseTabbedPaneUI.this.runCount, BaseTabbedPaneUI.this.maxTabWidth);
                        cx = insets.left + totalTabWidth + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        break;
                    }
                    case 4: {
                        totalTabWidth = BaseTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, BaseTabbedPaneUI.this.runCount, BaseTabbedPaneUI.this.maxTabWidth);
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        break;
                    }
                    case 3: {
                        totalTabHeight = BaseTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BaseTabbedPaneUI.this.runCount, BaseTabbedPaneUI.this.maxTabHeight);
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        break;
                    }
                    default: {
                        totalTabHeight = BaseTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BaseTabbedPaneUI.this.runCount, BaseTabbedPaneUI.this.maxTabHeight);
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + totalTabHeight + contentInsets.top;
                    }
                }
                int cw = bounds.width - totalTabWidth - insets.left - insets.right - contentInsets.left - contentInsets.right;
                int ch = bounds.height - totalTabHeight - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                for (int i = 0; i < numChildren; ++i) {
                    Component child = BaseTabbedPaneUI.this.tabPane.getComponent(i);
                    if (child == BaseTabbedPaneUI.this.tabContainer) {
                        int tabContainerWidth = totalTabWidth == 0 ? cw : totalTabWidth;
                        int tabContainerHeight = totalTabHeight == 0 ? ch : totalTabHeight;
                        int tabContainerX = 0;
                        int tabContainerY = 0;
                        if (tabPlacement == 3) {
                            tabContainerY = bounds.height - tabContainerHeight;
                        } else if (tabPlacement == 4) {
                            tabContainerX = bounds.width - tabContainerWidth;
                        }
                        child.setBounds(tabContainerX, tabContainerY, tabContainerWidth, tabContainerHeight);
                        continue;
                    }
                    child.setBounds(cx, cy, cw, ch);
                }
            }
            this.layoutTabComponents();
            if (shouldChangeFocus && !BaseTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                BaseTabbedPaneUI.this.tabPane.requestFocus();
            }
        }

        public void calculateLayoutInfo() {
            int tc = BaseTabbedPaneUI.this.tabPane.getTabCount();
            BaseTabbedPaneUI.this.assureRectsCreated(tc);
            this.calculateTabRects(BaseTabbedPaneUI.this.tabPane.getTabPlacement(), tc);
        }

        private void layoutTabComponents() {
            if (JTattooUtilities.getJavaVersion() >= 1.6) {
                if (BaseTabbedPaneUI.this.tabContainer == null) {
                    return;
                }
                Rectangle rect = new Rectangle();
                Point delta = new Point(-BaseTabbedPaneUI.this.tabContainer.getX(), -BaseTabbedPaneUI.this.tabContainer.getY());
                if (BaseTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                    BaseTabbedPaneUI.this.translatePointToTabPanel(0, 0, delta);
                }
                for (int i = 0; i < BaseTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                    Component tabComponent = BaseTabbedPaneUI.this.getTabComponentAt(i);
                    if (tabComponent == null) continue;
                    BaseTabbedPaneUI.this.getTabBounds(i, rect);
                    Dimension preferredSize = tabComponent.getPreferredSize();
                    Insets insets = BaseTabbedPaneUI.this.getTabInsets(BaseTabbedPaneUI.this.tabPane.getTabPlacement(), i);
                    int outerX = rect.x + insets.left + delta.x;
                    int outerY = rect.y + insets.top + delta.y;
                    int outerWidth = rect.width - insets.left - insets.right;
                    int outerHeight = rect.height - insets.top - insets.bottom;
                    int x = outerX + (outerWidth - preferredSize.width) / 2;
                    int y = outerY + (outerHeight - preferredSize.height) / 2;
                    int tabPlacement = BaseTabbedPaneUI.this.tabPane.getTabPlacement();
                    boolean isSeleceted = i == BaseTabbedPaneUI.this.tabPane.getSelectedIndex();
                    tabComponent.setBounds(x + BaseTabbedPaneUI.this.getTabLabelShiftX(tabPlacement, i, isSeleceted), y + BaseTabbedPaneUI.this.getTabLabelShiftY(tabPlacement, i, isSeleceted), preferredSize.width, preferredSize.height);
                }
            }
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            Rectangle rect;
            int i;
            int returnAt;
            int y;
            int x;
            FontMetrics fm = BaseTabbedPaneUI.this.getFontMetrics();
            Dimension size = BaseTabbedPaneUI.this.tabPane.getSize();
            Insets insets = BaseTabbedPaneUI.this.tabPane.getInsets();
            Insets tabAreaInsets = BaseTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            int fontHeight = fm.getHeight();
            int selectedIndex = BaseTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = JTattooUtilities.isLeftToRight(BaseTabbedPaneUI.this.tabPane);
            switch (tabPlacement) {
                case 2: {
                    BaseTabbedPaneUI.this.maxTabWidth = BaseTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 4: {
                    BaseTabbedPaneUI.this.maxTabWidth = BaseTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = size.width - insets.right - tabAreaInsets.right - BaseTabbedPaneUI.this.maxTabWidth;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 3: {
                    BaseTabbedPaneUI.this.maxTabHeight = BaseTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = size.height - insets.bottom - tabAreaInsets.bottom - BaseTabbedPaneUI.this.maxTabHeight;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                    break;
                }
                default: {
                    BaseTabbedPaneUI.this.maxTabHeight = BaseTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                }
            }
            int tabRunOverlay = BaseTabbedPaneUI.this.getTabRunOverlay(tabPlacement);
            BaseTabbedPaneUI.this.runCount = 0;
            BaseTabbedPaneUI.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            for (i = 0; i < tabCount; ++i) {
                rect = BaseTabbedPaneUI.this.rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = BaseTabbedPaneUI.this.rects[i - 1].x + BaseTabbedPaneUI.this.rects[i - 1].width;
                    } else {
                        BaseTabbedPaneUI.this.tabRuns[0] = 0;
                        BaseTabbedPaneUI.this.runCount = 1;
                        BaseTabbedPaneUI.this.maxTabWidth = 0;
                        rect.x = x;
                    }
                    rect.width = BaseTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, fm);
                    BaseTabbedPaneUI.this.maxTabWidth = Math.max(BaseTabbedPaneUI.this.maxTabWidth, rect.width);
                    if (rect.x != 2 + insets.left && rect.x + rect.width > returnAt) {
                        if (BaseTabbedPaneUI.this.runCount > BaseTabbedPaneUI.this.tabRuns.length - 1) {
                            BaseTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BaseTabbedPaneUI.this.tabRuns[BaseTabbedPaneUI.this.runCount] = i;
                        ++BaseTabbedPaneUI.this.runCount;
                        rect.x = x;
                    }
                    rect.y = y;
                    rect.height = BaseTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (i > 0) {
                        rect.y = BaseTabbedPaneUI.this.rects[i - 1].y + BaseTabbedPaneUI.this.rects[i - 1].height;
                    } else {
                        BaseTabbedPaneUI.this.tabRuns[0] = 0;
                        BaseTabbedPaneUI.this.runCount = 1;
                        BaseTabbedPaneUI.this.maxTabHeight = 0;
                        rect.y = y;
                    }
                    rect.height = BaseTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    BaseTabbedPaneUI.this.maxTabHeight = Math.max(BaseTabbedPaneUI.this.maxTabHeight, rect.height);
                    if (rect.y != 2 + insets.top && rect.y + rect.height > returnAt) {
                        if (BaseTabbedPaneUI.this.runCount > BaseTabbedPaneUI.this.tabRuns.length - 1) {
                            BaseTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BaseTabbedPaneUI.this.tabRuns[BaseTabbedPaneUI.this.runCount] = i;
                        ++BaseTabbedPaneUI.this.runCount;
                        rect.y = y;
                    }
                    rect.x = x;
                    rect.width = BaseTabbedPaneUI.this.maxTabWidth;
                }
                if (i != selectedIndex) continue;
                BaseTabbedPaneUI.this.selectedRun = BaseTabbedPaneUI.this.runCount - 1;
            }
            if (BaseTabbedPaneUI.this.runCount > 1) {
                this.normalizeTabRuns(tabPlacement, tabCount, verticalTabRuns ? y : x, returnAt);
                BaseTabbedPaneUI.this.selectedRun = BaseTabbedPaneUI.this.getRunForTab(tabCount, selectedIndex);
                if (BaseTabbedPaneUI.this.shouldRotateTabRuns(tabPlacement)) {
                    this.rotateTabRuns(tabPlacement, BaseTabbedPaneUI.this.selectedRun);
                }
            }
            for (i = BaseTabbedPaneUI.this.runCount - 1; i >= 0; --i) {
                int j;
                int end;
                int start = BaseTabbedPaneUI.this.tabRuns[i];
                int next = BaseTabbedPaneUI.this.tabRuns[i == BaseTabbedPaneUI.this.runCount - 1 ? 0 : i + 1];
                int n = end = next != 0 ? next - 1 : tabCount - 1;
                if (!verticalTabRuns) {
                    for (j = start; j <= end; ++j) {
                        rect = BaseTabbedPaneUI.this.rects[j];
                        rect.y = y;
                        rect.x += BaseTabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                    }
                    if (BaseTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                        this.padTabRun(tabPlacement, start, end, returnAt);
                    }
                    if (tabPlacement == 3) {
                        y -= BaseTabbedPaneUI.this.maxTabHeight - tabRunOverlay;
                        continue;
                    }
                    y += BaseTabbedPaneUI.this.maxTabHeight - tabRunOverlay;
                    continue;
                }
                for (j = start; j <= end; ++j) {
                    rect = BaseTabbedPaneUI.this.rects[j];
                    rect.x = x;
                    rect.y += BaseTabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                }
                if (BaseTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                    this.padTabRun(tabPlacement, start, end, returnAt);
                }
                if (tabPlacement == 4) {
                    x -= BaseTabbedPaneUI.this.maxTabWidth - tabRunOverlay;
                    continue;
                }
                x += BaseTabbedPaneUI.this.maxTabWidth - tabRunOverlay;
            }
            this.padSelectedTab(tabPlacement, selectedIndex);
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                for (i = 0; i < tabCount; ++i) {
                    BaseTabbedPaneUI.this.rects[i].x = rightMargin - BaseTabbedPaneUI.this.rects[i].x - BaseTabbedPaneUI.this.rects[i].width;
                }
            }
        }

        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
            for (int i = 0; i < selectedRun; ++i) {
                int save = BaseTabbedPaneUI.this.tabRuns[0];
                for (int j = 1; j < BaseTabbedPaneUI.this.runCount; ++j) {
                    BaseTabbedPaneUI.this.tabRuns[j - 1] = BaseTabbedPaneUI.this.tabRuns[j];
                }
                BaseTabbedPaneUI.this.tabRuns[BaseTabbedPaneUI.this.runCount - 1] = save;
            }
        }

        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                int run = BaseTabbedPaneUI.this.runCount - 1;
                boolean keepAdjusting = true;
                double weight = 1.25;
                while (keepAdjusting) {
                    int last = BaseTabbedPaneUI.this.lastTabInRun(tabCount, run);
                    int prevLast = BaseTabbedPaneUI.this.lastTabInRun(tabCount, run - 1);
                    int end = BaseTabbedPaneUI.this.rects[last].x + BaseTabbedPaneUI.this.rects[last].width;
                    int prevLastLen = (int)((double)BaseTabbedPaneUI.this.maxTabWidth * weight);
                    if (max - end > prevLastLen) {
                        BaseTabbedPaneUI.this.tabRuns[run] = prevLast;
                        BaseTabbedPaneUI.this.rects[prevLast].x = start;
                        for (int i = prevLast + 1; i <= last; ++i) {
                            BaseTabbedPaneUI.this.rects[i].x = BaseTabbedPaneUI.this.rects[i - 1].x + BaseTabbedPaneUI.this.rects[i - 1].width;
                        }
                    } else if (run == BaseTabbedPaneUI.this.runCount - 1) {
                        keepAdjusting = false;
                    }
                    if (run - 1 > 0) {
                        --run;
                        continue;
                    }
                    run = BaseTabbedPaneUI.this.runCount - 1;
                    weight += 0.25;
                }
            }
        }

        protected void padTabRun(int tabPlacement, int start, int end, int max) {
            Rectangle lastRect = BaseTabbedPaneUI.this.rects[end];
            if (tabPlacement == 1 || tabPlacement == 3) {
                int runWidth = lastRect.x + lastRect.width - BaseTabbedPaneUI.this.rects[start].x;
                int deltaWidth = max - (lastRect.x + lastRect.width);
                float factor = (float)deltaWidth / (float)runWidth;
                for (int j = start; j <= end; ++j) {
                    Rectangle pastRect = BaseTabbedPaneUI.this.rects[j];
                    if (j > start) {
                        pastRect.x = BaseTabbedPaneUI.this.rects[j - 1].x + BaseTabbedPaneUI.this.rects[j - 1].width;
                    }
                    pastRect.width += Math.round((float)pastRect.width * factor);
                }
                lastRect.width = max - lastRect.x;
            } else {
                int runHeight = lastRect.y + lastRect.height - BaseTabbedPaneUI.this.rects[start].y;
                int deltaHeight = max - (lastRect.y + lastRect.height);
                float factor = (float)deltaHeight / (float)runHeight;
                for (int j = start; j <= end; ++j) {
                    Rectangle pastRect = BaseTabbedPaneUI.this.rects[j];
                    if (j > start) {
                        pastRect.y = BaseTabbedPaneUI.this.rects[j - 1].y + BaseTabbedPaneUI.this.rects[j - 1].height;
                    }
                    pastRect.height += Math.round((float)pastRect.height * factor);
                }
                lastRect.height = max - lastRect.y;
            }
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
        }
    }

    private static class ScrollTabsPopupMenuAction
    extends AbstractAction {
        private JTabbedPane tabbedPane = null;

        private ScrollTabsPopupMenuAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src instanceof JTabbedPane) {
                this.tabbedPane = (JTabbedPane)src;
            } else if (src instanceof ScrollablePopupMenuTabButton) {
                this.tabbedPane = (JTabbedPane)((ScrollablePopupMenuTabButton)src).getParent();
            } else {
                return;
            }
            BaseTabbedPaneUI ui = (BaseTabbedPaneUI)this.tabbedPane.getUI();
            if (ui.scrollableTabLayoutEnabled()) {
                JPopupMenu popup = new JPopupMenu();
                for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                    JMenuItem item = new JMenuItem(this.tabbedPane.getTitleAt(i));
                    item.addActionListener(new ScrollTabsPopupMenuItemAction(this.tabbedPane, i));
                    item.setEnabled(this.tabbedPane.isEnabledAt(i));
                    popup.add(item);
                }
                popup.show(((BaseTabbedPaneUI)ui).tabScroller.popupMenuButton, 0, 0);
                Point pt = ((BaseTabbedPaneUI)ui).tabScroller.popupMenuButton.getLocationOnScreen();
                int x = -popup.getWidth() + ((BaseTabbedPaneUI)ui).tabScroller.popupMenuButton.getWidth();
                int y = ((BaseTabbedPaneUI)ui).tabScroller.popupMenuButton.getHeight() - 1;
                popup.setLocation(pt.x + x, pt.y + y);
            }
        }
    }

    private static class ScrollTabsPopupMenuItemAction
    extends AbstractAction {
        private JTabbedPane tabbedPane = null;
        private int selectIndex = 0;

        public ScrollTabsPopupMenuItemAction(JTabbedPane pane, int index) {
            this.tabbedPane = pane;
            this.selectIndex = index;
        }

        public void actionPerformed(ActionEvent e) {
            this.tabbedPane.setSelectedIndex(this.selectIndex);
        }
    }

    private static class ScrollTabsBackwardAction
    extends AbstractAction {
        private ScrollTabsBackwardAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane;
            Object src = e.getSource();
            if (src instanceof JTabbedPane) {
                pane = (JTabbedPane)src;
            } else if (src instanceof ScrollableTabButton) {
                pane = (JTabbedPane)((ScrollableTabButton)src).getParent();
            } else {
                return;
            }
            BaseTabbedPaneUI ui = (BaseTabbedPaneUI)pane.getUI();
            if (ui.scrollableTabLayoutEnabled()) {
                ui.tabScroller.scrollBackward(pane.getTabPlacement());
            }
        }
    }

    private static class ScrollTabsForwardAction
    extends AbstractAction {
        private ScrollTabsForwardAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane;
            Object src = e.getSource();
            if (src instanceof JTabbedPane) {
                pane = (JTabbedPane)src;
            } else if (src instanceof ScrollableTabButton) {
                pane = (JTabbedPane)((ScrollableTabButton)src).getParent();
            } else {
                return;
            }
            BaseTabbedPaneUI ui = (BaseTabbedPaneUI)pane.getUI();
            if (ui.scrollableTabLayoutEnabled()) {
                ui.tabScroller.scrollForward(pane.getTabPlacement());
            }
        }
    }

    private static class SetSelectedIndexAction
    extends AbstractAction {
        private SetSelectedIndexAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            if (pane != null && pane.getUI() instanceof BaseTabbedPaneUI) {
                BaseTabbedPaneUI ui = (BaseTabbedPaneUI)pane.getUI();
                String command = e.getActionCommand();
                if (command != null && command.length() > 0) {
                    Integer index;
                    int mnemonic = e.getActionCommand().charAt(0);
                    if (mnemonic >= 97 && mnemonic <= 122) {
                        mnemonic -= 32;
                    }
                    if ((index = (Integer)ui.mnemonicToIndexMap.get(new Integer(mnemonic))) != null && pane.isEnabledAt(index)) {
                        pane.setSelectedIndex(index);
                    }
                }
            }
        }
    }

    private static class RequestFocusForVisibleAction
    extends AbstractAction {
        private RequestFocusForVisibleAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BaseTabbedPaneUI ui = (BaseTabbedPaneUI)pane.getUI();
            ui.requestFocusForVisibleComponent();
        }
    }

    private static class RequestFocusAction
    extends AbstractAction {
        private RequestFocusAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            pane.requestFocus();
        }
    }

    private static class PageDownAction
    extends AbstractAction {
        private PageDownAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BaseTabbedPaneUI ui = (BaseTabbedPaneUI)pane.getUI();
            int tabPlacement = pane.getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                ui.navigateSelectedTab(3);
            } else {
                ui.navigateSelectedTab(5);
            }
        }
    }

    private static class PageUpAction
    extends AbstractAction {
        private PageUpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BaseTabbedPaneUI ui = (BaseTabbedPaneUI)pane.getUI();
            int tabPlacement = pane.getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                ui.navigateSelectedTab(7);
            } else {
                ui.navigateSelectedTab(1);
            }
        }
    }

    private static class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BaseTabbedPaneUI ui = (BaseTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(13);
        }
    }

    private static class NextAction
    extends AbstractAction {
        private NextAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BaseTabbedPaneUI ui = (BaseTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(12);
        }
    }

    private static class DownAction
    extends AbstractAction {
        private DownAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BaseTabbedPaneUI ui = (BaseTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(5);
        }
    }

    private static class UpAction
    extends AbstractAction {
        private UpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BaseTabbedPaneUI ui = (BaseTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(1);
        }
    }

    private static class LeftAction
    extends AbstractAction {
        private LeftAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BaseTabbedPaneUI ui = (BaseTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(7);
        }
    }

    private static class RightAction
    extends AbstractAction {
        private RightAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BaseTabbedPaneUI ui = (BaseTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(3);
        }
    }
}

