/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;
import org.tinymediamanager.ui.UTF8Control;

public class TvShowChooserModel
extends AbstractModelObject {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowChooserModel.class);
    public static final TvShowChooserModel emptyResult = new TvShowChooserModel();
    private MediaScraper mediaScraper = null;
    private List<MediaScraper> artworkScrapers = null;
    private MediaLanguages language = null;
    private MediaSearchResult result = null;
    private MediaMetadata metadata = null;
    private String name = "";
    private String overview = "";
    private String year = "";
    private String combinedName = "";
    private String posterUrl = "";
    private String tagline = "";
    private boolean scraped = false;

    public TvShowChooserModel(MediaScraper mediaScraper, List<MediaScraper> artworkScrapers, MediaSearchResult result, MediaLanguages language) {
        this.mediaScraper = mediaScraper;
        this.artworkScrapers = artworkScrapers;
        this.result = result;
        this.language = language;
        this.setName(result.getTitle());
        if (result.getYear() != 0) {
            this.setYear(Integer.toString(result.getYear()));
        } else {
            this.setYear("");
        }
        this.setCombinedName();
    }

    private TvShowChooserModel() {
        this.setName(BUNDLE.getString("chooser.nothingfound"));
        this.combinedName = this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChange("name", oldValue, name);
    }

    public void setOverview(String overview) {
        String oldValue = this.overview;
        this.overview = overview;
        this.firePropertyChange("overview", oldValue, overview);
    }

    public String getName() {
        return this.name;
    }

    public String getOverview() {
        return this.overview;
    }

    public String getPosterUrl() {
        return this.posterUrl;
    }

    public void setPosterUrl(String newValue) {
        String oldValue = this.posterUrl;
        this.posterUrl = newValue;
        this.firePropertyChange("posterUrl", oldValue, newValue);
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        String oldValue = this.year;
        this.year = year;
        this.firePropertyChange("year", oldValue, year);
    }

    public void setCombinedName() {
        String oldValue = this.combinedName;
        this.combinedName = StringUtils.isNotBlank((CharSequence)this.getYear()) ? this.getName() + " (" + this.getYear() + ")" : this.getName();
        this.firePropertyChange("combinedName", oldValue, this.combinedName);
    }

    public String getCombinedName() {
        return this.combinedName;
    }

    public void scrapeMetaData() {
        try {
            this.setPosterUrl(this.result.getPosterUrl());
            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.TV_SHOW);
            options.setResult(this.result);
            options.setLanguage(LocaleUtils.toLocale((String)this.language.name()));
            options.setCountry(TvShowModuleManager.SETTINGS.getCertificationCountry());
            LOGGER.info("=====================================================");
            LOGGER.info("Scraper metadata with scraper: " + this.mediaScraper.getMediaProvider().getProviderInfo().getId());
            LOGGER.info(options.toString());
            LOGGER.info("=====================================================");
            this.metadata = ((ITvShowMetadataProvider)this.mediaScraper.getMediaProvider()).getMetadata(options);
            this.setOverview(this.metadata.getPlot());
            this.setTagline(this.metadata.getTagline());
            if (StringUtils.isBlank((CharSequence)this.posterUrl) && !this.metadata.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).isEmpty()) {
                this.setPosterUrl(((MediaArtwork)this.metadata.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).get(0)).getPreviewUrl());
            }
            this.scraped = true;
        }
        catch (Exception e) {
            LOGGER.error("scrapeMedia", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowChooser", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
        }
    }

    public MediaMetadata getMetadata() {
        return this.metadata;
    }

    public boolean isScraped() {
        return this.scraped;
    }

    public void setTagline(String newValue) {
        String oldValue = this.tagline;
        this.tagline = newValue;
        this.firePropertyChange("tagline", oldValue, newValue);
    }

    public String getTagline() {
        return this.tagline;
    }

    public MediaLanguages getLanguage() {
        return this.language;
    }

    public void startArtworkScrapeTask(TvShow tvShow, TvShowScraperMetadataConfig config) {
        TmmTaskManager.getInstance().addUnnamedTask(new ArtworkScrapeTask(tvShow, config));
    }

    private class ArtworkScrapeTask
    extends TmmTask {
        private TvShow tvShowToScrape;
        private TvShowScraperMetadataConfig config;

        public ArtworkScrapeTask(TvShow tvShow, TvShowScraperMetadataConfig config) {
            super(BUNDLE.getString("message.scrape.artwork") + " " + tvShow.getTitle(), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
            this.tvShowToScrape = tvShow;
            this.config = config;
        }

        @Override
        protected void doInBackground() {
            if (!TvShowChooserModel.this.scraped) {
                return;
            }
            ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.TV_SHOW);
            options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            options.setMetadata(TvShowChooserModel.this.metadata);
            for (Map.Entry<String, Object> entry : this.tvShowToScrape.getIds().entrySet()) {
                options.setId(entry.getKey(), entry.getValue().toString());
            }
            options.setLanguage(LocaleUtils.toLocale((String)TvShowChooserModel.this.language.name()));
            options.setCountry(TvShowModuleManager.SETTINGS.getCertificationCountry());
            for (MediaScraper artworkScraper : TvShowChooserModel.this.artworkScrapers) {
                ITvShowArtworkProvider artworkProvider = (ITvShowArtworkProvider)artworkScraper.getMediaProvider();
                try {
                    artwork.addAll(artworkProvider.getArtwork(options));
                }
                catch (Exception e) {
                    LOGGER.warn("could not get artwork from " + artworkProvider.getProviderInfo().getName() + ": " + e.getMessage());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)TvShowChooserModel.this.getPosterUrl())) {
                MediaArtwork ma = new MediaArtwork(TvShowChooserModel.this.result.getProviderId(), MediaArtwork.MediaArtworkType.POSTER);
                ma.setDefaultUrl(TvShowChooserModel.this.getPosterUrl());
                ma.setPreviewUrl(TvShowChooserModel.this.getPosterUrl());
                artwork.add(ma);
            }
            this.tvShowToScrape.setArtwork(artwork, this.config);
        }
    }
}

