/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableColumnResizer {
    public static void adjustColumnPreferredWidths(JTable table) {
        TableColumnResizer.adjustColumnPreferredWidths(table, 0);
    }

    public static void adjustColumnPreferredWidths(JTable table, int margin) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int col = 0; col < table.getColumnCount(); ++col) {
            int maxwidth = 0;
            TableCellRenderer rend = columnModel.getColumn(col).getHeaderRenderer();
            Object value = columnModel.getColumn(col).getHeaderValue();
            if (rend == null) {
                rend = table.getTableHeader().getDefaultRenderer();
            }
            Component comp = rend.getTableCellRendererComponent(table, value, false, false, -1, col);
            maxwidth = Math.max(comp.getPreferredSize().width + 2 * margin, maxwidth);
            for (int row = 0; row < table.getRowCount(); ++row) {
                rend = table.getCellRenderer(row, col);
                value = table.getValueAt(row, col);
                comp = rend.getTableCellRendererComponent(table, value, false, false, row, col);
                maxwidth = Math.max(comp.getPreferredSize().width + margin, maxwidth);
            }
            TableColumn column = columnModel.getColumn(col);
            column.setPreferredWidth(maxwidth);
        }
    }

    public static void setMaxWidthForColumn(JTable table, int column, int margin) {
        TableColumnModel columnModel = table.getColumnModel();
        if (column < table.getColumnCount()) {
            int maxwidth = 0;
            TableCellRenderer rend = columnModel.getColumn(column).getHeaderRenderer();
            Object value = columnModel.getColumn(column).getHeaderValue();
            if (rend == null) {
                rend = table.getTableHeader().getDefaultRenderer();
            }
            Component comp = rend.getTableCellRendererComponent(table, value, false, false, -1, column);
            maxwidth = Math.max(comp.getPreferredSize().width + 2 * margin, maxwidth);
            for (int row = 0; row < table.getRowCount(); ++row) {
                rend = table.getCellRenderer(row, column);
                value = table.getValueAt(row, column);
                comp = rend.getTableCellRendererComponent(table, value, false, false, row, column);
                maxwidth = Math.max(comp.getPreferredSize().width + margin, maxwidth);
            }
            TableColumn col = columnModel.getColumn(column);
            col.setMaxWidth(maxwidth);
        }
    }
}

