/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.UTF8Control;

public class TvShowRenameTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowRenameTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<TvShow> tvShowsToRename = new ArrayList<TvShow>();
    private List<TvShowEpisode> episodesToRename = new ArrayList<TvShowEpisode>();
    private boolean renameRoot = true;

    public TvShowRenameTask(List<TvShow> tvShowsToRename, List<TvShowEpisode> episodesToRename, boolean renameRootFolder) {
        super(BUNDLE.getString("tvshow.rename"));
        if (tvShowsToRename != null) {
            this.tvShowsToRename.addAll(tvShowsToRename);
        }
        if (episodesToRename != null) {
            this.episodesToRename.addAll(episodesToRename);
        }
        this.renameRoot = renameRootFolder;
    }

    @Override
    protected void doInBackground() {
        try {
            TvShow show;
            int i;
            this.start();
            this.initThreadPool(1, "rename");
            for (i = 0; i < this.tvShowsToRename.size() && !this.cancel; ++i) {
                show = this.tvShowsToRename.get(i);
                for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(show.getEpisodes())) {
                    this.submitTask(new RenameEpisodeTask(episode));
                }
            }
            for (i = 0; i < this.episodesToRename.size() && !this.cancel; ++i) {
                TvShowEpisode episode = this.episodesToRename.get(i);
                this.submitTask(new RenameEpisodeTask(episode));
            }
            this.waitForCompletionOrCancel();
            if (this.cancel) {
                return;
            }
            if (this.renameRoot) {
                for (i = 0; i < this.episodesToRename.size() && !this.cancel; ++i) {
                    show = this.episodesToRename.get(i).getTvShow();
                    if (this.tvShowsToRename.contains(show)) continue;
                    this.tvShowsToRename.add(show);
                }
                for (i = 0; i < this.tvShowsToRename.size() && !this.cancel; ++i) {
                    TvShowRenamer.renameTvShowRoot(this.tvShowsToRename.get(i));
                }
            }
            LOGGER.info("Done renaming TV shows)");
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "Settings.renamer", "message.renamer.threadcrashed"));
        }
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }

    private class RenameEpisodeTask
    implements Callable<Object> {
        private TvShowEpisode episode = null;

        public RenameEpisodeTask(TvShowEpisode episode) {
            this.episode = episode;
        }

        @Override
        public String call() throws Exception {
            TvShowRenamer.renameEpisode(this.episode);
            return this.episode.getTitle();
        }
    }
}

