/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.config.MediaProviderConfigObject;
import org.tinymediamanager.scraper.util.AesUtil;

public class MediaProviderConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaProviderConfig.class);
    private static final String CONFIG_FOLDER = "data";
    private static final String SALT = "3FF2EB019C627B9652257EAAD71812269851E84295370EB132882F88C0A59A76";
    private static final String IV = "E17D2C8927726ACE1E7510A1BDD3D439";
    private static final AesUtil AES_UTIL = new AesUtil(128, 100);
    private TreeMap<String, MediaProviderConfigObject> settings = new TreeMap();
    private String id = "";

    public MediaProviderConfig(MediaProviderInfo mpi) {
        this.id = mpi.getId();
    }

    public void load() {
        this.loadFromDir(CONFIG_FOLDER);
    }

    @Deprecated
    public void loadFromDir(String folder) {
        if (this.settings.isEmpty()) {
            return;
        }
        Properties p = new Properties();
        File conf = new File(folder, "scraper_" + this.id + ".conf");
        try {
            p.load(new FileInputStream(conf));
            for (MediaProviderConfigObject co : this.settings.values()) {
                String value = p.getProperty(co.getKey());
                if (co.isEncrypt()) {
                    value = MediaProviderConfig.decryptField(value, co.getKey());
                }
                co.setValue(value == null ? co.getDefaultValue() : value);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot load settings '" + conf + "' - using defaults");
        }
    }

    public void save() {
        this.saveToDir(CONFIG_FOLDER);
    }

    @Deprecated
    public void saveToDir(String folder) {
        if (this.settings.isEmpty()) {
            return;
        }
        Properties p = new Properties();
        for (MediaProviderConfigObject co : this.settings.values()) {
            String value = co.getValue();
            if (co.isEncrypt()) {
                value = MediaProviderConfig.encryptField(value, co.getKey());
            }
            p.setProperty(co.getKey(), value);
        }
        File conf = new File(folder, "scraper_" + this.id + ".conf");
        try {
            p.store(new FileOutputStream(conf), "");
        }
        catch (IOException e) {
            LOGGER.warn("Cannot write settings " + conf);
        }
    }

    public boolean hasConfig() {
        return !this.settings.isEmpty();
    }

    public Map<String, MediaProviderConfigObject> getConfigObjects() {
        return this.settings;
    }

    public Map<String, String> getConfigKeyValuePairs() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, MediaProviderConfigObject> entry : this.settings.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getValue());
        }
        return result;
    }

    public MediaProviderConfigObject getConfigObject(String key) {
        MediaProviderConfigObject co = this.settings.get(key);
        if (co == null) {
            LOGGER.warn("Could not get confiuguration object for key '" + key + "' - key not defined!");
            return new MediaProviderConfigObject();
        }
        return co;
    }

    public String getValue(String key) {
        return this.getConfigObject(key).getValue();
    }

    public Integer getValueIndex(String key) {
        return this.getConfigObject(key).getValueIndex();
    }

    public Boolean getValueAsBool(String key) {
        return this.getConfigObject(key).getValueAsBool();
    }

    public void setValue(String key, String value) {
        MediaProviderConfigObject co = this.getConfigObject(key);
        if (co.isEmpty()) {
            return;
        }
        co.setValue(value);
    }

    public void setValue(String key, boolean value) {
        MediaProviderConfigObject co = this.getConfigObject(key);
        if (co.isEmpty()) {
            return;
        }
        co.setValue(value);
    }

    public void addBoolean(String key, boolean defaultValue) {
        MediaProviderConfigObject co = new MediaProviderConfigObject();
        co.setType(MediaProviderConfigObject.ConfigType.BOOL);
        co.setKey(key);
        co.setDefaultValue(String.valueOf(defaultValue));
        co.setValue(String.valueOf(defaultValue));
        this.settings.put(key, co);
    }

    public void addText(String key, String defaultValue) {
        this.addText(key, defaultValue, false);
    }

    public void addText(String key, String defaultValue, boolean encrypt) {
        MediaProviderConfigObject co = new MediaProviderConfigObject();
        co.setType(MediaProviderConfigObject.ConfigType.TEXT);
        co.setKey(key);
        co.setDefaultValue(defaultValue);
        co.setValue(defaultValue);
        co.setEncrypt(encrypt);
        this.settings.put(key, co);
    }

    public void addSelect(String key, String[] possibleValues, String defaultValue) {
        MediaProviderConfigObject co = new MediaProviderConfigObject();
        co.setType(MediaProviderConfigObject.ConfigType.SELECT);
        co.setKey(key);
        for (String s : possibleValues) {
            co.addPossibleValues(s);
        }
        co.setDefaultValue(defaultValue);
        co.setValue(defaultValue);
        this.settings.put(key, co);
    }

    public void addSelectIndex(String key, String[] possibleValues, String defaultValue) {
        MediaProviderConfigObject co = new MediaProviderConfigObject();
        co.setType(MediaProviderConfigObject.ConfigType.SELECT_INDEX);
        co.setKey(key);
        co.setReturnListAsInt(true);
        for (String s : possibleValues) {
            co.addPossibleValues(s);
        }
        co.setDefaultValue(defaultValue);
        co.setValue(defaultValue);
        this.settings.put(key, co);
    }

    private static String encryptField(String value, String key) {
        return AES_UTIL.encrypt(SALT, IV, key, value);
    }

    private static String decryptField(String value, String key) {
        return AES_UTIL.decrypt(SALT, IV, key, value);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

