/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.ColumnLayout;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.StarRater;
import org.tinymediamanager.ui.converter.CertificationImageConverter;
import org.tinymediamanager.ui.converter.MediaInfoAudioCodecConverter;
import org.tinymediamanager.ui.converter.MediaInfoVideoCodecConverter;
import org.tinymediamanager.ui.converter.MediaInfoVideoFormatConverter;
import org.tinymediamanager.ui.converter.VoteCountConverter;
import org.tinymediamanager.ui.converter.WatchedIconConverter;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeCastPanel;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeDetailsPanel;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeMediaFilesPanel;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeMediaInformationPanel;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeSelectionModel;

public class TvShowEpisodeInformationPanel
extends JPanel {
    private static final long serialVersionUID = 2032708149757390567L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private JSplitPane splitPaneVertical;
    private JPanel panelTop;
    private JPanel panelTvShowLogos;
    private StarRater panelRatingStars;
    private JLabel lblTvShowName;
    private JLabel lblRating;
    private JLabel lblVoteCount;
    private JLabel lblEpisodeTitle;
    private JLabel lblCertificationImage;
    private ImageLabel lblEpisodeThumb;
    private ImageLabel lblSeasonPoster;
    private JPanel panelBottom;
    private JTextPane tpOverview;
    private JPanel panelLogos;
    private JTabbedPane tabbedPaneTvShowEpisodeDetails;
    private JPanel panelActors;
    private JPanel panelDetails;
    private JPanel panelMediaInformation;
    private JPanel panelMediaFiles;
    private JLabel lblMediaLogoResolution;
    private JLabel lblMediaLogoVideoCodec;
    private JLabel lblMediaLogoAudio;
    private JPanel panelWatched;
    private JLabel lblWatched;
    private TvShowEpisodeSelectionModel tvShowEpisodeSelectionModel;
    private JPanel panelLeft;
    private JLabel lblSeasonPosterSize;
    private JLabel lblEpisodeThumbSize;
    private JSeparator separator;
    private JLabel lblPlot;

    public TvShowEpisodeInformationPanel(TvShowEpisodeSelectionModel tvShowEpisodeSelectionModel) {
        this.tvShowEpisodeSelectionModel = tvShowEpisodeSelectionModel;
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"100px:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200px:grow(4)")}, new RowSpec[]{RowSpec.decode((String)"fill:default:grow")}));
        this.panelLeft = new JPanel();
        this.panelLeft.setLayout(new ColumnLayout());
        this.add((Component)this.panelLeft, "1, 1, fill, fill");
        this.lblSeasonPoster = new ImageLabel(false){
            private static final long serialVersionUID = -4774846565578766742L;

            @Override
            public Dimension getPreferredSize() {
                if (this.scaledImage != null && this.scaledImage.getWidth() > 10) {
                    return new Dimension(this.getParent().getWidth(), (int)((float)this.getParent().getWidth() / (float)this.scaledImage.getWidth() * (float)this.scaledImage.getHeight()));
                }
                return new Dimension(this.getParent().getWidth(), (int)((double)this.getParent().getWidth() / 2.0 * 3.0) + 1);
            }
        };
        this.lblSeasonPoster.setDesiredAspectRatio(0.6666667f);
        this.panelLeft.add(this.lblSeasonPoster);
        this.lblSeasonPoster.setAlternativeText(BUNDLE.getString("image.notfound.poster"));
        this.lblSeasonPoster.setPosition(ImageLabel.Position.BOTTOM_LEFT);
        this.lblSeasonPoster.enableLightbox();
        this.lblSeasonPosterSize = new JLabel(BUNDLE.getString("mediafiletype.season_poster"));
        this.panelLeft.add(this.lblSeasonPosterSize);
        this.panelLeft.add(Box.createVerticalStrut(20));
        this.lblEpisodeThumb = new ImageLabel(false){
            private static final long serialVersionUID = -4774846565578766742L;

            @Override
            public Dimension getPreferredSize() {
                if (this.scaledImage != null && this.scaledImage.getWidth() > 10) {
                    return new Dimension(this.getParent().getWidth(), (int)((float)this.getParent().getWidth() / (float)this.scaledImage.getWidth() * (float)this.scaledImage.getHeight()));
                }
                return new Dimension(this.getParent().getWidth(), (int)((double)this.getParent().getWidth() / 16.0 * 9.0) + 1);
            }
        };
        this.lblEpisodeThumb.setDesiredAspectRatio(1.7777778f);
        this.panelLeft.add(this.lblEpisodeThumb);
        this.lblEpisodeThumb.setAlternativeText(BUNDLE.getString("image.notfound.thumb"));
        this.lblEpisodeThumb.setPosition(ImageLabel.Position.BOTTOM_LEFT);
        this.lblEpisodeThumb.enableLightbox();
        this.lblEpisodeThumbSize = new JLabel(BUNDLE.getString("mediafiletype.thumb"));
        this.panelLeft.add(this.lblEpisodeThumbSize);
        this.splitPaneVertical = new JSplitPane();
        this.splitPaneVertical.setBorder(null);
        this.splitPaneVertical.setResizeWeight(0.9);
        this.splitPaneVertical.setContinuousLayout(true);
        this.splitPaneVertical.setOneTouchExpandable(true);
        this.splitPaneVertical.setOrientation(0);
        this.add((Component)this.splitPaneVertical, "3, 1, fill, fill");
        this.panelTop = new JPanel();
        this.panelTop.setBorder(null);
        this.splitPaneVertical.setTopComponent(this.panelTop);
        this.panelTop.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200px:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{RowSpec.decode((String)"fill:default"), FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, RowSpec.decode((String)"fill:36px"), FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, RowSpec.decode((String)"top:50px:grow(2)")}));
        JPanel panelTvShowHeader = new JPanel();
        this.panelTop.add((Component)panelTvShowHeader, "2, 1, 3, 1, fill, top");
        panelTvShowHeader.setBorder(null);
        panelTvShowHeader.setLayout(new BorderLayout(0, 0));
        JPanel panelMovieTitle = new JPanel();
        panelTvShowHeader.add((Component)panelMovieTitle, "North");
        panelMovieTitle.setLayout(new BorderLayout(0, 0));
        this.lblTvShowName = new JLabel("");
        panelMovieTitle.add(this.lblTvShowName);
        TmmFontHelper.changeFont(this.lblTvShowName, 1.33, 1);
        this.panelWatched = new JPanel();
        panelMovieTitle.add((Component)this.panelWatched, "East");
        this.lblWatched = new JLabel("");
        this.panelWatched.add(this.lblWatched);
        JPanel panelRatingTagline = new JPanel();
        panelTvShowHeader.add((Component)panelRatingTagline, "Center");
        panelRatingTagline.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.DEFAULT_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"24px"), FormFactory.DEFAULT_ROWSPEC}));
        this.lblRating = new JLabel("");
        panelRatingTagline.add((Component)this.lblRating, "2, 2, left, center");
        this.lblVoteCount = new JLabel("");
        panelRatingTagline.add((Component)this.lblVoteCount, "3, 2, left, center");
        this.panelRatingStars = new StarRater(10, 1);
        panelRatingTagline.add((Component)this.panelRatingStars, "1, 2, left, top");
        this.panelRatingStars.setEnabled(false);
        this.lblEpisodeTitle = new JLabel();
        panelRatingTagline.add((Component)this.lblEpisodeTitle, "1, 3, 3, 1, default, center");
        this.panelTvShowLogos = new JPanel();
        panelTvShowHeader.add((Component)this.panelTvShowLogos, "East");
        this.lblCertificationImage = new JLabel();
        this.panelTvShowLogos.add(this.lblCertificationImage);
        this.separator = new JSeparator();
        this.panelTop.add((Component)this.separator, "2, 4, 3, 1");
        this.panelDetails = new TvShowEpisodeDetailsPanel(tvShowEpisodeSelectionModel);
        this.panelTop.add((Component)this.panelDetails, "2, 6, 3, 1");
        this.panelTop.add((Component)new JSeparator(), "2, 8, 3, 1");
        this.panelLogos = new JPanel();
        this.panelTop.add((Component)this.panelLogos, "2, 10, 3, 1");
        this.panelLogos.setOpaque(false);
        this.panelLogos.setLayout(new FlowLayout(1, 5, 5));
        this.lblMediaLogoResolution = new JLabel("");
        this.panelLogos.add(this.lblMediaLogoResolution);
        this.lblMediaLogoVideoCodec = new JLabel("");
        this.panelLogos.add(this.lblMediaLogoVideoCodec);
        this.lblMediaLogoAudio = new JLabel("");
        this.panelLogos.add(this.lblMediaLogoAudio);
        this.panelTop.add((Component)new JSeparator(), "2, 12, 3, 1");
        this.lblPlot = new JLabel(BUNDLE.getString("metatag.plot"));
        this.lblPlot.setFont(this.lblPlot.getFont().deriveFont(1));
        this.panelTop.add((Component)this.lblPlot, "2, 14");
        JScrollPane scrollPaneOverview = new JScrollPane();
        scrollPaneOverview.setBorder(null);
        this.tpOverview = new JTextPane();
        this.tpOverview.setOpaque(false);
        this.tpOverview.setEditable(false);
        scrollPaneOverview.setViewportView(this.tpOverview);
        JPanel panelOverview = new JPanel();
        this.panelTop.add((Component)panelOverview, "2, 15, 3, 1, fill, fill");
        panelOverview.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"fill:default:grow")}));
        panelOverview.add((Component)scrollPaneOverview, "1, 2, fill, fill");
        this.panelBottom = new JPanel();
        this.panelBottom.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"200px:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        this.splitPaneVertical.setBottomComponent(this.panelBottom);
        this.tabbedPaneTvShowEpisodeDetails = new JTabbedPane(1);
        this.panelBottom.add((Component)this.tabbedPaneTvShowEpisodeDetails, "1, 2, fill, fill");
        this.panelActors = new TvShowEpisodeCastPanel(tvShowEpisodeSelectionModel);
        this.tabbedPaneTvShowEpisodeDetails.addTab(BUNDLE.getString("metatag.cast"), null, this.panelActors, null);
        this.panelMediaInformation = new TvShowEpisodeMediaInformationPanel(tvShowEpisodeSelectionModel);
        this.tabbedPaneTvShowEpisodeDetails.addTab(BUNDLE.getString("metatag.mediainformation"), null, this.panelMediaInformation, null);
        this.panelMediaFiles = new TvShowEpisodeMediaFilesPanel(tvShowEpisodeSelectionModel);
        this.tabbedPaneTvShowEpisodeDetails.addTab(BUNDLE.getString("metatag.mediafiles"), null, this.panelMediaFiles, null);
        this.initDataBindings();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TvShowEpisode episode;
                String property = propertyChangeEvent.getPropertyName();
                Object source = propertyChangeEvent.getSource();
                if (source instanceof TvShowEpisodeSelectionModel) {
                    TvShowEpisodeSelectionModel model = (TvShowEpisodeSelectionModel)source;
                    TvShowEpisodeInformationPanel.this.setSeasonPoster(model.getSelectedTvShowEpisode());
                    TvShowEpisodeInformationPanel.this.setEpisodeThumb(model.getSelectedTvShowEpisode());
                }
                if (source.getClass() == TvShowEpisode.class && "thumb".equals(property)) {
                    episode = (TvShowEpisode)source;
                    TvShowEpisodeInformationPanel.this.setEpisodeThumb(episode);
                }
                if (source.getClass() == TvShowEpisode.class && "seasonPoster".equals(property)) {
                    episode = (TvShowEpisode)source;
                    TvShowEpisodeInformationPanel.this.setSeasonPoster(episode);
                }
            }
        };
        this.tvShowEpisodeSelectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void setSeasonPoster(TvShowEpisode tvShowEpisode) {
        this.lblSeasonPoster.clearImage();
        this.lblSeasonPoster.setImagePath(tvShowEpisode.getTvShowSeason().getPoster());
        Dimension posterSize = tvShowEpisode.getTvShowSeason().getPosterSize();
        if (posterSize.width > 0 && posterSize.height > 0) {
            this.lblSeasonPosterSize.setText(BUNDLE.getString("mediafiletype.season_poster") + " - " + posterSize.width + "x" + posterSize.height);
        } else {
            this.lblSeasonPosterSize.setText(BUNDLE.getString("mediafiletype.season_poster"));
        }
    }

    private void setEpisodeThumb(TvShowEpisode tvShowEpisode) {
        this.lblEpisodeThumb.clearImage();
        this.lblEpisodeThumb.setImagePath(tvShowEpisode.getArtworkFilename(MediaFileType.THUMB));
        Dimension thumbSize = tvShowEpisode.getArtworkDimension(MediaFileType.THUMB);
        if (thumbSize.width > 0 && thumbSize.height > 0) {
            this.lblEpisodeThumbSize.setText(BUNDLE.getString("mediafiletype.thumb") + " - " + thumbSize.width + "x" + thumbSize.height);
        } else {
            this.lblEpisodeThumbSize.setText(BUNDLE.getString("mediafiletype.thumb"));
        }
    }

    protected void initDataBindings() {
        BeanProperty tvShowEpisodeSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShowEpisode.tvShow.title");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty, (Object)this.lblTvShowName, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShowEpisode.titleForUi");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_1, (Object)this.lblEpisodeTitle, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedTvShowEpisode.plot");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_3, (Object)this.tpOverview, (Property)jTextPaneBeanProperty);
        autoBinding_3.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_4 = BeanProperty.create((String)"selectedTvShowEpisode.rating");
        BeanProperty starRaterBeanProperty = BeanProperty.create((String)"rating");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_4, (Object)this.panelRatingStars, (Property)starRaterBeanProperty);
        autoBinding_4.bind();
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_4, (Object)this.lblRating, (Property)jLabelBeanProperty);
        autoBinding_5.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_6 = BeanProperty.create((String)"selectedTvShowEpisode.mediaInfoVideoFormat");
        BeanProperty jLabelBeanProperty_1 = BeanProperty.create((String)"icon");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_6, (Object)this.lblMediaLogoResolution, (Property)jLabelBeanProperty_1);
        autoBinding_7.setConverter((Converter)new MediaInfoVideoFormatConverter());
        autoBinding_7.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_7 = BeanProperty.create((String)"selectedTvShowEpisode.mediaInfoVideoCodec");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_7, (Object)this.lblMediaLogoVideoCodec, (Property)jLabelBeanProperty_1);
        autoBinding_8.setConverter((Converter)new MediaInfoVideoCodecConverter());
        autoBinding_8.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_8 = BeanProperty.create((String)"selectedTvShowEpisode.mediaInfoAudioCodecAndChannels");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_8, (Object)this.lblMediaLogoAudio, (Property)jLabelBeanProperty_1);
        autoBinding_9.setConverter((Converter)new MediaInfoAudioCodecConverter());
        autoBinding_9.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_9 = BeanProperty.create((String)"selectedTvShowEpisode.tvShow.certification");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_9, (Object)this.lblCertificationImage, (Property)jLabelBeanProperty_1);
        autoBinding_10.setConverter((Converter)new CertificationImageConverter());
        autoBinding_10.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_10 = BeanProperty.create((String)"selectedTvShowEpisode.watched");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_10, (Object)this.lblWatched, (Property)jLabelBeanProperty_1);
        autoBinding_11.setConverter((Converter)new WatchedIconConverter());
        autoBinding_11.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedTvShowEpisode.votes");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_2, (Object)this.lblVoteCount, (Property)jLabelBeanProperty);
        autoBinding_2.setConverter((Converter)new VoteCountConverter());
        autoBinding_2.bind();
    }
}

