/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieRenameTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieSetRenameAction
extends AbstractAction {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final long serialVersionUID = 1677285197819210130L;

    public MovieSetRenameAction() {
        this.putValue("Name", BUNDLE.getString("movie.rename"));
        this.putValue("SwingLargeIconKey", new ImageIcon(this.getClass().getResource("/org/tinymediamanager/ui/images/rename-icon.png")));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/org/tinymediamanager/ui/images/rename-icon.png")));
        this.putValue("ShortDescription", BUNDLE.getString("movie.rename"));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        List<Movie> selectedMovies = MovieSetUIModule.getInstance().getSelectionModel().getSelectedMoviesRecursive();
        MovieRenameTask renameTask = new MovieRenameTask(selectedMovies);
        if (TmmTaskManager.getInstance().addMainTask(renameTask)) {
            JOptionPane.showMessageDialog(null, BUNDLE.getString("onlyoneoperation"));
        }
    }
}

