/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieMissingArtworkDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieDownloadMissingArtworkAction
extends AbstractAction {
    private static final long serialVersionUID = -4006932829840795735L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieDownloadMissingArtworkAction() {
        this.putValue("Name", BUNDLE.getString("movie.downloadmissingartwork"));
        this.putValue("SmallIcon", IconManager.IMAGE);
        this.putValue("SwingLargeIconKey", IconManager.IMAGE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (!selectedMovies.isEmpty()) {
            MovieMissingArtworkDownloadTask task = new MovieMissingArtworkDownloadTask(selectedMovies);
            TmmTaskManager.getInstance().addDownloadTask(task);
        }
    }
}

