/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.tinymediamanager.core.entities.MediaFile;

public class MovieMediaFileComparator
implements Comparator<MediaFile> {
    private List<String> discImageTypes = Arrays.asList("iso", "bin", "dat", "img", "nrg", "disc");

    @Override
    public int compare(MediaFile mf1, MediaFile mf2) {
        if (mf1.getType().ordinal() != mf2.getType().ordinal()) {
            return mf1.getType().ordinal() - mf2.getType().ordinal();
        }
        if (this.discImageTypes.contains(mf1.getExtension()) && !this.discImageTypes.contains(mf2.getExtension())) {
            return 1;
        }
        if (!this.discImageTypes.contains(mf1.getExtension()) && this.discImageTypes.contains(mf2.getExtension())) {
            return -1;
        }
        return mf1.getFilename().compareTo(mf2.getFilename());
    }
}

