/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.renderer;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class HighlightCellRenderer
extends DefaultListCellRenderer {
    private StringBuffer sb = new StringBuffer();
    private String highlightText = "";
    private boolean caseSensitive;

    public HighlightCellRenderer(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setHighlightText(String highlightText) {
        this.highlightText = highlightText;
        if (this.highlightText == null) {
            this.highlightText = "";
        }
    }

    public String getHighlightText() {
        return this.highlightText;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (this.highlightText.length() == 0) {
            return this;
        }
        String originalText = value.toString();
        String text = null;
        text = this.caseSensitive ? originalText : originalText.toLowerCase();
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        int i = 0;
        while (i > -1) {
            if ((i = text.indexOf(this.highlightText, i)) <= -1) continue;
            indexs.add(i);
            i += this.highlightText.length();
        }
        this.sb.setLength(0);
        this.sb.append("<html>");
        int is = 0;
        Iterator i$ = indexs.iterator();
        while (i$.hasNext()) {
            int ii = (Integer)i$.next();
            this.sb.append(originalText.substring(is, ii));
            this.sb.append("<u>");
            this.sb.append(originalText.substring(ii, ii + this.highlightText.length()));
            this.sb.append("</u>");
            is = ii + this.highlightText.length();
        }
        if (is < originalText.length()) {
            this.sb.append(originalText.substring(is, originalText.length()));
        }
        this.sb.append("</html>");
        this.setText(this.sb.toString());
        return this;
    }
}

