/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.model;

import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public abstract class AbstractNumberDocument<T extends Number, P extends Number>
extends PlainDocument {
    private static final long serialVersionUID = 2L;
    protected String separator;
    private String validateRegex;
    private String insertRegex;
    protected T maxValue;
    private Locale locale;
    protected T minValue;

    public AbstractNumberDocument(Locale locale, boolean acceptFraction) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
        if (acceptFraction) {
            DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance(locale);
            this.separator = Character.toString(dfs.getDecimalSeparator());
            this.validateRegex = "([-]{1,1})?[0-9]{1,}([" + this.separator + "][0-9]{1,})?";
            this.insertRegex = "([-]{1,1})?([0-9]{1,})?([" + this.separator + "])?([0-9]{1,})?";
        } else {
            this.validateRegex = "([-]{1,1})?[0-9]{1,}";
            this.insertRegex = "([-]{1,1})?([0-9]{1,})?";
        }
    }

    protected final Locale getLocale() {
        return this.locale;
    }

    protected String getValidateRegex() {
        return this.validateRegex;
    }

    protected abstract P parse(String var1);

    protected abstract String format(T var1);

    protected String getText() throws BadLocationException {
        return this.getText(0, this.getLength());
    }

    protected abstract boolean isAcceptableValue(P var1);

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        P number;
        String text = this.getText();
        String newText = text.substring(0, offs) + str + text.substring(offs, text.length());
        if (newText.matches(this.insertRegex) && ((number = this.parse(newText)) == null || number != null && this.isAcceptableValue(number))) {
            super.insertString(offs, str, a);
        }
    }
}

