/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.contentdirectory.ui;

import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import org.fourthline.cling.controlpoint.ActionCallback;
import org.fourthline.cling.controlpoint.ControlPoint;
import org.fourthline.cling.model.meta.Service;
import org.fourthline.cling.support.contentdirectory.ui.ContentBrowseActionCallbackCreator;

public class ContentTreeExpandListener
implements TreeWillExpandListener {
    protected final ControlPoint controlPoint;
    protected final Service service;
    protected final DefaultTreeModel treeModel;
    protected final ContentBrowseActionCallbackCreator actionCreator;

    public ContentTreeExpandListener(ControlPoint controlPoint, Service service, DefaultTreeModel treeModel, ContentBrowseActionCallbackCreator actionCreator) {
        this.controlPoint = controlPoint;
        this.service = service;
        this.treeModel = treeModel;
        this.actionCreator = actionCreator;
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
        treeNode.removeAllChildren();
        this.treeModel.nodeStructureChanged(treeNode);
        ActionCallback callback = this.actionCreator.createContentBrowseActionCallback(this.service, this.treeModel, treeNode);
        this.controlPoint.execute(callback);
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
    }
}

