/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class IconManager {
    private static final Map<URI, ImageIcon> ICON_CACHE = new HashMap<URI, ImageIcon>();
    public static final ImageIcon EMPTY_IMAGE = new ImageIcon(IconManager.class.getResource("images/empty.png"));
    public static final ImageIcon APPLY = IconManager.loadImage("apply.png");
    public static final ImageIcon ARROW_UP = IconManager.loadImage("arrow-up.png");
    public static final ImageIcon ARROW_DOWN = IconManager.loadImage("arrow-down.png");
    public static final ImageIcon BUG = IconManager.loadImage("bug.png");
    public static final ImageIcon CANCEL = IconManager.loadImage("cancel.png");
    public static final ImageIcon CHECK_ALL = IconManager.loadImage("check-all.png");
    public static final ImageIcon CHECKMARK = IconManager.loadImage("checkmark.png");
    public static final ImageIcon CLAPBOARD = IconManager.loadImage("clapboard.png");
    public static final ImageIcon COPY = IconManager.loadImage("copy.png");
    public static final ImageIcon CROSS = IconManager.loadImage("cross.png");
    public static final ImageIcon DATE_PICKER = IconManager.loadImage("datepicker.png");
    public static final ImageIcon DELETE = IconManager.loadImage("delete.png");
    public static final ImageIcon DOWNLOAD = IconManager.loadImage("download.png");
    public static final ImageIcon DOWNLOAD_DISABLED = IconManager.loadImage("download-disabled.png");
    public static final ImageIcon EDIT = IconManager.loadImage("edit.png");
    public static final ImageIcon ERROR = IconManager.loadImage("error.png");
    public static final ImageIcon EXIT = IconManager.loadImage("exit.png");
    public static final ImageIcon EXPORT = IconManager.loadImage("export.png");
    public static final ImageIcon FEEDBACK = IconManager.loadImage("feedback.png");
    public static final ImageIcon FILE_OPEN = IconManager.loadImage("file-open.png");
    public static final ImageIcon FILTER = IconManager.loadImage("filter.png");
    public static final ImageIcon FILTER_ACTIVE = IconManager.loadImage("filter_active.png");
    public static final ImageIcon HINT = IconManager.loadImage("hint.png");
    public static final ImageIcon IMAGE = IconManager.loadImage("image.png");
    public static final ImageIcon INFO = IconManager.loadImage("info.png");
    public static final ImageIcon LIST_ADD = IconManager.loadImage("list-add.png");
    public static final ImageIcon LIST_REMOVE = IconManager.loadImage("list-remove.png");
    public static final ImageIcon LOADING = IconManager.loadImage("loading.gif");
    public static final ImageIcon NEW = IconManager.loadImage("new.png");
    public static final ImageIcon PLAY_SMALL = IconManager.loadImage("play-small.png");
    public static final ImageIcon PLAY = IconManager.loadImage("play.png");
    public static final ImageIcon PROCESS_STOP = IconManager.loadImage("process-stop.png");
    public static final ImageIcon REFRESH = IconManager.loadImage("refresh.png");
    public static final ImageIcon REGISTER = IconManager.loadImage("register.png");
    public static final ImageIcon SEARCH = IconManager.loadImage("search.png");
    public static final ImageIcon SETTINGS_SMALL = IconManager.loadImage("settings-small.png");
    public static final ImageIcon STAR_FILLED = IconManager.loadImage("star-filled.png");
    public static final ImageIcon STAR_EMPTY = IconManager.loadImage("star-empty.png");
    public static final ImageIcon SUBTITLE = IconManager.loadImage("subtitle.png");
    public static final ImageIcon SYNC = IconManager.loadImage("sync.png");
    public static final ImageIcon UNCHECK_ALL = IconManager.loadImage("uncheck-all.png");
    public static final ImageIcon UNWATCHED = IconManager.loadImage("unwatched.png");

    private static ImageIcon loadImage(String name) {
        URL file = IconManager.class.getResource("/images/ui/" + name);
        if (file != null) {
            return new ImageIcon(file);
        }
        return EMPTY_IMAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon loadImageFromURL(URL url) {
        URI uri = null;
        if (url == null) {
            return EMPTY_IMAGE;
        }
        try {
            uri = url.toURI();
            if (uri == null) {
                return EMPTY_IMAGE;
            }
        }
        catch (Exception e) {
            return EMPTY_IMAGE;
        }
        ImageIcon icon = ICON_CACHE.get(uri);
        if (icon == null) {
            try {
                icon = new ImageIcon(url);
            }
            catch (Exception exception) {
            }
            finally {
                if (icon == null) {
                    icon = EMPTY_IMAGE;
                }
            }
            ICON_CACHE.put(uri, icon);
        }
        return icon;
    }
}

