/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.SwingConstants;

public class EqualsLayout
implements LayoutManager,
SwingConstants {
    private int gap;
    private int alignment;
    private int minWidth = 0;

    public EqualsLayout(int alignment, int gap) {
        this.setGap(gap);
        this.setAlignment(alignment);
    }

    public EqualsLayout(int gap) {
        this(4, gap);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getGap() {
        return this.gap;
    }

    public void setMinWidth(int width) {
        this.minWidth = width;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    private Dimension[] dimensions(Component[] children) {
        int maxWidth = 0;
        int maxHeight = 0;
        int visibleCount = 0;
        int c = children.length;
        for (int i = 0; i < c; ++i) {
            if (!children[i].isVisible()) continue;
            Dimension componentPreferredSize = children[i].getPreferredSize();
            maxWidth = Math.max(maxWidth, componentPreferredSize.width);
            maxHeight = Math.max(maxHeight, componentPreferredSize.height);
            ++visibleCount;
        }
        if (maxWidth < this.minWidth) {
            maxWidth = this.minWidth;
        }
        int usedWidth = maxWidth * visibleCount + this.gap * (visibleCount - 1);
        int usedHeight = maxHeight;
        return new Dimension[]{new Dimension(maxWidth, maxHeight), new Dimension(usedWidth, usedHeight)};
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Component[] children = container.getComponents();
        Dimension[] dim = this.dimensions(children);
        int maxWidth = dim[0].width;
        int maxHeight = dim[0].height;
        int usedWidth = dim[1].width;
        switch (this.alignment) {
            case 1: 
            case 2: {
                int c = children.length;
                for (int i = 0; i < c; ++i) {
                    if (!children[i].isVisible()) continue;
                    children[i].setBounds(insets.left + (maxWidth + this.gap) * i, insets.top, maxWidth, maxHeight);
                }
                break;
            }
            case 3: 
            case 4: {
                int c = children.length;
                for (int i = 0; i < c; ++i) {
                    if (!children[i].isVisible()) continue;
                    children[i].setBounds(container.getWidth() - insets.right - usedWidth + (maxWidth + this.gap) * i, insets.top, maxWidth, maxHeight);
                }
                break;
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container c) {
        return this.preferredLayoutSize(c);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Component[] children = container.getComponents();
        Dimension[] dim = this.dimensions(children);
        int usedWidth = dim[1].width;
        int usedHeight = dim[1].height;
        return new Dimension(insets.left + usedWidth + insets.right, insets.top + usedHeight + insets.bottom);
    }

    @Override
    public void addLayoutComponent(String string, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component c) {
    }
}

