/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public enum MovieEdition {
    NONE("", ""),
    DIRECTORS_CUT("Director's Cut", ".Director.?s.(Cut|Edition|Version)"),
    EXTENDED_EDITION("Extended Edition", ".Extended.(Cut|Edition|Version)?"),
    THEATRICAL_EDITION("Theatrical Edition", ".Theatrical.(Cut|Edition|Version)?"),
    UNRATED("Unrated", ".Unrated.(Cut|Edition|Version)?"),
    UNCUT("Uncut", ".Uncut.(Cut|Edition|Version)?"),
    IMAX("IMAX", "IMAX.(Cut|Edition|Version)?"),
    SPECIAL_EDITION("Special Edition", ".(Special|Remastered|Collectors|Ultimate).(Cut|Edition|Version)");

    private String title;
    private Pattern pattern;

    private MovieEdition(String title, String pattern) {
        this.title = title;
        this.pattern = StringUtils.isBlank((CharSequence)pattern) ? null : Pattern.compile(pattern, 2);
    }

    public String getTitle() {
        return this.title;
    }

    public String toString() {
        return this.title;
    }

    public static MovieEdition getMovieEditionFromString(String stringToParse) {
        MovieEdition foundEdition = NONE;
        for (MovieEdition edition : MovieEdition.values()) {
            if (edition == NONE) continue;
            if (edition.name().equalsIgnoreCase(stringToParse)) {
                foundEdition = edition;
                break;
            }
            if (edition.title.equalsIgnoreCase(stringToParse)) {
                foundEdition = edition;
                break;
            }
            Matcher matcher = edition.pattern.matcher(stringToParse);
            if (!matcher.find()) continue;
            foundEdition = edition;
            break;
        }
        return foundEdition;
    }
}

