/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt5.services;

import com.uwetrottmann.trakt5.entities.BaseMovie;
import com.uwetrottmann.trakt5.entities.BaseShow;
import com.uwetrottmann.trakt5.entities.LastActivities;
import com.uwetrottmann.trakt5.entities.RatedEpisode;
import com.uwetrottmann.trakt5.entities.RatedMovie;
import com.uwetrottmann.trakt5.entities.RatedSeason;
import com.uwetrottmann.trakt5.entities.RatedShow;
import com.uwetrottmann.trakt5.entities.SyncItems;
import com.uwetrottmann.trakt5.entities.SyncResponse;
import com.uwetrottmann.trakt5.entities.WatchlistedEpisode;
import com.uwetrottmann.trakt5.entities.WatchlistedSeason;
import com.uwetrottmann.trakt5.enums.Extended;
import com.uwetrottmann.trakt5.enums.RatingsFilter;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface Sync {
    @GET(value="sync/last_activities")
    public Call<LastActivities> lastActivities();

    @GET(value="sync/collection/movies")
    public Call<List<BaseMovie>> collectionMovies(@Query(value="extended", encoded=true) Extended var1);

    @GET(value="sync/collection/shows")
    public Call<List<BaseShow>> collectionShows(@Query(value="extended", encoded=true) Extended var1);

    @POST(value="sync/collection")
    public Call<SyncResponse> addItemsToCollection(@Body SyncItems var1);

    @POST(value="sync/collection/remove")
    public Call<SyncResponse> deleteItemsFromCollection(@Body SyncItems var1);

    @GET(value="sync/watched/movies")
    public Call<List<BaseMovie>> watchedMovies(@Query(value="extended", encoded=true) Extended var1);

    @GET(value="sync/watched/shows")
    public Call<List<BaseShow>> watchedShows(@Query(value="extended", encoded=true) Extended var1);

    @POST(value="sync/history")
    public Call<SyncResponse> addItemsToWatchedHistory(@Body SyncItems var1);

    @POST(value="sync/history/remove")
    public Call<SyncResponse> deleteItemsFromWatchedHistory(@Body SyncItems var1);

    @GET(value="sync/ratings/movies{rating}")
    public Call<List<RatedMovie>> ratingsMovies(@Path(value="rating", encoded=true) RatingsFilter var1, @Query(value="extended", encoded=true) Extended var2);

    @GET(value="sync/ratings/shows{rating}")
    public Call<List<RatedShow>> ratingsShows(@Path(value="rating", encoded=true) RatingsFilter var1, @Query(value="extended", encoded=true) Extended var2);

    @GET(value="sync/ratings/seasons{rating}")
    public Call<List<RatedSeason>> ratingsSeasons(@Path(value="rating", encoded=true) RatingsFilter var1, @Query(value="extended", encoded=true) Extended var2);

    @GET(value="sync/ratings/episodes{rating}")
    public Call<List<RatedEpisode>> ratingsEpisodes(@Path(value="rating", encoded=true) RatingsFilter var1, @Query(value="extended", encoded=true) Extended var2);

    @POST(value="sync/ratings")
    public Call<SyncResponse> addRatings(@Body SyncItems var1);

    @POST(value="sync/ratings/remove")
    public Call<SyncResponse> deleteRatings(@Body SyncItems var1);

    @GET(value="sync/watchlist/movies")
    public Call<List<BaseMovie>> watchlistMovies(@Query(value="extended", encoded=true) Extended var1);

    @GET(value="sync/watchlist/shows")
    public Call<List<BaseShow>> watchlistShows(@Query(value="extended", encoded=true) Extended var1);

    @GET(value="sync/watchlist/seasons")
    public Call<List<WatchlistedSeason>> watchlistSeasons(@Query(value="extended", encoded=true) Extended var1);

    @GET(value="sync/watchlist/episodes")
    public Call<List<WatchlistedEpisode>> watchlistEpisodes(@Query(value="extended", encoded=true) Extended var1);

    @POST(value="sync/watchlist")
    public Call<SyncResponse> addItemsToWatchlist(@Body SyncItems var1);

    @POST(value="sync/watchlist/remove")
    public Call<SyncResponse> deleteItemsFromWatchlist(@Body SyncItems var1);
}

