/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.imgscalr.Scalr;
import org.japura.gui.CheckComboBox;
import org.japura.gui.CheckList;
import org.japura.gui.model.ListCheckModel;
import org.japura.gui.renderer.CheckListRenderer;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.IconManager;

public class MediaScraperCheckComboBox
extends CheckComboBox {
    private static final long serialVersionUID = 1143686322977103280L;

    public MediaScraperCheckComboBox() {
        this.setRenderer(new IconCheckListRenderer());
    }

    class IconCheckListRenderer
    extends CheckListRenderer {
        private static final long serialVersionUID = -5195029492716016109L;
        protected JPanel panel = new JPanel();
        protected JLabel label = new JLabel();
        private Map<URI, ImageIcon> imageCache;

        public IconCheckListRenderer() {
            this.panel.setLayout(new FlowLayout(0));
            this.panel.add((Component)((Object)this));
            this.panel.add(this.label);
            this.label.setOpaque(false);
            this.setOpaque(false);
            this.imageCache = new HashMap<URI, ImageIcon>();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (list instanceof CheckList) {
                int maxWidth = 0;
                for (int i = 0; i < list.getModel().getSize(); ++i) {
                    Object obj = list.getModel().getElementAt(i);
                    if (!(obj instanceof MediaScraper)) continue;
                    MediaScraper ms = (MediaScraper)obj;
                    ImageIcon logo = this.getIcon(ms.getLogoURL());
                    maxWidth = Math.max(maxWidth, logo.getIconWidth());
                }
                CheckList cbl = (CheckList)list;
                ListCheckModel model = cbl.getModel();
                boolean checked = model.isChecked(value);
                boolean locked = model.isLocked(value);
                this.setSelected(checked);
                if (locked || !cbl.isEnabled()) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                }
                if (this.getHighlight().equals((Object)CheckListRenderer.Highlight.MOUSE_OVER_AND_CHECKED_ITEMS) && (checked || isSelected)) {
                    this.panel.setBackground(this.selectionBackground);
                    this.panel.setForeground(this.selectionForeground);
                } else if (this.getHighlight().equals((Object)CheckListRenderer.Highlight.MOUSE_OVER) && isSelected) {
                    this.panel.setBackground(this.selectionBackground);
                    this.panel.setForeground(this.selectionForeground);
                } else if (this.getHighlight().equals((Object)CheckListRenderer.Highlight.CHECKED_ITEMS) && checked) {
                    this.panel.setBackground(this.selectionBackground);
                    this.panel.setForeground(this.selectionForeground);
                } else {
                    this.panel.setBackground(this.background);
                    this.panel.setForeground(this.foreground);
                }
                if (value instanceof MediaScraper) {
                    MediaScraper scraper = (MediaScraper)value;
                    int currentWidth = 0;
                    ImageIcon logo = this.getIcon(scraper.getLogoURL());
                    if (logo != null) {
                        currentWidth = logo.getIconWidth();
                    }
                    this.label.setIcon(logo);
                    this.label.setIconTextGap(maxWidth + 4 - currentWidth);
                } else {
                    this.label.setIcon(null);
                    this.label.setIconTextGap(4);
                }
            }
            this.label.setText(this.getText(value));
            return this.panel;
        }

        private ImageIcon getIcon(URL url) {
            try {
                URI uri = url.toURI();
                ImageIcon logo = this.imageCache.get(uri);
                if (logo == null) {
                    logo = this.getScaledIcon(IconManager.loadImageFromURL(url));
                    this.imageCache.put(uri, logo);
                }
                return logo;
            }
            catch (Exception exception) {
                return null;
            }
        }

        private ImageIcon getScaledIcon(ImageIcon original) {
            Canvas c = new Canvas();
            FontMetrics fm = c.getFontMetrics(this.getFont());
            int height = (int)((float)fm.getHeight() * 2.0f);
            int width = original.getIconWidth() / original.getIconHeight() * height;
            BufferedImage scaledImage = Scalr.resize((BufferedImage)ImageCache.createImage(original.getImage()), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
            return new ImageIcon(scaledImage);
        }
    }
}

