/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.thirdparty.MediaInfo;

public class MediaInfoUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaInfoUtils.class);

    public static void loadMediaInfo() {
        try {
            String miv = "";
            if (!Platform.isLinux()) {
                String nativepath = "native/";
                if (Platform.isWindows()) {
                    nativepath = nativepath + "windows";
                } else if (Platform.isLinux()) {
                    nativepath = nativepath + "linux";
                } else if (Platform.isMac()) {
                    nativepath = nativepath + "mac";
                }
                if (!Platform.isMac()) {
                    nativepath = Platform.is64Bit() ? nativepath + "-x64" : nativepath + "-x86";
                }
                if (System.getProperty("user.dir", "").startsWith("\\\\") || System.getProperty("user.dir", "").startsWith("//")) {
                    LOGGER.debug("We're on a network UNC path!");
                    File tmpDir = new File(System.getProperty("java.io.tmpdir"), "tmm");
                    File nativeDir = new File(tmpDir, nativepath);
                    FileUtils.copyDirectory((File)new File(nativepath), (File)nativeDir);
                    System.setProperty("jna.library.path", nativeDir.getAbsolutePath());
                    LOGGER.debug("Loading native mediainfo lib from: {}", (Object)nativeDir.getAbsolutePath());
                    miv = MediaInfo.version();
                } else {
                    System.setProperty("jna.library.path", nativepath);
                    LOGGER.debug("Loading native mediainfo lib from: {}", (Object)nativepath);
                    miv = MediaInfo.version();
                }
            } else {
                miv = MediaInfo.version();
            }
            if (!StringUtils.isEmpty((CharSequence)miv)) {
                LOGGER.info("Using " + miv);
            } else {
                LOGGER.error("could not load MediaInfo!");
                if (Platform.isLinux()) {
                    LOGGER.error("Please try do install the library from your distribution");
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not load mediainfo", (Throwable)e);
        }
    }
}

