/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.tmdb2;

import com.uwetrottmann.tmdb2.Tmdb;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class TmdbInterceptor
implements Interceptor {
    private Tmdb tmdb;

    public TmdbInterceptor(Tmdb tmdb) {
        this.tmdb = tmdb;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return TmdbInterceptor.handleIntercept(chain, this.tmdb.apiKey());
    }

    public static Response handleIntercept(Interceptor.Chain chain, String apiKey) throws IOException {
        Request request = chain.request();
        if (!"api.themoviedb.org".equals(request.url().host())) {
            return chain.proceed(request);
        }
        HttpUrl.Builder urlBuilder = request.url().newBuilder();
        urlBuilder.setEncodedQueryParameter("api_key", apiKey);
        Request.Builder builder = request.newBuilder();
        builder.url(urlBuilder.build());
        return chain.proceed(builder.build());
    }
}

