/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.ui.UTF8Control;

public class MovieRenameTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieRenameTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<Movie> moviesToRename;

    public MovieRenameTask(List<Movie> moviesToRename) {
        super(BUNDLE.getString("movie.rename"));
        this.moviesToRename = moviesToRename;
    }

    @Override
    protected void doInBackground() {
        try {
            this.initThreadPool(1, "rename");
            this.start();
            for (int i = 0; i < this.moviesToRename.size() && !this.cancel; ++i) {
                Movie movie = this.moviesToRename.get(i);
                this.submitTask(new RenameMovieTask(movie));
            }
            this.waitForCompletionOrCancel();
            LOGGER.info("Done renaming movies)");
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "Settings.renamer", "message.renamer.threadcrashed"));
        }
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }

    private class RenameMovieTask
    implements Callable<Object> {
        private Movie movie = null;

        public RenameMovieTask(Movie movie) {
            this.movie = movie;
        }

        @Override
        public String call() throws Exception {
            MovieRenamer.renameMovie(this.movie);
            return this.movie.getTitle();
        }
    }
}

