/*
 * Decompiled with CFR 0.152.
 */
package org.japura.util.date;

import java.util.HashMap;
import java.util.Locale;
import org.japura.util.date.LocaleToMask;

public enum DateMask {
    DDMMYYYY(1),
    MMDDYYYY(2),
    YYYYMMDD(3),
    YYYYDDMM(4);

    private final int id;
    private static HashMap<String, HashMap<String, DateMask>> registerMasks;

    private DateMask(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static DateMask getMask(int id) {
        for (DateMask dm : DateMask.values()) {
            if (dm.getId() != id) continue;
            return dm;
        }
        return null;
    }

    public static synchronized void register(Locale locale, DateMask mask) {
        HashMap<String, DateMask> langMap;
        if (locale == null || mask == null) {
            return;
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (registerMasks == null) {
            registerMasks = new HashMap();
        }
        if ((langMap = registerMasks.get(language)) == null) {
            langMap = new HashMap();
            registerMasks.put(language, langMap);
        }
        langMap.put(country, mask);
    }

    public static synchronized void unregister(Locale locale) {
        String language;
        HashMap<String, DateMask> langMap;
        if (registerMasks != null && (langMap = registerMasks.get(language = locale.getLanguage())) != null) {
            String country = locale.getCountry();
            langMap.remove(country);
            if (langMap.size() == 0) {
                registerMasks.remove(language);
                if (registerMasks.size() == 0) {
                    registerMasks = null;
                }
            }
        }
    }

    public static synchronized DateMask getMask(Locale locale) {
        String country;
        DateMask mask;
        String language;
        HashMap<String, DateMask> langMap;
        if (registerMasks != null && (langMap = registerMasks.get(language = locale.getLanguage())) != null && (mask = langMap.get(country = locale.getCountry())) != null) {
            return mask;
        }
        DateMask mask2 = LocaleToMask.getMask(locale);
        if (mask2 == null) {
            throw new RuntimeException("There is no DateMask for locale: " + locale);
        }
        return mask2;
    }
}

