/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.UpnpServiceImpl;
import org.fourthline.cling.binding.LocalServiceBindingException;
import org.fourthline.cling.controlpoint.ActionCallback;
import org.fourthline.cling.model.ValidationException;
import org.fourthline.cling.model.action.ActionInvocation;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.message.header.UDADeviceTypeHeader;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.model.meta.Device;
import org.fourthline.cling.model.meta.Service;
import org.fourthline.cling.model.types.DeviceType;
import org.fourthline.cling.model.types.ServiceId;
import org.fourthline.cling.model.types.UDADeviceType;
import org.fourthline.cling.model.types.UDAServiceId;
import org.fourthline.cling.registry.RegistrationException;
import org.fourthline.cling.registry.RegistryListener;
import org.fourthline.cling.support.avtransport.callback.Play;
import org.fourthline.cling.support.avtransport.callback.SetAVTransportURI;
import org.fourthline.cling.support.avtransport.callback.Stop;
import org.fourthline.cling.support.contentdirectory.DIDLParser;
import org.fourthline.cling.support.model.DIDLContent;
import org.fourthline.cling.support.model.Res;
import org.fourthline.cling.support.model.item.Item;
import org.fourthline.cling.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.thirdparty.NetworkUtil;
import org.tinymediamanager.thirdparty.upnp.MediaServer;
import org.tinymediamanager.thirdparty.upnp.Metadata;
import org.tinymediamanager.thirdparty.upnp.UpnpListener;
import org.tinymediamanager.thirdparty.upnp.WebServer;

public class Upnp {
    private static final Logger LOGGER = LoggerFactory.getLogger(Upnp.class);
    public static final String IP = NetworkUtil.getMachineIPAddress();
    public static final String ID_ROOT = "0";
    public static final String ID_MOVIES = "1";
    public static final String ID_TVSHOWS = "2";
    private static Upnp instance;
    private UpnpService upnpService = null;
    private WebServer webServer = null;
    private Service playerService = null;

    private Upnp() {
    }

    public static synchronized Upnp getInstance() {
        if (instance == null) {
            instance = new Upnp();
        }
        return instance;
    }

    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    public void createUpnpService() {
        if (this.upnpService == null) {
            this.upnpService = new UpnpServiceImpl(new RegistryListener[]{UpnpListener.getListener()});
        }
    }

    public void sendPlayerSearchRequest() {
        this.createUpnpService();
        this.upnpService.getControlPoint().search((UpnpHeader)new UDADeviceTypeHeader((DeviceType)new UDADeviceType("MediaRenderer")));
    }

    public List<Device> getAvailablePlayers() {
        this.createUpnpService();
        ArrayList<Device> ret = new ArrayList<Device>();
        for (Device device : this.upnpService.getRegistry().getDevices()) {
            if (!device.getType().getType().equals("MediaRenderer")) continue;
            ret.add(device);
        }
        return ret;
    }

    public void setPlayer(Device device) {
        this.playerService = device.findService((ServiceId)new UDAServiceId("AVTransport"));
        if (this.playerService == null) {
            LOGGER.warn("Could not find AVTransportService on device " + device.getDisplayString());
        }
    }

    public void playFile(MediaEntity me, MediaFile mf) {
        if (this.playerService == null) {
            LOGGER.warn("No player set - did you call setPlayer(Device) ?");
            return;
        }
        if (mf == null) {
            LOGGER.warn("parameters empty!");
            return;
        }
        String url = "";
        String meta = "NO METADATA";
        if (me != null) {
            try {
                DIDLContent didl = new DIDLContent();
                DIDLParser dip = new DIDLParser();
                if (me instanceof Movie) {
                    didl.addItem((Item)Metadata.getUpnpMovie((Movie)me, true));
                } else if (me instanceof TvShowEpisode) {
                    didl.addItem((Item)Metadata.getUpnpTvShowEpisode(((TvShowEpisode)me).getTvShow(), (TvShowEpisode)me, true));
                }
                url = ((Res)((Item)didl.getItems().get(0)).getResources().get(0)).getValue();
                meta = dip.generate(didl);
            }
            catch (Exception e) {
                LOGGER.warn("Could not generate metadata / url");
                return;
            }
        }
        SetAVTransportURI setAVTransportURIAction = new SetAVTransportURI(this.playerService, url, meta){

            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                LOGGER.warn("Setting URL for player failed! " + defaultMsg);
            }
        };
        this.upnpService.getControlPoint().execute((ActionCallback)setAVTransportURIAction);
        Play playAction = new Play(this.playerService){

            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                LOGGER.warn("Playing failed! " + defaultMsg);
            }
        };
        this.upnpService.getControlPoint().execute((ActionCallback)playAction);
    }

    public void stopPlay() {
        if (this.playerService == null) {
            return;
        }
        Stop stopAction = new Stop(this.playerService){

            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                LOGGER.warn("Stopping failed! " + defaultMsg);
            }
        };
        this.upnpService.getControlPoint().execute((ActionCallback)stopAction);
    }

    public void startWebServer() {
        try {
            if (this.webServer == null) {
                this.webServer = new WebServer();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not start WebServer!", (Throwable)e);
        }
    }

    public void stopWebServer() {
        if (this.webServer != null) {
            this.webServer.closeAllConnections();
        }
    }

    public void startMediaServer() {
        this.createUpnpService();
        try {
            this.upnpService.getRegistry().addDevice(MediaServer.createDevice());
        }
        catch (IOException | LocalServiceBindingException | ValidationException | RegistrationException e) {
            LOGGER.warn("could not start UPNP MediaServer!", e);
        }
    }

    public void stopMediaServer() {
        if (this.upnpService != null) {
            this.upnpService.getRegistry().removeAllLocalDevices();
        }
    }

    public void shutdown() {
        this.stopPlay();
        this.stopWebServer();
        this.stopMediaServer();
        if (this.upnpService != null) {
            try {
                this.upnpService.getRouter().shutdown();
            }
            catch (RouterException e) {
                LOGGER.warn("Could not shutdown the UPNP router.");
            }
            this.upnpService.shutdown();
        }
    }
}

