/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.observablecollections.ObservableCollections;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.tvshow.TvShowEpisodeThumbNaming;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaLanguages;

@XmlRootElement(name="TvShowSettings")
public class TvShowSettings
extends AbstractModelObject {
    private static final String TV_SHOW_DATA_SOURCE = "tvShowDataSource";
    private static final String TV_SHOW_SCRAPER = "tvShowScraper";
    private static final String TV_SHOW_ARTWORK_SCRAPERS = "tvShowArtworkScrapers";
    private static final String PATH = "path";
    private static final String SCRAPE_BEST_IMAGE = "scrapeBestImage";
    private static final String SCRAPER_LANGU = "scraperLanguage";
    private static final String SUBTITLE_SCRAPER_LANGU = "subtitleScraperLanguage";
    private static final String CERTIFICATION_COUNTRY = "certificationCountry";
    private static final String RENAMER_SEASON_FOLDER = "renamerSeasonFoldername";
    private static final String BUILD_IMAGE_CACHE_ON_IMPORT = "buildImageCacheOnImport";
    private static final String ASCII_REPLACEMENT = "asciiReplacement";
    private static final String BAD_WORDS = "badWords";
    private static final String ENTRY = "entry";
    private static final String TV_SHOW_SKIP_FOLDERS = "tvShowSkipFolders";
    private static final String TV_SHOW_SUBTITLE_SCRAPERS = "tvShowSubtitleScrapers";
    @XmlElementWrapper(name="tvShowDataSource")
    @XmlElement(name="path")
    private final List<String> tvShowDataSources = ObservableCollections.observableList(new ArrayList());
    @XmlElementWrapper(name="badWords")
    @XmlElement(name="entry")
    private final List<String> badWords = ObservableCollections.observableList(new ArrayList());
    @XmlElementWrapper(name="tvShowArtworkScrapers")
    @XmlElement(name="entry")
    private final List<String> tvShowArtworkScrapers = ObservableCollections.observableList(new ArrayList());
    @XmlElementWrapper(name="tvShowSkipFolders")
    @XmlElement(name="entry")
    private final List<String> tvShowSkipFolders = ObservableCollections.observableList(new ArrayList());
    @XmlElementWrapper(name="tvShowSubtitleScrapers")
    @XmlElement(name="entry")
    private final List<String> tvShowSubtitleScrapers = ObservableCollections.observableList(new ArrayList());
    private String tvShowScraper = "tvdb";
    private boolean scrapeBestImage = true;
    private MediaLanguages scraperLanguage = MediaLanguages.en;
    private MediaLanguages subtitleScraperLanguage = MediaLanguages.en;
    private CountryCode certificationCountry = CountryCode.US;
    private String renamerTvShowFoldername = "$N ($Y)";
    private String renamerSeasonFoldername = "Season $1";
    private String renamerFilename = "$N - S$2E$E - $T";
    private TvShowEpisodeThumbNaming tvShowEpisodeThumbFilename = TvShowEpisodeThumbNaming.FILENAME_THUMB_POSTFIX;
    private boolean buildImageCacheOnImport = false;
    private boolean asciiReplacement = false;
    private boolean renamerSpaceSubstitution = false;
    private String renamerSpaceReplacement = "_";
    private LanguageStyle tvShowRenamerLanguageStyle = LanguageStyle.ISO3T;
    private boolean syncTrakt = false;
    private boolean dvdOrder = false;

    public void addTvShowDataSources(String path) {
        if (!this.tvShowDataSources.contains(path)) {
            this.tvShowDataSources.add(path);
            this.firePropertyChange(TV_SHOW_DATA_SOURCE, null, this.tvShowDataSources);
        }
    }

    public void removeTvShowDataSources(String path) {
        TvShowList tvShowList = TvShowList.getInstance();
        tvShowList.removeDatasource(path);
        this.tvShowDataSources.remove(path);
        this.firePropertyChange(TV_SHOW_DATA_SOURCE, null, this.tvShowDataSources);
    }

    public List<String> getTvShowDataSource() {
        return this.tvShowDataSources;
    }

    public String getTvShowScraper() {
        if (StringUtils.isBlank((CharSequence)this.tvShowScraper)) {
            return "tvdb";
        }
        return this.tvShowScraper;
    }

    public void setTvShowScraper(String newValue) {
        String oldValue = this.tvShowScraper;
        this.tvShowScraper = newValue;
        this.firePropertyChange(TV_SHOW_SCRAPER, oldValue, newValue);
    }

    public void addTvShowArtworkScraper(String newValue) {
        if (!this.tvShowArtworkScrapers.contains(newValue)) {
            this.tvShowArtworkScrapers.add(newValue);
            this.firePropertyChange(TV_SHOW_ARTWORK_SCRAPERS, null, this.tvShowArtworkScrapers);
        }
    }

    public void removeTvShowArtworkScraper(String newValue) {
        if (this.tvShowArtworkScrapers.contains(newValue)) {
            this.tvShowArtworkScrapers.remove(newValue);
            this.firePropertyChange(TV_SHOW_ARTWORK_SCRAPERS, null, this.tvShowArtworkScrapers);
        }
    }

    public List<String> getTvShowArtworkScrapers() {
        return this.tvShowArtworkScrapers;
    }

    public boolean isScrapeBestImage() {
        return this.scrapeBestImage;
    }

    public void setScrapeBestImage(boolean newValue) {
        boolean oldValue = this.scrapeBestImage;
        this.scrapeBestImage = newValue;
        this.firePropertyChange(SCRAPE_BEST_IMAGE, oldValue, newValue);
    }

    public MediaLanguages getScraperLanguage() {
        return this.scraperLanguage;
    }

    public void setScraperLanguage(MediaLanguages newValue) {
        MediaLanguages oldValue = this.scraperLanguage;
        this.scraperLanguage = newValue;
        this.firePropertyChange(SCRAPER_LANGU, oldValue, newValue);
    }

    public MediaLanguages getSubtitleScraperLanguage() {
        return this.subtitleScraperLanguage;
    }

    public void setSubtitleScraperLanguage(MediaLanguages newValue) {
        MediaLanguages oldValue = this.subtitleScraperLanguage;
        this.subtitleScraperLanguage = newValue;
        this.firePropertyChange(SUBTITLE_SCRAPER_LANGU, oldValue, newValue);
    }

    public CountryCode getCertificationCountry() {
        return this.certificationCountry;
    }

    public void setCertificationCountry(CountryCode newValue) {
        CountryCode oldValue = this.certificationCountry;
        this.certificationCountry = newValue;
        this.firePropertyChange(CERTIFICATION_COUNTRY, oldValue, newValue);
    }

    public String getRenamerSeasonFoldername() {
        return this.renamerSeasonFoldername;
    }

    public void setRenamerSeasonFoldername(String newValue) {
        String oldValue = this.renamerSeasonFoldername;
        this.renamerSeasonFoldername = newValue;
        this.firePropertyChange(RENAMER_SEASON_FOLDER, oldValue, newValue);
    }

    public String getRenamerTvShowFoldername() {
        return this.renamerTvShowFoldername;
    }

    public void setRenamerTvShowFoldername(String newValue) {
        String oldValue = this.renamerTvShowFoldername;
        this.renamerTvShowFoldername = newValue;
        this.firePropertyChange("renamerTvShowFoldername", oldValue, newValue);
    }

    public String getRenamerFilename() {
        return this.renamerFilename;
    }

    public void setRenamerFilename(String newValue) {
        String oldValue = this.renamerFilename;
        this.renamerFilename = newValue;
        this.firePropertyChange("renamerFilename", oldValue, newValue);
    }

    public boolean isBuildImageCacheOnImport() {
        return this.buildImageCacheOnImport;
    }

    public void setBuildImageCacheOnImport(boolean newValue) {
        boolean oldValue = this.buildImageCacheOnImport;
        this.buildImageCacheOnImport = newValue;
        this.firePropertyChange(BUILD_IMAGE_CACHE_ON_IMPORT, oldValue, newValue);
    }

    public boolean isAsciiReplacement() {
        return this.asciiReplacement;
    }

    public void setAsciiReplacement(boolean newValue) {
        boolean oldValue = this.asciiReplacement;
        this.asciiReplacement = newValue;
        this.firePropertyChange(ASCII_REPLACEMENT, oldValue, newValue);
    }

    public String getRenamerSpaceReplacement() {
        return this.renamerSpaceReplacement;
    }

    public void setRenamerSpaceReplacement(String newValue) {
        String oldValue = this.renamerSpaceReplacement;
        this.renamerSpaceReplacement = newValue;
        this.firePropertyChange("renamerReplacement", oldValue, newValue);
    }

    public boolean isRenamerSpaceSubstitution() {
        return this.renamerSpaceSubstitution;
    }

    public void setRenamerSpaceSubstitution(boolean newValue) {
        boolean oldValue = this.renamerSpaceSubstitution;
        this.renamerSpaceSubstitution = newValue;
        this.firePropertyChange("renamerSpaceSubstitution", oldValue, newValue);
    }

    public void setSyncTrakt(boolean newValue) {
        boolean oldValue = this.syncTrakt;
        this.syncTrakt = newValue;
        this.firePropertyChange("syncTrakt", oldValue, newValue);
    }

    public boolean getSyncTrakt() {
        return this.syncTrakt;
    }

    public boolean isDvdOrder() {
        return this.dvdOrder;
    }

    public void setDvdOrder(boolean newValue) {
        boolean oldValue = this.dvdOrder;
        this.dvdOrder = newValue;
        this.firePropertyChange("dvdOrder", oldValue, newValue);
    }

    public void addTvShowSkipFolder(String newValue) {
        if (!this.tvShowSkipFolders.contains(newValue)) {
            this.tvShowSkipFolders.add(newValue);
            this.firePropertyChange(TV_SHOW_SKIP_FOLDERS, null, this.tvShowSkipFolders);
        }
    }

    public void removeTvShowSkipFolder(String newValue) {
        if (this.tvShowSkipFolders.contains(newValue)) {
            this.tvShowSkipFolders.remove(newValue);
            this.firePropertyChange(TV_SHOW_SKIP_FOLDERS, null, this.tvShowSkipFolders);
        }
    }

    public List<String> getTvShowSkipFolders() {
        return this.tvShowSkipFolders;
    }

    public void addBadWord(String badWord) {
        if (!this.badWords.contains(badWord.toLowerCase(Locale.ROOT))) {
            this.badWords.add(badWord.toLowerCase(Locale.ROOT));
            this.firePropertyChange(BAD_WORDS, null, this.badWords);
        }
    }

    public void removeBadWord(String badWord) {
        this.badWords.remove(badWord.toLowerCase(Locale.ROOT));
        this.firePropertyChange(BAD_WORDS, null, this.badWords);
    }

    public List<String> getBadWords() {
        ListIterator<String> iterator = this.badWords.listIterator();
        while (iterator.hasNext()) {
            iterator.set(iterator.next().toLowerCase(Locale.ROOT));
        }
        return this.badWords;
    }

    public TvShowEpisodeThumbNaming getTvShowEpisodeThumbFilename() {
        return this.tvShowEpisodeThumbFilename;
    }

    public void setTvShowEpisodeThumbFilename(TvShowEpisodeThumbNaming newValue) {
        TvShowEpisodeThumbNaming oldValue = this.tvShowEpisodeThumbFilename;
        this.tvShowEpisodeThumbFilename = newValue;
        this.firePropertyChange("tvShowEpisodeThumbFilename", (Object)oldValue, (Object)newValue);
    }

    public void addTvShowSubtitleScraper(String newValue) {
        if (!this.tvShowSubtitleScrapers.contains(newValue)) {
            this.tvShowSubtitleScrapers.add(newValue);
            this.firePropertyChange(TV_SHOW_SUBTITLE_SCRAPERS, null, this.tvShowSubtitleScrapers);
        }
    }

    public void removeTvShowSubtitleScraper(String newValue) {
        if (this.tvShowSubtitleScrapers.contains(newValue)) {
            this.tvShowSubtitleScrapers.remove(newValue);
            this.firePropertyChange(TV_SHOW_SUBTITLE_SCRAPERS, null, this.tvShowSubtitleScrapers);
        }
    }

    public List<String> getTvShowSubtitleScrapers() {
        return this.tvShowSubtitleScrapers;
    }

    public LanguageStyle getTvShowRenamerLanguageStyle() {
        return this.tvShowRenamerLanguageStyle;
    }

    public void setTvShowRenamerLanguageStyle(LanguageStyle newValue) {
        LanguageStyle oldValue = this.tvShowRenamerLanguageStyle;
        this.tvShowRenamerLanguageStyle = newValue;
        this.firePropertyChange("tvShowRenamerLanguageStyle", (Object)oldValue, (Object)newValue);
    }
}

