/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaEntityImageFetcherTask;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.http.Url;

public class TvShowArtworkHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowArtworkHelper.class);

    public static void downloadArtwork(TvShow show, MediaFileType type) {
        String url = "";
        String filename = "";
        switch (type) {
            case FANART: 
            case POSTER: 
            case BANNER: 
            case EXTRAFANART: 
            case EXTRATHUMB: 
            case LOGO: 
            case CLEARLOGO: 
            case CLEARART: 
            case THUMB: {
                url = show.getArtworkUrl(type);
                filename = type.name().toLowerCase(Locale.ROOT) + "." + FilenameUtils.getExtension((String)url);
                break;
            }
        }
        if (StringUtils.isBlank((CharSequence)url) || StringUtils.isBlank((CharSequence)filename)) {
            return;
        }
        MediaEntityImageFetcherTask task = new MediaEntityImageFetcherTask(show, url, MediaFileType.getMediaArtworkType(type), filename, true);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public static void downloadMissingArtwork(TvShow show) {
        MediaFileType[] mfts;
        String url = "";
        String filename = "";
        for (MediaFileType mft : mfts = MediaFileType.getGraphicMediaFileTypes()) {
            List<MediaFile> mfs = show.getMediaFiles(mft);
            if (!mfs.isEmpty()) continue;
            switch (mft) {
                case FANART: 
                case POSTER: 
                case BANNER: 
                case EXTRAFANART: 
                case EXTRATHUMB: 
                case LOGO: 
                case CLEARLOGO: 
                case CLEARART: 
                case THUMB: 
                case DISCART: {
                    url = show.getArtworkUrl(mft);
                    filename = mft.name().toLowerCase(Locale.ROOT) + "." + FilenameUtils.getExtension((String)url);
                    break;
                }
            }
            if (StringUtils.isBlank((CharSequence)url) || StringUtils.isBlank((CharSequence)filename)) continue;
            MediaEntityImageFetcherTask task = new MediaEntityImageFetcherTask(show, url, MediaFileType.getMediaArtworkType(mft), filename, true);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
    }

    public static void downloadMissingArtwork(TvShow tvShow, List<MediaArtwork> artwork) {
        Collections.sort(artwork, new MediaArtwork.MediaArtworkComparator(TvShowModuleManager.SETTINGS.getScraperLanguage().name()));
        if (tvShow.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.POSTER);
        }
        if (tvShow.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.BACKGROUND);
        }
        if (tvShow.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.LOGO);
        }
        if (tvShow.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO);
        }
        if (tvShow.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.CLEARART);
        }
        if (tvShow.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.BANNER);
        }
        if (tvShow.getMediaFiles(MediaFileType.THUMB).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.THUMB);
        }
        if (tvShow.getMediaFiles(MediaFileType.DISCART).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.DISC);
        }
        for (TvShowSeason season : tvShow.getSeasons()) {
            if (!StringUtils.isBlank((CharSequence)season.getPoster())) continue;
            for (MediaArtwork art : artwork) {
                if (art.getSeason() != season.getSeason()) continue;
                tvShow.setSeasonPosterUrl(art.getSeason(), art.getDefaultUrl());
                TvShowArtworkHelper.downloadSeasonPoster(tvShow, art.getSeason());
            }
        }
        tvShow.saveToDb();
    }

    private static void setBestArtwork(TvShow tvShow, List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type) {
        for (MediaArtwork art : artwork) {
            if (art.getType() != type || !StringUtils.isNotBlank((CharSequence)art.getDefaultUrl())) continue;
            tvShow.setArtworkUrl(art.getDefaultUrl(), MediaFileType.getMediaFileType(type));
            TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.getMediaFileType(type));
            break;
        }
    }

    public static boolean hasMissingArtwork(TvShow tvShow) {
        if (tvShow.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            return true;
        }
        if (tvShow.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            return true;
        }
        if (tvShow.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            return true;
        }
        if (tvShow.getMediaFiles(MediaFileType.DISCART).isEmpty()) {
            return true;
        }
        if (tvShow.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            return true;
        }
        if (tvShow.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            return true;
        }
        if (tvShow.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            return true;
        }
        if (tvShow.getMediaFiles(MediaFileType.THUMB).isEmpty()) {
            return true;
        }
        for (TvShowSeason season : tvShow.getSeasons()) {
            if (!StringUtils.isBlank((CharSequence)season.getPoster())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMissingArtwork(TvShowEpisode episode) {
        return episode.getMediaFiles(MediaFileType.THUMB).isEmpty();
    }

    public static void downloadSeasonPoster(TvShow show, int season) {
        String seasonPosterUrl = show.getSeasonPosterUrl(season);
        TvShowSeason tvShowSeason = null;
        for (TvShowSeason s : show.getSeasons()) {
            if (s.getSeason() != season) continue;
            tvShowSeason = s;
            break;
        }
        String filename = "";
        filename = season > 0 ? String.format(show.getPath() + File.separator + "season%02d-poster." + FilenameUtils.getExtension((String)seasonPosterUrl), season) : show.getPath() + File.separator + "season-specials-poster." + FilenameUtils.getExtension((String)seasonPosterUrl);
        SeasonPosterImageFetcher task = new SeasonPosterImageFetcher(show, filename, tvShowSeason, seasonPosterUrl);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    private static class SeasonPosterImageFetcher
    implements Runnable {
        private TvShow tvShow;
        private String filename;
        private TvShowSeason tvShowSeason;
        private String url;

        SeasonPosterImageFetcher(TvShow show, String filename, TvShowSeason tvShowSeason, String url) {
            this.tvShow = show;
            this.filename = filename;
            this.tvShowSeason = tvShowSeason;
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String oldFilename = "";
            try {
                if (this.tvShowSeason != null) {
                    oldFilename = this.tvShowSeason.getPoster();
                    this.tvShowSeason.clearPoster();
                }
                LOGGER.debug("writing season poster " + this.filename);
                Url url1 = new Url(this.url);
                FileOutputStream outputStream = new FileOutputStream(this.filename);
                InputStream is = url1.getInputStream();
                IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                outputStream.close();
                outputStream.flush();
                try {
                    outputStream.getFD().sync();
                }
                catch (Exception e) {
                    // empty catch block
                }
                is.close();
                ImageCache.invalidateCachedImage(Paths.get(this.filename, new String[0]));
                if (this.tvShowSeason != null) {
                    this.tvShowSeason.setPoster(new File(this.filename));
                }
            }
            catch (IOException e) {
                LOGGER.debug("fetch image", (Throwable)e);
                if (this.tvShowSeason != null && !oldFilename.isEmpty()) {
                    this.tvShowSeason.setPoster(new File(oldFilename));
                }
            }
            catch (Exception e) {
                LOGGER.error("Thread crashed", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this, "message.scrape.tvshowartworkfailed"));
            }
            finally {
                this.tvShow.saveToDb();
            }
        }
    }
}

