/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import java.nio.file.Path;
import org.tinymediamanager.core.movie.connector.MovieToKodiNfoConnector;
import org.tinymediamanager.core.movie.connector.MovieToMpNfoConnector;

public enum MovieConnectors {
    KODI("Kodi"),
    XBMC("Kodi / XBMC < v16"),
    MP("MediaPortal");

    private String title;

    private MovieConnectors(String title) {
        this.title = title;
    }

    public String toString() {
        return this.title;
    }

    public static boolean isValidNFO(Path nfo) {
        MovieToKodiNfoConnector kodi = null;
        try {
            kodi = MovieToKodiNfoConnector.parseNFO(nfo);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (kodi != null) {
            return true;
        }
        MovieToMpNfoConnector mp = null;
        try {
            mp = MovieToMpNfoConnector.parseNFO(nfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mp != null;
    }
}

