/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;

public class MovieRenamerPreviewContainer {
    Movie movie;
    Path oldPath;
    Path newPath;
    List<MediaFile> newMediaFiles = new ArrayList<MediaFile>();
    boolean needsRename = false;

    public MovieRenamerPreviewContainer(Movie movie) {
        this.movie = movie;
        if (movie != null && !movie.getDataSource().isEmpty()) {
            this.oldPath = Paths.get(movie.getDataSource(), new String[0]).relativize(movie.getPathNIO());
        }
    }

    public Movie getMovie() {
        return this.movie;
    }

    public Path getOldPath() {
        return this.oldPath;
    }

    public Path getNewPath() {
        return this.newPath;
    }

    public List<MediaFile> getOldMediaFiles() {
        return this.movie.getMediaFiles();
    }

    public List<MediaFile> getNewMediaFiles() {
        return this.newMediaFiles;
    }

    public boolean isNeedsRename() {
        return this.needsRename;
    }
}

