/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt5;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.entities.AccessToken;
import java.io.IOException;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Route;
import retrofit2.Response;

public class TraktV2Authenticator
implements Authenticator {
    public final TraktV2 trakt;

    public TraktV2Authenticator(TraktV2 trakt) {
        this.trakt = trakt;
    }

    public Request authenticate(Route route, okhttp3.Response response) throws IOException {
        return TraktV2Authenticator.handleAuthenticate(response, this.trakt);
    }

    public static Request handleAuthenticate(okhttp3.Response response, TraktV2 trakt) throws IOException {
        if (!"api.trakt.tv".equals(response.request().url().host())) {
            return null;
        }
        if (TraktV2Authenticator.responseCount(response) >= 2) {
            return null;
        }
        if (trakt.refreshToken() == null || trakt.refreshToken().length() == 0) {
            return null;
        }
        Response<AccessToken> refreshResponse = trakt.refreshAccessToken();
        if (!refreshResponse.isSuccessful()) {
            return null;
        }
        String accessToken = ((AccessToken)refreshResponse.body()).access_token;
        trakt.accessToken(accessToken);
        trakt.refreshToken(((AccessToken)refreshResponse.body()).refresh_token);
        return response.request().newBuilder().header("Authorization", "Bearer " + accessToken).build();
    }

    private static int responseCount(okhttp3.Response response) {
        int result = 1;
        while ((response = response.priorResponse()) != null) {
            ++result;
        }
        return result;
    }
}

