/*
 * Decompiled with CFR 0.152.
 */
package de.timroes.axmlrpc;

import de.timroes.axmlrpc.XMLRPCException;
import de.timroes.axmlrpc.serializer.SerializerHandler;
import de.timroes.axmlrpc.xmlcreator.SimpleXMLCreator;
import de.timroes.axmlrpc.xmlcreator.XmlElement;

public class Call {
    private String method;
    private Object[] params;

    public Call(String method) {
        this(method, null);
    }

    public Call(String method, Object[] params) {
        this.method = method;
        this.params = params;
    }

    public String getXML() throws XMLRPCException {
        SimpleXMLCreator creator = new SimpleXMLCreator();
        XmlElement methodCall = new XmlElement("methodCall");
        creator.setRootElement(methodCall);
        XmlElement methodName = new XmlElement("methodName");
        methodName.setContent(this.method);
        methodCall.addChildren(methodName);
        if (this.params != null && this.params.length > 0) {
            XmlElement params = new XmlElement("params");
            methodCall.addChildren(params);
            for (Object o : this.params) {
                params.addChildren(this.getXMLParam(o));
            }
        }
        return creator.toString();
    }

    private XmlElement getXMLParam(Object o) throws XMLRPCException {
        XmlElement param = new XmlElement("param");
        XmlElement value = new XmlElement("value");
        param.addChildren(value);
        value.addChildren(SerializerHandler.getDefault().serialize(o));
        return param;
    }
}

