/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.luna;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseComboBoxUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.NoFocusButton;
import com.jtattoo.plaf.luna.LunaIcons;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class LunaComboBoxUI
extends BaseComboBoxUI {
    public static ComponentUI createUI(JComponent c) {
        return new LunaComboBoxUI();
    }

    public JButton createArrowButton() {
        return new ArrowButton();
    }

    protected void setButtonBorder() {
    }

    static class ArrowButton
    extends NoFocusButton {
        public ArrowButton() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
        }

        public void paint(Graphics g) {
            int dx;
            Graphics2D g2D = (Graphics2D)g;
            boolean isPressed = this.getModel().isPressed();
            boolean isRollover = this.getModel().isRollover();
            int width = this.getWidth();
            int height = this.getHeight();
            Color[] tc = AbstractLookAndFeel.getTheme().getThumbColors();
            Color c1 = tc[0];
            Color c2 = tc[tc.length - 1];
            if (isPressed) {
                c1 = ColorHelper.darker(c1, 5.0);
                c2 = ColorHelper.darker(c2, 5.0);
            } else if (isRollover) {
                c1 = ColorHelper.brighter(c1, 20.0);
                c2 = ColorHelper.brighter(c2, 20.0);
            }
            g2D.setPaint(new GradientPaint(0.0f, 0.0f, c1, width, height, c2));
            g.fillRect(0, 0, width, height);
            g2D.setPaint(null);
            g2D.setColor(Color.white);
            if (JTattooUtilities.isLeftToRight(this)) {
                g2D.drawRect(1, 0, width - 2, height - 1);
            } else {
                g2D.drawRect(0, 0, width - 2, height - 1);
            }
            Composite composite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
            g2D.setComposite(alpha);
            g2D.setColor(c2);
            if (JTattooUtilities.isLeftToRight(this)) {
                g.drawLine(2, 1, width - 2, 1);
                g.drawLine(2, 2, 2, height - 2);
            } else {
                g.drawLine(1, 1, width - 3, 1);
                g.drawLine(1, 2, 1, height - 2);
            }
            g2D.setComposite(composite);
            Icon icon = LunaIcons.getComboBoxIcon();
            int x = (width - icon.getIconWidth()) / 2;
            int y = (height - icon.getIconHeight()) / 2;
            int n = dx = JTattooUtilities.isLeftToRight(this) ? 0 : -1;
            if (this.getModel().isPressed() && this.getModel().isArmed()) {
                icon.paintIcon(this, g, x + dx + 2, y + 1);
            } else {
                icon.paintIcon(this, g, x + dx + 1, y);
            }
        }
    }
}

