/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import java.util.concurrent.Executor;
import retrofit.Callback;
import retrofit.ErrorHandler;
import retrofit.ResponseWrapper;
import retrofit.RetrofitError;

abstract class CallbackRunnable<T>
implements Runnable {
    private final Callback<T> callback;
    private final Executor callbackExecutor;
    private final ErrorHandler errorHandler;

    CallbackRunnable(Callback<T> callback, Executor callbackExecutor, ErrorHandler errorHandler) {
        this.callback = callback;
        this.callbackExecutor = callbackExecutor;
        this.errorHandler = errorHandler;
    }

    @Override
    public final void run() {
        try {
            final ResponseWrapper wrapper = this.obtainResponse();
            this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    CallbackRunnable.this.callback.success(wrapper.responseBody, wrapper.response);
                }
            });
        }
        catch (RetrofitError e) {
            Throwable cause = this.errorHandler.handleError(e);
            final RetrofitError handled = cause == e ? e : RetrofitError.unexpectedError(e.getUrl(), cause);
            this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    CallbackRunnable.this.callback.failure(handled);
                }
            });
        }
    }

    public abstract ResponseWrapper obtainResponse();
}

