/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.border.TitledBorder;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.trakttv.SyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.AutocompleteComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class TvShowBatchEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = 3527478264068979388L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TvShowList tvShowList = TvShowList.getInstance();
    private List<TvShow> tvShowsToEdit;
    private List<TvShowEpisode> tvShowEpisodesToEdit;
    private boolean episodesChanged = false;
    private boolean tvShowsChanged = false;
    private JComboBox<MediaGenres> cbGenres;
    private JComboBox<String> cbTags;
    private JComboBox<String> cbTagsEpisode;
    private JCheckBox chckbxWatched;
    private JSpinner spSeason;

    public TvShowBatchEditorDialog(List<TvShow> tvShows, List<TvShowEpisode> episodes) {
        super(BUNDLE.getString("tvshow.bulkedit"), "movieBatchEditor");
        this.setBounds(5, 5, 687, 554);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.tvShowsToEdit = tvShows;
        this.tvShowEpisodesToEdit = episodes;
        JPanel panelTvShows = new JPanel();
        panelTvShows.setBorder(new TitledBorder(null, BUNDLE.getString("metatag.tvshow"), 4, 2, null, null));
        this.getContentPane().add((Component)panelTvShows, "North");
        panelTvShows.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblGenres = new JLabel(BUNDLE.getString("metatag.genre"));
        panelTvShows.add((Component)lblGenres, "2, 2, right, default");
        this.cbGenres = new AutocompleteComboBox<MediaGenres>(MediaGenres.values());
        panelTvShows.add(this.cbGenres, "4, 2");
        this.cbGenres.setEditable(true);
        JButton btnAddGenre = new JButton("");
        panelTvShows.add((Component)btnAddGenre, "6, 2");
        btnAddGenre.setIcon(IconManager.LIST_ADD);
        btnAddGenre.setMargin(new Insets(2, 2, 2, 2));
        JButton btnRemoveGenre = new JButton("");
        panelTvShows.add((Component)btnRemoveGenre, "8, 2");
        btnRemoveGenre.setIcon(IconManager.LIST_REMOVE);
        btnRemoveGenre.setMargin(new Insets(2, 2, 2, 2));
        JLabel lblTags = new JLabel("Tag");
        panelTvShows.add((Component)lblTags, "2, 4, right, default");
        this.cbTags = new AutocompleteComboBox<String>(this.tvShowList.getTagsInTvShows());
        panelTvShows.add(this.cbTags, "4, 4");
        this.cbTags.setEditable(true);
        JButton btnAddTag = new JButton("");
        panelTvShows.add((Component)btnAddTag, "6, 4");
        btnAddTag.setIcon(IconManager.LIST_ADD);
        btnAddTag.setMargin(new Insets(2, 2, 2, 2));
        JButton btnRemoveTag = new JButton("");
        panelTvShows.add((Component)btnRemoveTag, "8, 4");
        btnRemoveTag.setIcon(IconManager.LIST_REMOVE);
        btnRemoveTag.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveTag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvShowBatchEditorDialog.this.tvShowsChanged = true;
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                String tag = (String)TvShowBatchEditorDialog.this.cbTags.getSelectedItem();
                for (TvShow tvShow : TvShowBatchEditorDialog.this.tvShowsToEdit) {
                    tvShow.removeFromTags(tag);
                }
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        btnAddTag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvShowBatchEditorDialog.this.tvShowsChanged = true;
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                String tag = (String)TvShowBatchEditorDialog.this.cbTags.getSelectedItem();
                for (TvShow tvShow : TvShowBatchEditorDialog.this.tvShowsToEdit) {
                    tvShow.addToTags(tag);
                }
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        btnRemoveGenre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvShowBatchEditorDialog.this.tvShowsChanged = true;
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                MediaGenres genre = (MediaGenres)TvShowBatchEditorDialog.this.cbGenres.getSelectedItem();
                for (TvShow tvShow : TvShowBatchEditorDialog.this.tvShowsToEdit) {
                    tvShow.removeGenre(genre);
                }
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        btnAddGenre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvShowBatchEditorDialog.this.tvShowsChanged = true;
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                MediaGenres genre = null;
                Object item = TvShowBatchEditorDialog.this.cbGenres.getSelectedItem();
                if (item instanceof MediaGenres) {
                    genre = (MediaGenres)item;
                }
                if (item instanceof String) {
                    genre = MediaGenres.getGenre((String)((String)item));
                }
                if (genre != null) {
                    for (TvShow tvShow : TvShowBatchEditorDialog.this.tvShowsToEdit) {
                        tvShow.addGenre(genre);
                    }
                }
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        JPanel panelTvShowEpisodes = new JPanel();
        panelTvShowEpisodes.setBorder(new TitledBorder(null, BUNDLE.getString("metatag.episode"), 4, 2, null, null));
        this.getContentPane().add((Component)panelTvShowEpisodes, "Center");
        panelTvShowEpisodes.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        JLabel lblWatched = new JLabel(BUNDLE.getString("metatag.watched"));
        panelTvShowEpisodes.add((Component)lblWatched, "2, 2, right, default");
        this.chckbxWatched = new JCheckBox("");
        panelTvShowEpisodes.add((Component)this.chckbxWatched, "4, 2");
        JButton btnWatched = new JButton("");
        btnWatched.setMargin(new Insets(2, 2, 2, 2));
        btnWatched.setIcon(IconManager.APPLY);
        btnWatched.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvShowBatchEditorDialog.this.episodesChanged = true;
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                for (TvShowEpisode episode : TvShowBatchEditorDialog.this.tvShowEpisodesToEdit) {
                    episode.setWatched(TvShowBatchEditorDialog.this.chckbxWatched.isSelected());
                }
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelTvShowEpisodes.add((Component)btnWatched, "6, 2");
        JLabel lblSeason = new JLabel(BUNDLE.getString("metatag.season"));
        panelTvShowEpisodes.add((Component)lblSeason, "2, 4, right, default");
        this.spSeason = new JSpinner();
        this.spSeason.setPreferredSize(new Dimension(40, 20));
        this.spSeason.setMinimumSize(new Dimension(40, 20));
        panelTvShowEpisodes.add((Component)this.spSeason, "4, 4, left, default");
        JButton btnSeason = new JButton("");
        btnSeason.setIcon(IconManager.APPLY);
        btnSeason.setMargin(new Insets(2, 2, 2, 2));
        btnSeason.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TvShowBatchEditorDialog.this.episodesChanged = true;
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                for (TvShowEpisode episode : TvShowBatchEditorDialog.this.tvShowEpisodesToEdit) {
                    Integer season = (Integer)TvShowBatchEditorDialog.this.spSeason.getValue();
                    episode.setSeason(season);
                }
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelTvShowEpisodes.add((Component)btnSeason, "6, 4");
        JLabel lblDvdOrder = new JLabel(BUNDLE.getString("metatag.dvdorder"));
        panelTvShowEpisodes.add((Component)lblDvdOrder, "2, 6, right, default");
        final JCheckBox cbDvdOrder = new JCheckBox("");
        panelTvShowEpisodes.add((Component)cbDvdOrder, "4, 6");
        JButton btnDvdOrder = new JButton("");
        btnDvdOrder.setIcon(IconManager.APPLY);
        btnDvdOrder.setMargin(new Insets(2, 2, 2, 2));
        btnDvdOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TvShowBatchEditorDialog.this.episodesChanged = true;
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                for (TvShowEpisode episode : TvShowBatchEditorDialog.this.tvShowEpisodesToEdit) {
                    episode.setDvdOrder(cbDvdOrder.isSelected());
                }
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelTvShowEpisodes.add((Component)btnDvdOrder, "6, 6");
        JLabel lblTagsEpisode = new JLabel("Tag");
        panelTvShowEpisodes.add((Component)lblTagsEpisode, "2, 8, right, default");
        this.cbTagsEpisode = new AutocompleteComboBox<String>(this.tvShowList.getTagsInEpisodes());
        panelTvShowEpisodes.add(this.cbTagsEpisode, "4, 8");
        this.cbTagsEpisode.setEditable(true);
        JButton btnAddTagEpisode = new JButton("");
        panelTvShowEpisodes.add((Component)btnAddTagEpisode, "6, 8");
        btnAddTagEpisode.setIcon(IconManager.LIST_ADD);
        btnAddTagEpisode.setMargin(new Insets(2, 2, 2, 2));
        JButton btnRemoveTagEpisode = new JButton("");
        panelTvShowEpisodes.add((Component)btnRemoveTagEpisode, "8, 8");
        btnRemoveTagEpisode.setIcon(IconManager.LIST_REMOVE);
        btnRemoveTagEpisode.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveTagEpisode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvShowBatchEditorDialog.this.episodesChanged = true;
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                String tag = (String)TvShowBatchEditorDialog.this.cbTagsEpisode.getSelectedItem();
                for (TvShowEpisode episode : TvShowBatchEditorDialog.this.tvShowEpisodesToEdit) {
                    episode.removeFromTags(tag);
                }
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        btnAddTagEpisode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvShowBatchEditorDialog.this.episodesChanged = true;
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                String tag = (String)TvShowBatchEditorDialog.this.cbTagsEpisode.getSelectedItem();
                for (TvShowEpisode episode : TvShowBatchEditorDialog.this.tvShowEpisodesToEdit) {
                    episode.addToTags(tag);
                }
                TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        JLabel lblMediasourceEpisode = new JLabel(BUNDLE.getString("metatag.source"));
        panelTvShowEpisodes.add((Component)lblMediasourceEpisode, "2, 10, right, default");
        final JComboBox<MediaSource> cbMediaSourceEpisode = new JComboBox<MediaSource>(MediaSource.values());
        panelTvShowEpisodes.add(cbMediaSourceEpisode, "4, 10, fill, default");
        JButton btnMediaSourceEpisode = new JButton("");
        btnMediaSourceEpisode.setMargin(new Insets(2, 2, 2, 2));
        btnMediaSourceEpisode.setIcon(IconManager.APPLY);
        btnMediaSourceEpisode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvShowBatchEditorDialog.this.episodesChanged = true;
                Object obj = cbMediaSourceEpisode.getSelectedItem();
                if (obj instanceof MediaSource) {
                    MediaSource mediaSource = (MediaSource)((Object)obj);
                    TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    for (TvShowEpisode episode : TvShowBatchEditorDialog.this.tvShowEpisodesToEdit) {
                        episode.setMediaSource(mediaSource);
                    }
                    TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        panelTvShowEpisodes.add((Component)btnMediaSourceEpisode, "6, 10");
        JPanel panelButtons = new JPanel();
        FlowLayout flowLayout = (FlowLayout)panelButtons.getLayout();
        flowLayout.setAlignment(2);
        this.getContentPane().add((Component)panelButtons, "South");
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        btnClose.setIcon(IconManager.APPLY);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (TvShowBatchEditorDialog.this.tvShowsChanged) {
                    TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    for (TvShow tvShow : TvShowBatchEditorDialog.this.tvShowsToEdit) {
                        tvShow.writeNFO();
                        tvShow.saveToDb();
                    }
                    TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (TvShowBatchEditorDialog.this.episodesChanged) {
                    TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    for (TvShowEpisode episode : TvShowBatchEditorDialog.this.tvShowEpisodesToEdit) {
                        episode.writeNFO();
                        episode.saveToDb();
                    }
                    TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (TvShowModuleManager.SETTINGS.getSyncTrakt()) {
                    HashSet<TvShow> tvShows = new HashSet<TvShow>();
                    for (TvShowEpisode episode : TvShowBatchEditorDialog.this.tvShowEpisodesToEdit) {
                        tvShows.add(episode.getTvShow());
                    }
                    tvShows.addAll(TvShowBatchEditorDialog.this.tvShowsToEdit);
                    SyncTraktTvTask task = new SyncTraktTvTask(null, new ArrayList<TvShow>(tvShows));
                    TmmTaskManager.getInstance().addUnnamedTask(task);
                }
                TvShowBatchEditorDialog.this.setVisible(false);
            }
        });
        panelButtons.add(btnClose);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (TvShowBatchEditorDialog.this.tvShowsChanged) {
                    TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    for (TvShow tvShow : TvShowBatchEditorDialog.this.tvShowsToEdit) {
                        tvShow.writeNFO();
                        tvShow.saveToDb();
                    }
                    TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (TvShowBatchEditorDialog.this.episodesChanged) {
                    TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    for (TvShowEpisode episode : TvShowBatchEditorDialog.this.tvShowEpisodesToEdit) {
                        episode.writeNFO();
                        episode.saveToDb();
                    }
                    TvShowBatchEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }
}

