/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.util.Collections;
import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeTreeNode;

public class TvShowSeasonTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -5734830011018805194L;
    private Comparator<TreeNode> nodeComparator = new Comparator<TreeNode>(){

        @Override
        public int compare(TreeNode o1, TreeNode o2) {
            if (o1 instanceof TvShowEpisodeTreeNode && o2 instanceof TvShowEpisodeTreeNode) {
                TvShowEpisodeTreeNode node1 = (TvShowEpisodeTreeNode)o1;
                TvShowEpisode tvShowEpisode1 = (TvShowEpisode)node1.getUserObject();
                TvShowEpisodeTreeNode node2 = (TvShowEpisodeTreeNode)o2;
                TvShowEpisode tvShowEpisode2 = (TvShowEpisode)node2.getUserObject();
                return tvShowEpisode1.getEpisode() - tvShowEpisode2.getEpisode();
            }
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    };

    public TvShowSeasonTreeNode(Object userObject) {
        super(userObject);
    }

    @Override
    public String toString() {
        if (this.getUserObject() instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)this.getUserObject();
            if (season.getSeason() == -1) {
                return "Uncategorized";
            }
            return "Season " + season.getSeason();
        }
        return super.toString();
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        if (this.children != null) {
            int index = Collections.binarySearch(this.children, newChild, this.nodeComparator);
            if (index < 0) {
                super.insert(newChild, -index - 1);
            } else if (index >= 0) {
                super.insert(newChild, index);
            }
        } else {
            super.insert(newChild, childIndex);
        }
    }
}

