/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;

public class JHintLabel
extends JLabel {
    private static final long serialVersionUID = 3027595143561381907L;
    private Icon hintIcon = null;
    private MouseAdapter tooltipAdatapter = new MouseAdapter(){
        final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
        final int dismissDelayMinutes = (int)TimeUnit.MINUTES.toMillis(10L);

        @Override
        public void mouseEntered(MouseEvent me) {
            ToolTipManager.sharedInstance().setDismissDelay(this.dismissDelayMinutes);
        }

        @Override
        public void mouseExited(MouseEvent me) {
            ToolTipManager.sharedInstance().setDismissDelay(this.defaultDismissTimeout);
        }
    };

    public JHintLabel() {
    }

    public JHintLabel(String text) {
        super(text);
    }

    public void setHintIcon(Icon icon) {
        this.hintIcon = icon;
        if (icon != null) {
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, icon.getIconWidth() + 6));
        }
    }

    public Icon getHintIcon() {
        return this.hintIcon;
    }

    @Override
    public void setToolTipText(String text) {
        this.removeMouseListener(this.tooltipAdatapter);
        this.addMouseListener(this.tooltipAdatapter);
        super.setToolTipText(text);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.hintIcon != null) {
            int iconWidth = this.hintIcon.getIconWidth();
            int x = this.getWidth() - iconWidth - 2;
            int y = 0;
            this.hintIcon.paintIcon(this, g, x, y);
        }
    }
}

