/*
 * Decompiled with CFR 0.152.
 */
package org.seamless.swing.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogCategory {
    private String name;
    private List<Group> groups = new ArrayList<Group>();

    public LogCategory(String name) {
        this.name = name;
    }

    public LogCategory(String name, Group[] groups) {
        this.name = name;
        this.groups = Arrays.asList(groups);
    }

    public String getName() {
        return this.name;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public void addGroup(String name, LoggerLevel[] loggerLevels) {
        this.groups.add(new Group(name, loggerLevels));
    }

    public static class LoggerLevel {
        private String logger;
        private Level level;

        public LoggerLevel(String logger, Level level) {
            this.logger = logger;
            this.level = level;
        }

        public String getLogger() {
            return this.logger;
        }

        public Level getLevel() {
            return this.level;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Group {
        private String name;
        private List<LoggerLevel> loggerLevels = new ArrayList<LoggerLevel>();
        private List<LoggerLevel> previousLevels = new ArrayList<LoggerLevel>();
        private boolean enabled;

        public Group(String name) {
            this.name = name;
        }

        public Group(String name, LoggerLevel[] loggerLevels) {
            this.name = name;
            this.loggerLevels = Arrays.asList(loggerLevels);
        }

        public String getName() {
            return this.name;
        }

        public List<LoggerLevel> getLoggerLevels() {
            return this.loggerLevels;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public List<LoggerLevel> getPreviousLevels() {
            return this.previousLevels;
        }

        public void setPreviousLevels(List<LoggerLevel> previousLevels) {
            this.previousLevels = previousLevels;
        }
    }
}

