/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;

public class MediaFileEditorPanel
extends JPanel {
    private static final long serialVersionUID = -2416409052145301941L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<MediaFileContainer> mediaFiles = ObservableCollections.observableList(new ArrayList());
    private JTable tableMediaFiles;
    private JLabel lblFilename;
    private JTextField tfCodec;
    private JTextField tfContainerFormat;
    private JTextField tfWidth;
    private JTextField tfHeight;
    private JTable tableAudioStreams;
    private JTable tableSubtitles;
    private JButton btnAddAudioStream;
    private JButton btnRemoveAudioStream;
    private JButton btnAddSubtitle;
    private JButton btnRemoveSubtitle;
    private JComboBox<String> cb3dFormat;
    private JTableBinding<MediaFileSubtitle, JTable, JTable> jTableBinding_2;
    private JTableBinding<MediaFileAudioStream, JTable, JTable> jTableBinding_1;
    private JTableBinding<MediaFileContainer, List<MediaFileContainer>, JTable> jTableBinding;

    public MediaFileEditorPanel(List<MediaFile> mediaFiles) {
        for (MediaFile mediaFile : mediaFiles) {
            MediaFileContainer container = new MediaFileContainer(mediaFile);
            this.mediaFiles.add(container);
        }
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC}));
        JSplitPane splitPane = new JSplitPane();
        this.add((Component)splitPane, "2, 2, fill, fill");
        JPanel panelMediaFiles = new JPanel();
        panelMediaFiles.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"175dlu:grow")}, new RowSpec[]{FormSpecs.LINE_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JScrollPane scrollPaneMediaFiles = new JScrollPane();
        panelMediaFiles.add((Component)scrollPaneMediaFiles, "1, 2, fill, fill");
        splitPane.setLeftComponent(panelMediaFiles);
        this.tableMediaFiles = new JTable();
        scrollPaneMediaFiles.setViewportView(this.tableMediaFiles);
        JPanel panelDetails = new JPanel();
        splitPane.setRightComponent(panelDetails);
        panelDetails.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, ColumnSpec.decode((String)"15dlu"), FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"15dlu"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC}));
        this.lblFilename = new JLabel("");
        panelDetails.add((Component)this.lblFilename, "2, 2, 7, 1");
        JLabel lblCodec = new JLabel("Codec");
        panelDetails.add((Component)lblCodec, "2, 4, right, default");
        this.tfCodec = new JTextField();
        panelDetails.add((Component)this.tfCodec, "4, 4, fill, default");
        this.tfCodec.setColumns(10);
        JLabel lblContainerFormat = new JLabel("Container format");
        panelDetails.add((Component)lblContainerFormat, "6, 4, right, default");
        this.tfContainerFormat = new JTextField();
        panelDetails.add((Component)this.tfContainerFormat, "8, 4, fill, default");
        this.tfContainerFormat.setColumns(10);
        JLabel lblWidth = new JLabel("Width");
        panelDetails.add((Component)lblWidth, "2, 6, right, default");
        this.tfWidth = new JTextField();
        panelDetails.add((Component)this.tfWidth, "4, 6, fill, default");
        this.tfWidth.setColumns(10);
        JLabel lblHeight = new JLabel("Height");
        panelDetails.add((Component)lblHeight, "6, 6, right, default");
        this.tfHeight = new JTextField();
        panelDetails.add((Component)this.tfHeight, "8, 6, fill, default");
        this.tfHeight.setColumns(10);
        JLabel lbld = new JLabel("3D Format");
        panelDetails.add((Component)lbld, "2, 8, right, default");
        this.cb3dFormat = new JComboBox();
        this.cb3dFormat.addItem("");
        this.cb3dFormat.addItem("3D");
        this.cb3dFormat.addItem("3D SBS");
        this.cb3dFormat.addItem("3D HSBS");
        this.cb3dFormat.addItem("3D TAB");
        this.cb3dFormat.addItem("3D HTAB");
        panelDetails.add(this.cb3dFormat, "4, 8, fill, default");
        JLabel lblAudiostreams = new JLabel("AudioStreams");
        panelDetails.add((Component)lblAudiostreams, "2, 10, right, default");
        JScrollPane scrollPane = new JScrollPane();
        panelDetails.add((Component)scrollPane, "4, 10, 5, 5, fill, fill");
        this.tableAudioStreams = new JTable();
        scrollPane.setViewportView(this.tableAudioStreams);
        this.btnAddAudioStream = new JButton("");
        this.btnAddAudioStream.setAction(new AddAudioStreamAction());
        this.btnAddAudioStream.setMargin(new Insets(2, 2, 2, 2));
        this.btnAddAudioStream.setIcon(IconManager.LIST_ADD);
        panelDetails.add((Component)this.btnAddAudioStream, "2, 12, right, top");
        this.btnRemoveAudioStream = new JButton("");
        this.btnRemoveAudioStream.setAction(new RemoveAudioStreamAction());
        this.btnRemoveAudioStream.setMargin(new Insets(2, 2, 2, 2));
        this.btnRemoveAudioStream.setIcon(IconManager.LIST_REMOVE);
        panelDetails.add((Component)this.btnRemoveAudioStream, "2, 14, right, top");
        JLabel lblSubtitles = new JLabel("Subtitles");
        panelDetails.add((Component)lblSubtitles, "2, 16, right, default");
        scrollPane = new JScrollPane();
        panelDetails.add((Component)scrollPane, "4, 16, 5, 5, fill, fill");
        this.tableSubtitles = new JTable();
        scrollPane.setViewportView(this.tableSubtitles);
        this.btnAddSubtitle = new JButton("");
        this.btnAddSubtitle.setAction(new AddSubtitleAction());
        this.btnAddSubtitle.setMargin(new Insets(2, 2, 2, 2));
        this.btnAddSubtitle.setIcon(IconManager.LIST_ADD);
        panelDetails.add((Component)this.btnAddSubtitle, "2, 18, right, top");
        this.btnRemoveSubtitle = new JButton("");
        this.btnRemoveSubtitle.setAction(new RemoveSubtitleAction());
        this.btnRemoveSubtitle.setMargin(new Insets(2, 2, 2, 2));
        this.btnRemoveSubtitle.setIcon(IconManager.LIST_REMOVE);
        panelDetails.add((Component)this.btnRemoveSubtitle, "2, 20, right, top");
        this.initDataBindings();
        if (!this.mediaFiles.isEmpty()) {
            this.tableMediaFiles.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.tableMediaFiles.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            private Set<MediaFileType> videoTypes = new HashSet<MediaFileType>(Arrays.asList(MediaFileType.VIDEO, MediaFileType.VIDEO_EXTRA, MediaFileType.SAMPLE, MediaFileType.TRAILER));

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                int selectedRow;
                if (!arg0.getValueIsAdjusting() && (selectedRow = MediaFileEditorPanel.this.tableMediaFiles.convertRowIndexToModel(MediaFileEditorPanel.this.tableMediaFiles.getSelectedRow())) > -1) {
                    MediaFile mf = ((MediaFileContainer)MediaFileEditorPanel.this.mediaFiles.get(selectedRow)).getMediaFile();
                    MediaFileEditorPanel.this.tfCodec.setEnabled(mf.getType() != MediaFileType.NFO);
                    MediaFileEditorPanel.this.btnAddAudioStream.setEnabled(this.videoTypes.contains((Object)mf.getType()));
                    MediaFileEditorPanel.this.btnRemoveAudioStream.setEnabled(this.videoTypes.contains((Object)mf.getType()));
                    MediaFileEditorPanel.this.btnAddSubtitle.setEnabled(this.videoTypes.contains((Object)mf.getType()));
                    MediaFileEditorPanel.this.btnRemoveSubtitle.setEnabled(this.videoTypes.contains((Object)mf.getType()));
                    MediaFileEditorPanel.this.cb3dFormat.setEnabled(this.videoTypes.contains((Object)mf.getType()));
                }
            }
        });
    }

    public static void syncMediaFiles(List<MediaFile> mfsFromEditor, List<MediaFile> mfsFromMediaEntity) {
        block0: for (MediaFile mfEditor : mfsFromEditor) {
            for (MediaFile mfOriginal : mfsFromMediaEntity) {
                if (!mfEditor.equals(mfOriginal)) continue;
                if (!mfEditor.getVideoCodec().equals(mfOriginal.getVideoCodec())) {
                    mfOriginal.setVideoCodec(mfEditor.getVideoCodec());
                }
                if (!mfEditor.getContainerFormat().equals(mfOriginal.getContainerFormat())) {
                    mfOriginal.setContainerFormat(mfEditor.getContainerFormat());
                }
                if (mfEditor.getVideoWidth() != mfOriginal.getVideoWidth()) {
                    mfOriginal.setVideoWidth(mfEditor.getVideoWidth());
                }
                if (mfEditor.getVideoHeight() != mfOriginal.getVideoHeight()) {
                    mfOriginal.setVideoHeight(mfEditor.getVideoHeight());
                }
                if (!mfEditor.getVideo3DFormat().equals(mfOriginal.getVideo3DFormat())) {
                    mfOriginal.setVideo3DFormat(mfEditor.getVideo3DFormat());
                }
                mfOriginal.setAudioStreams(mfEditor.getAudioStreams());
                mfOriginal.setSubtitles(mfEditor.getSubtitles());
                continue block0;
            }
        }
    }

    protected void initDataBindings() {
        this.jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.mediaFiles, (JTable)this.tableMediaFiles);
        BeanProperty mediaFileContainerBeanProperty = BeanProperty.create((String)"mediaFile.filename");
        this.jTableBinding.addColumnBinding((Property)mediaFileContainerBeanProperty).setColumnName("Filename").setEditable(false);
        this.jTableBinding.setEditable(false);
        this.jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.mediaFile.filename");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty, (Object)this.lblFilename, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty jTableBeanProperty_1 = BeanProperty.create((String)"selectedElement.mediaFile.videoCodec");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_1, (Object)this.tfCodec, (Property)jTextFieldBeanProperty);
        autoBinding_1.bind();
        BeanProperty jTableBeanProperty_3 = BeanProperty.create((String)"selectedElement.mediaFile.containerFormat");
        BeanProperty jTextFieldBeanProperty_2 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_3, (Object)this.tfContainerFormat, (Property)jTextFieldBeanProperty_2);
        autoBinding_3.bind();
        BeanProperty jTableBeanProperty_5 = BeanProperty.create((String)"selectedElement.mediaFile.videoWidth");
        BeanProperty jTextFieldBeanProperty_4 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_5, (Object)this.tfWidth, (Property)jTextFieldBeanProperty_4);
        autoBinding_5.bind();
        BeanProperty jTableBeanProperty_6 = BeanProperty.create((String)"selectedElement.mediaFile.videoHeight");
        BeanProperty jTextFieldBeanProperty_5 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_6, (Object)this.tfHeight, (Property)jTextFieldBeanProperty_5);
        autoBinding_6.bind();
        BeanProperty jTableBeanProperty_2 = BeanProperty.create((String)"selectedElement.audioStreams");
        this.jTableBinding_1 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_2, (JTable)this.tableAudioStreams);
        BeanProperty mediaFileAudioStreamBeanProperty = BeanProperty.create((String)"language");
        this.jTableBinding_1.addColumnBinding((Property)mediaFileAudioStreamBeanProperty).setColumnName("Language").setColumnClass(String.class);
        BeanProperty mediaFileAudioStreamBeanProperty_1 = BeanProperty.create((String)"codec");
        this.jTableBinding_1.addColumnBinding((Property)mediaFileAudioStreamBeanProperty_1).setColumnName("Codec");
        BeanProperty mediaFileAudioStreamBeanProperty_2 = BeanProperty.create((String)"channels");
        this.jTableBinding_1.addColumnBinding((Property)mediaFileAudioStreamBeanProperty_2).setColumnName("Channels");
        BeanProperty mediaFileAudioStreamBeanProperty_3 = BeanProperty.create((String)"bitrate");
        this.jTableBinding_1.addColumnBinding((Property)mediaFileAudioStreamBeanProperty_3).setColumnName("Bitrate").setColumnClass(Integer.class);
        this.jTableBinding_1.bind();
        BeanProperty jTableBeanProperty_4 = BeanProperty.create((String)"selectedElement.subtitles");
        this.jTableBinding_2 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_4, (JTable)this.tableSubtitles);
        BeanProperty mediaFileSubtitleBeanProperty = BeanProperty.create((String)"language");
        this.jTableBinding_2.addColumnBinding((Property)mediaFileSubtitleBeanProperty).setColumnName("Language").setColumnClass(String.class);
        BeanProperty mediaFileSubtitleBeanProperty_1 = BeanProperty.create((String)"forced");
        this.jTableBinding_2.addColumnBinding((Property)mediaFileSubtitleBeanProperty_1).setColumnName("Forced").setColumnClass(Boolean.class);
        this.jTableBinding_2.bind();
        BeanProperty jTableBeanProperty_7 = BeanProperty.create((String)"selectedElement.mediaFile.video3DFormat");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_7, this.cb3dFormat, (Property)jComboBoxBeanProperty);
        autoBinding_2.bind();
    }

    public void unbindBindings() {
        this.jTableBinding.unbind();
        this.jTableBinding_1.unbind();
        this.jTableBinding_2.unbind();
    }

    public class MediaFileContainer {
        private MediaFile mediaFile;
        private List<MediaFileAudioStream> audioStreams;
        private List<MediaFileSubtitle> subtitles;

        private MediaFileContainer(MediaFile mediaFile) {
            this.mediaFile = mediaFile;
            this.audioStreams = ObservableCollections.observableList(mediaFile.getAudioStreams());
            this.subtitles = ObservableCollections.observableList(mediaFile.getSubtitles());
        }

        public MediaFile getMediaFile() {
            return this.mediaFile;
        }

        public List<MediaFileAudioStream> getAudioStreams() {
            return this.audioStreams;
        }

        public void addAudioStream(MediaFileAudioStream audioStream) {
            if (!this.audioStreams.contains(audioStream)) {
                this.audioStreams.add(audioStream);
            }
        }

        public void removeAudioStream(MediaFileAudioStream audioStream) {
            this.audioStreams.remove(audioStream);
        }

        public List<MediaFileSubtitle> getSubtitles() {
            return this.subtitles;
        }

        public void addSubtitle(MediaFileSubtitle subtitle) {
            if (!this.subtitles.contains(subtitle)) {
                this.subtitles.add(subtitle);
            }
        }

        public void removeSubtitle(MediaFileSubtitle subtitle) {
            this.subtitles.remove(subtitle);
        }
    }

    private class RemoveSubtitleAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079866940827356996L;

        public RemoveSubtitleAction() {
            this.putValue("ShortDescription", BUNDLE.getString("subtitle.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MediaFileEditorPanel.this.tableSubtitles.getSelectedRow();
            if (row > -1) {
                row = MediaFileEditorPanel.this.tableSubtitles.convertRowIndexToModel(row);
                int mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.getSelectedRow();
                if (mediaFileRow > -1) {
                    mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.convertRowIndexToModel(mediaFileRow);
                    MediaFileContainer mf = (MediaFileContainer)MediaFileEditorPanel.this.mediaFiles.get(mediaFileRow);
                    MediaFileSubtitle subtitle = mf.getSubtitles().get(row);
                    mf.removeSubtitle(subtitle);
                }
            }
        }
    }

    private class AddSubtitleAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414523349767L;

        public AddSubtitleAction() {
            this.putValue("ShortDescription", BUNDLE.getString("subtitle.add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.getSelectedRow();
            if (mediaFileRow > -1) {
                mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.convertRowIndexToModel(mediaFileRow);
                MediaFileContainer mf = (MediaFileContainer)MediaFileEditorPanel.this.mediaFiles.get(mediaFileRow);
                mf.addSubtitle(new MediaFileSubtitle());
            }
        }
    }

    private class RemoveAudioStreamAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826940827356996L;

        public RemoveAudioStreamAction() {
            this.putValue("ShortDescription", BUNDLE.getString("audiostream.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MediaFileEditorPanel.this.tableAudioStreams.getSelectedRow();
            if (row > -1) {
                row = MediaFileEditorPanel.this.tableAudioStreams.convertRowIndexToModel(row);
                int mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.getSelectedRow();
                if (mediaFileRow > -1) {
                    mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.convertRowIndexToModel(mediaFileRow);
                    MediaFileContainer mf = (MediaFileContainer)MediaFileEditorPanel.this.mediaFiles.get(mediaFileRow);
                    MediaFileAudioStream audioStream = mf.getAudioStreams().get(row);
                    mf.removeAudioStream(audioStream);
                }
            }
        }
    }

    private class AddAudioStreamAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414523349267L;

        public AddAudioStreamAction() {
            this.putValue("ShortDescription", BUNDLE.getString("audiostream.add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.getSelectedRow();
            if (mediaFileRow > -1) {
                mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.convertRowIndexToModel(mediaFileRow);
                MediaFileContainer mf = (MediaFileContainer)MediaFileEditorPanel.this.mediaFiles.get(mediaFileRow);
                mf.addAudioStream(new MediaFileAudioStream());
            }
        }
    }
}

