/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class UpdateDialog
extends TmmDialog {
    private static final long serialVersionUID = 535315282932742179L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateDialog.class);

    public UpdateDialog(String changelog) {
        super(BUNDLE.getString("tmm.update.title"), "update");
        this.setSize(500, 250);
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "Center");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.PARAGRAPH_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC}));
        JTextPane lblUpdateInfo = new JTextPane();
        lblUpdateInfo.setOpaque(false);
        lblUpdateInfo.setText(BUNDLE.getString("tmm.update.message"));
        panel.add((Component)lblUpdateInfo, "2, 2, fill, default");
        JLabel lblChangelog = new JLabel(BUNDLE.getString("whatsnew.title"));
        panel.add((Component)lblChangelog, "2, 4, fill, default");
        JScrollPane scrollPane = new JScrollPane();
        panel.add((Component)scrollPane, "2, 6, fill, fill");
        JTextPane textPane = new JTextPane();
        textPane.setFont(new Font("Monospaced", 0, Globals.settings.getFontSize() + 1));
        scrollPane.setViewportView(textPane);
        textPane.setContentType("text/html");
        textPane.setText(this.prepareTextAsHtml(changelog));
        textPane.setEditable(false);
        textPane.setCaretPosition(0);
        textPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    try {
                        TmmUIHelper.browseUrl(hle.getURL().toString());
                    }
                    catch (Exception e) {
                        LOGGER.error("error browsing to " + hle.getURL().toString() + " :" + e.getMessage());
                    }
                }
            }
        });
        panel = new JPanel();
        this.getContentPane().add((Component)panel, "South");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JPanel buttonPanel = new JPanel();
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        buttonPanel.setLayout(layout);
        panel.add((Component)buttonPanel, "8, 2");
        JButton btnUpdate = new JButton(BUNDLE.getString("Button.update"));
        btnUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UpdateDialog.this.setVisible(false);
                LOGGER.info("Updating...");
                MainWindow.getActiveInstance().closeTmmAndStart(Utils.getPBforTMMupdate());
            }
        });
        buttonPanel.add(btnUpdate);
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UpdateDialog.this.setVisible(false);
            }
        });
        buttonPanel.add(btnClose);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension superPref = super.getPreferredSize();
        return new Dimension((int)(700.0 > superPref.getWidth() ? superPref.getWidth() : 700.0), (int)(500.0 > superPref.getHeight() ? superPref.getHeight() : 500.0));
    }

    private String prepareTextAsHtml(String originalText) {
        Pattern pattern = Pattern.compile("(http[s]?://.*?)[ )]");
        Matcher matcher = pattern.matcher(originalText);
        while (matcher.find()) {
            originalText = originalText.replace(matcher.group(1), "<a href=\"" + matcher.group(1) + "\">" + matcher.group(1) + "</a>");
        }
        return "<html><pre>" + originalText + "</pre><html>";
    }
}

