/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.cores;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.jcores.jre.CommonCore;
import net.jcores.jre.cores.CoreObject;
import net.jcores.jre.interfaces.functions.F1;
import net.jcores.jre.options.MessageType;
import net.jcores.jre.options.Option;
import net.jcores.jre.utils.internal.Options;

public class CoreBufferedImage
extends CoreObject<BufferedImage> {
    private static final long serialVersionUID = -9069210371713045372L;

    public CoreBufferedImage(CommonCore commonCore, BufferedImage ... bufferedImageArray) {
        super(commonCore, bufferedImageArray);
    }

    public CoreBufferedImage copy() {
        return new CoreBufferedImage(this.commonCore, this.map(new F1<BufferedImage, BufferedImage>(){

            @Override
            public BufferedImage f(BufferedImage bufferedImage) {
                ColorModel colorModel = bufferedImage.getColorModel();
                boolean bl = colorModel.isAlphaPremultiplied();
                WritableRaster writableRaster = bufferedImage.copyData(null);
                return new BufferedImage(colorModel, writableRaster, bl, null);
            }
        }, new Option[0]).array(BufferedImage.class));
    }

    public CoreBufferedImage scale(final float f) {
        return new CoreBufferedImage(this.commonCore, this.map(new F1<BufferedImage, BufferedImage>(){

            @Override
            public BufferedImage f(BufferedImage bufferedImage) {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.scale(f, f);
                AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
                return affineTransformOp.filter(bufferedImage, null);
            }
        }, new Option[0]).array(BufferedImage.class));
    }

    public CoreBufferedImage scale(final int n, final int n2) {
        if (n == 0 && n2 == 0) {
            return this;
        }
        return new CoreBufferedImage(this.commonCore, this.map(new F1<BufferedImage, BufferedImage>(){

            @Override
            public BufferedImage f(BufferedImage bufferedImage) {
                AffineTransform affineTransform = new AffineTransform();
                float f = bufferedImage.getWidth();
                float f2 = bufferedImage.getHeight();
                if (n <= 0) {
                    f2 = n2;
                    f = (float)n2 / f2 * f;
                }
                if (n2 <= 0) {
                    f2 = (float)n / f * f2;
                    f = n;
                }
                if (n > 0 && n2 > 0) {
                    f2 = n2;
                    f = n;
                }
                affineTransform.scale(f / (float)bufferedImage.getWidth(), f2 / (float)bufferedImage.getHeight());
                AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
                return affineTransformOp.filter(bufferedImage, null);
            }
        }, new Option[0]).array(BufferedImage.class));
    }

    public CoreBufferedImage write(String string, Option ... optionArray) {
        if (string == null) {
            return this;
        }
        if (this.size() != 1) {
            this.commonCore.report(MessageType.MISUSE, "CoreBufferedImage.write() needs exactly one image to write, at the moment.");
        }
        String string2 = "png";
        string2 = string.toLowerCase().endsWith(".gif") ? "GIF" : string2;
        string2 = string.toLowerCase().endsWith(".jpg") ? "JPG" : string2;
        string2 = string.toLowerCase().endsWith(".jpeg") ? "JPG" : string2;
        string2 = string.toLowerCase().endsWith(".bmp") ? "BMP" : string2;
        string2 = string.toLowerCase().endsWith(".wbmp") ? "WBMP" : string2;
        try {
            ImageIO.write((RenderedImage)this.get(false), string2, new File(string));
        }
        catch (IOException iOException) {
            Options.$(this.commonCore, optionArray).failure(string, iOException, "write:ioerror", "Unable to write the image to the given file.");
        }
        return this;
    }
}

