/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import java.awt.GraphicsEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ui.dialogs.MessageDialog;

class Log4jBackstop
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Log4jBackstop.class);

    Log4jBackstop() {
    }

    @Override
    public void uncaughtException(Thread t, Throwable ex) {
        if (ex instanceof AssertionError && ex.getStackTrace().length > 0 && "BeanProperty.java".equals(ex.getStackTrace()[0].getFileName())) {
            return;
        }
        LOGGER.error("Uncaught exception in thread: " + t.getName(), ex);
        if ("Null child not allowed".equals(ex.getMessage())) {
            return;
        }
        if (!GraphicsEnvironment.isHeadless()) {
            MessageDialog.showExceptionWindow(ex);
        }
    }
}

