/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.wizard;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLEditorKit;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieNfoNaming;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.settings.MovieScraperSettingsPanel;

class MovieScraperPanel
extends JPanel {
    private static final long serialVersionUID = 405588171648074608L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final MovieSettings settings = MovieModuleManager.MOVIE_SETTINGS;
    private final List<MovieScraperSettingsPanel.MovieScraper> scrapers = ObservableCollections.observableList(new ArrayList());
    private JTable tableScraper;
    private JComboBox<MediaLanguages> cbScraperLanguage;
    private JComboBox<CountryCode> cbCertificationCountry;
    private JTextPane tpScraperDescription;
    private JCheckBox chckbxScraperFallback;
    private JCheckBox cbMovieNfoFilename1;
    private JCheckBox cbMovieNfoFilename2;
    private JCheckBox cbMovieNfoFilename3;
    private JLabel lblMovieScraper;

    public MovieScraperPanel() {
        MediaScraper defaultMediaScraper = MovieList.getInstance().getDefaultMediaScraper();
        int selectedIndex = 0;
        int counter = 0;
        for (MediaScraper scraper : MovieList.getInstance().getAvailableMediaScrapers()) {
            MovieScraperSettingsPanel.MovieScraper movieScraper = new MovieScraperSettingsPanel.MovieScraper(scraper);
            if (scraper.equals(defaultMediaScraper)) {
                movieScraper.setDefaultScraper(true);
                selectedIndex = counter;
            }
            this.scrapers.add(movieScraper);
            ++counter;
        }
        this.initComponents();
        this.initDataBindings();
        List<MovieNfoNaming> movieNfoFilenames = this.settings.getMovieNfoFilenames();
        if (movieNfoFilenames.contains((Object)MovieNfoNaming.FILENAME_NFO)) {
            this.cbMovieNfoFilename1.setSelected(true);
        }
        if (movieNfoFilenames.contains((Object)MovieNfoNaming.MOVIE_NFO)) {
            this.cbMovieNfoFilename2.setSelected(true);
        }
        if (movieNfoFilenames.contains((Object)MovieNfoNaming.DISC_NFO)) {
            this.cbMovieNfoFilename3.setSelected(true);
        }
        this.cbMovieNfoFilename1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MovieScraperPanel.this.checkChanges();
            }
        });
        this.cbMovieNfoFilename3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MovieScraperPanel.this.checkChanges();
            }
        });
        this.cbMovieNfoFilename2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MovieScraperPanel.this.checkChanges();
            }
        });
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 1, 2);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableScraper, 5);
        this.tableScraper.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                if (arg0.getColumn() == 0) {
                    int row = arg0.getFirstRow();
                    MovieScraperSettingsPanel.MovieScraper changedScraper = (MovieScraperSettingsPanel.MovieScraper)MovieScraperPanel.this.scrapers.get(row);
                    if (changedScraper.getDefaultScraper().booleanValue()) {
                        MovieScraperPanel.this.settings.setMovieScraper(changedScraper.getScraperId());
                        for (MovieScraperSettingsPanel.MovieScraper scraper : MovieScraperPanel.this.scrapers) {
                            if (scraper == changedScraper) continue;
                            scraper.setDefaultScraper(Boolean.FALSE);
                        }
                    }
                }
            }
        });
        if (counter > 0) {
            this.tableScraper.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.LINE_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.LINE_GAP_ROWSPEC}));
        JPanel panelMovieScrapers = new JPanel();
        this.add((Component)panelMovieScrapers, "2, 2, fill, fill");
        panelMovieScrapers.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"80dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"120dlu:grow"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC}));
        this.lblMovieScraper = new JLabel(BUNDLE.getString("wizard.movie.scraper"));
        panelMovieScrapers.add((Component)this.lblMovieScraper, "2, 2, 11, 1");
        JScrollPane scrollPaneScraper = new JScrollPane();
        panelMovieScrapers.add((Component)scrollPaneScraper, "2, 4, 5, 1, fill, fill");
        this.tableScraper = new JTable(){
            private static final long serialVersionUID = -144223066269069772L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component comp = super.prepareRenderer(renderer, row, col);
                String value = this.getModel().getValueAt(row, 2).toString();
                if (!Globals.isDonator() && value.startsWith("Kodi")) {
                    comp.setBackground(Color.lightGray);
                    comp.setEnabled(false);
                } else {
                    comp.setBackground(Color.white);
                    comp.setEnabled(true);
                }
                return comp;
            }
        };
        this.tableScraper.setRowHeight(29);
        scrollPaneScraper.setViewportView(this.tableScraper);
        JPanel panelScraperDetails = new JPanel();
        panelMovieScrapers.add((Component)panelScraperDetails, "8, 4, 5, 1, fill, fill");
        panelScraperDetails.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC}));
        this.tpScraperDescription = new JTextPane();
        this.tpScraperDescription.setOpaque(false);
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        panelScraperDetails.add((Component)this.tpScraperDescription, "2, 2, default, top");
        panelMovieScrapers.add((Component)new JSeparator(), "2, 6, 11, 1");
        JLabel lblScraperLanguage = new JLabel(BUNDLE.getString("Settings.preferredLanguage"));
        panelMovieScrapers.add((Component)lblScraperLanguage, "2, 7, right, default");
        this.cbScraperLanguage = new JComboBox();
        this.cbScraperLanguage.setModel(new DefaultComboBoxModel<MediaLanguages>(MediaLanguages.values()));
        panelMovieScrapers.add(this.cbScraperLanguage, "4, 7");
        JLabel lblCountry = new JLabel(BUNDLE.getString("Settings.certificationCountry"));
        panelMovieScrapers.add((Component)lblCountry, "8, 7, right, default");
        this.cbCertificationCountry = new JComboBox();
        this.cbCertificationCountry.setModel(new DefaultComboBoxModel<CountryCode>(CountryCode.values()));
        panelMovieScrapers.add(this.cbCertificationCountry, "10, 7, fill, default");
        this.chckbxScraperFallback = new JCheckBox(BUNDLE.getString("Settings.scraperfallback"));
        panelMovieScrapers.add((Component)this.chckbxScraperFallback, "2, 9, 11, 1");
        panelMovieScrapers.add((Component)new JSeparator(), "2, 11, 11, 1");
        JLabel lblNfoFileNaming = new JLabel(BUNDLE.getString("Settings.nofFileNaming"));
        panelMovieScrapers.add((Component)lblNfoFileNaming, "2, 13");
        this.cbMovieNfoFilename1 = new JCheckBox(BUNDLE.getString("Settings.moviefilename") + ".nfo");
        panelMovieScrapers.add((Component)this.cbMovieNfoFilename1, "4, 13, 3, 1");
        this.cbMovieNfoFilename3 = new JCheckBox(BUNDLE.getString("Settings.nfo.discstyle"));
        panelMovieScrapers.add((Component)this.cbMovieNfoFilename3, "8, 13, 3, 3, default, center");
        this.cbMovieNfoFilename2 = new JCheckBox("movie.nfo");
        panelMovieScrapers.add((Component)this.cbMovieNfoFilename2, "4, 15, 3, 1");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"scraperLanguage");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, this.cbScraperLanguage, (Property)jComboBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"certificationCountry");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, this.cbCertificationCountry, (Property)jComboBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"scraperFallback");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.chckbxScraperFallback, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.scrapers, (JTable)this.tableScraper);
        BeanProperty movieScraperBeanProperty = BeanProperty.create((String)"defaultScraper");
        jTableBinding.addColumnBinding((Property)movieScraperBeanProperty).setColumnName("Default").setColumnClass(Boolean.class);
        BeanProperty movieScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding.addColumnBinding((Property)movieScraperBeanProperty_1).setColumnName("Logo").setColumnClass(Icon.class);
        BeanProperty movieScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding.addColumnBinding((Property)movieScraperBeanProperty_2).setColumnName("Name").setEditable(false);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableScraper, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty);
        autoBinding_12.bind();
    }

    private void checkChanges() {
        this.settings.clearMovieNfoFilenames();
        if (this.cbMovieNfoFilename1.isSelected()) {
            this.settings.addMovieNfoFilename(MovieNfoNaming.FILENAME_NFO);
        }
        if (this.cbMovieNfoFilename2.isSelected()) {
            this.settings.addMovieNfoFilename(MovieNfoNaming.MOVIE_NFO);
        }
        if (this.cbMovieNfoFilename3.isSelected()) {
            this.settings.addMovieNfoFilename(MovieNfoNaming.DISC_NFO);
        }
    }
}

