/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TreePopupListener;
import org.tinymediamanager.ui.TreeUI;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ZebraJTree;
import org.tinymediamanager.ui.movies.MovieInformationPanel;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.moviesets.MovieSetInformationPanel;
import org.tinymediamanager.ui.moviesets.MovieSetSelectionModel;
import org.tinymediamanager.ui.moviesets.MovieSetTreeCellRenderer;
import org.tinymediamanager.ui.moviesets.MovieSetTreeModel;
import org.tinymediamanager.ui.moviesets.actions.DebugDumpMovieSet;
import org.tinymediamanager.ui.moviesets.actions.MovieEditAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetAddAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetEditAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetRemoveAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetRenameAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetSearchAction;

public class MovieSetPanel
extends JPanel {
    private static final long serialVersionUID = -7095093579735941697L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    MovieSelectionModel movieSelectionModel;
    MovieSetSelectionModel movieSetSelectionModel;
    private MovieList movieList = MovieList.getInstance();
    private MovieSetTreeModel treeModel;
    private int width = 0;
    private JSplitPane splitPaneHorizontal;
    private JTree tree;
    private JLabel lblMovieSetCount;
    private final Action actionAddMovieSet = new MovieSetAddAction(false);
    private final Action actionRemoveMovieSet = new MovieSetRemoveAction(false);
    private final Action actionSearchMovieSet = new MovieSetSearchAction(false);
    private final Action actionEditMovieSet = new MovieSetEditAction(false);

    public MovieSetPanel() {
        this.movieSelectionModel = new MovieSelectionModel();
        this.treeModel = new MovieSetTreeModel(this.movieList.getMovieSetList());
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"fill:default:grow"), FormFactory.DEFAULT_ROWSPEC}));
        this.splitPaneHorizontal = new JSplitPane();
        this.splitPaneHorizontal.setContinuousLayout(true);
        this.add((Component)this.splitPaneHorizontal, "2, 2, fill, fill");
        JPanel panelMovieSetList = new JPanel();
        this.splitPaneHorizontal.setLeftComponent(panelMovieSetList);
        panelMovieSetList.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"250px:grow")}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"fill:322px:grow")}));
        JToolBar toolBar = new JToolBar();
        toolBar.setRollover(true);
        toolBar.setFloatable(false);
        toolBar.setOpaque(false);
        panelMovieSetList.add((Component)toolBar, "2, 2");
        JButton btnAddMovieSet = new JButton("");
        btnAddMovieSet.setAction(this.actionAddMovieSet);
        toolBar.add(btnAddMovieSet);
        JButton btnRemoveMovieSet = new JButton("");
        btnRemoveMovieSet.setAction(this.actionRemoveMovieSet);
        toolBar.add(btnRemoveMovieSet);
        JButton btnSearchMovieSet = new JButton("");
        btnSearchMovieSet.setAction(this.actionSearchMovieSet);
        toolBar.add(btnSearchMovieSet);
        JButton btnEditMovieSet = new JButton("");
        btnEditMovieSet.setAction(this.actionEditMovieSet);
        toolBar.add(btnEditMovieSet);
        JScrollPane scrollPane = new JScrollPane();
        panelMovieSetList.add((Component)scrollPane, "2, 4, fill, fill");
        this.tree = new ZebraJTree(this.treeModel){
            private static final long serialVersionUID = 8881757869311476200L;

            @Override
            public void paintComponent(Graphics g) {
                MovieSetPanel.this.width = this.getWidth();
                super.paintComponent(g);
            }
        };
        this.movieSetSelectionModel = new MovieSetSelectionModel(this.tree);
        TreeUI ui = new TreeUI(){

            @Override
            protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
                bounds.width = MovieSetPanel.this.width - bounds.x;
                super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            }
        };
        this.tree.setUI((javax.swing.plaf.TreeUI)((Object)ui));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new MovieSetTreeCellRenderer());
        this.tree.setRowHeight(0);
        scrollPane.setViewportView(this.tree);
        JPanel panelHeader = new JPanel(){
            private static final long serialVersionUID = -6646766582759138262L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                JTattooUtilities.fillHorGradient((Graphics)g, (Color[])AbstractLookAndFeel.getTheme().getColHeaderColors(), (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
            }
        };
        scrollPane.setColumnHeaderView(panelHeader);
        panelHeader.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"center:20px"), ColumnSpec.decode((String)"center:20px")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblMovieSetColumn = new JLabel(BUNDLE.getString("tmm.movieset"));
        lblMovieSetColumn.setHorizontalAlignment(0);
        panelHeader.add((Component)lblMovieSetColumn, "2, 1");
        JLabel lblNfoColumn = new JLabel("");
        lblNfoColumn.setHorizontalAlignment(0);
        lblNfoColumn.setIcon(IconManager.INFO);
        lblNfoColumn.setToolTipText(BUNDLE.getString("tmm.nfo"));
        panelHeader.add((Component)lblNfoColumn, "4, 1");
        JLabel lblImageColumn = new JLabel("");
        lblImageColumn.setHorizontalAlignment(0);
        lblImageColumn.setIcon(IconManager.IMAGE);
        lblImageColumn.setToolTipText(BUNDLE.getString("tmm.images"));
        panelHeader.add((Component)lblImageColumn, "5, 1");
        final JPanel panelRight = new JPanel();
        this.splitPaneHorizontal.setRightComponent(panelRight);
        panelRight.setLayout(new CardLayout(0, 0));
        MovieSetInformationPanel panelSet = new MovieSetInformationPanel(this.movieSetSelectionModel);
        panelRight.add((Component)panelSet, "movieSet");
        MovieInformationPanel panelMovie = new MovieInformationPanel(this.movieSelectionModel);
        panelRight.add((Component)panelMovie, "movie");
        JPanel panelMovieSetCount = new JPanel();
        this.add((Component)panelMovieSetCount, "2, 3, left, fill");
        JLabel lblMovieSets = new JLabel(BUNDLE.getString("tmm.moviesets"));
        panelMovieSetCount.add(lblMovieSets);
        this.lblMovieSetCount = new JLabel("0");
        panelMovieSetCount.add(this.lblMovieSetCount);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)MovieSetPanel.this.tree.getLastSelectedPathComponent();
                if (node != null) {
                    CardLayout cl;
                    if (node.getUserObject() instanceof MovieSet) {
                        MovieSet movieSet = (MovieSet)node.getUserObject();
                        MovieSetPanel.this.movieSetSelectionModel.setSelectedMovieSet(movieSet);
                        cl = (CardLayout)panelRight.getLayout();
                        cl.show(panelRight, "movieSet");
                    }
                    if (node.getUserObject() instanceof Movie) {
                        Movie movie = (Movie)node.getUserObject();
                        MovieSetPanel.this.movieSelectionModel.setSelectedMovie(movie);
                        cl = (CardLayout)panelRight.getLayout();
                        cl.show(panelRight, "movie");
                    }
                } else {
                    MovieSetPanel.this.movieSetSelectionModel.setSelectedMovieSet(null);
                }
            }
        });
        this.init();
        this.initDataBindings();
        if (this.movieList.getMovieSetList() != null && this.movieList.getMovieSetList().size() > 0) {
            DefaultMutableTreeNode firstLeaf = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.tree.getModel().getRoot()).getFirstChild();
            this.tree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)firstLeaf.getParent()).getPath()));
            this.tree.setSelectionPath(new TreePath(firstLeaf.getPath()));
        }
    }

    private void init() {
        this.buildMenu();
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed() && e.getButton() == 1) {
                    MovieSetPanel.this.actionEditMovieSet.actionPerformed(new ActionEvent(e, 0, ""));
                }
            }
        };
        this.tree.addMouseListener(mouseListener);
    }

    private void buildMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        MovieSetAddAction actionAddMovieSet = new MovieSetAddAction(true);
        popupMenu.add(actionAddMovieSet);
        MovieSetRemoveAction actionRemoveMovieSet = new MovieSetRemoveAction(true);
        popupMenu.add(actionRemoveMovieSet);
        MovieSetEditAction actionEditMovieSet = new MovieSetEditAction(true);
        popupMenu.add(actionEditMovieSet);
        MovieSetSearchAction actionSearchMovieSet = new MovieSetSearchAction(true);
        popupMenu.add(actionSearchMovieSet);
        popupMenu.addSeparator();
        MovieEditAction actionEditMovie = new MovieEditAction(true);
        popupMenu.add(actionEditMovie);
        popupMenu.addSeparator();
        MovieSetRenameAction actionRenameMovies = new MovieSetRenameAction();
        popupMenu.add(actionRenameMovies);
        if (Globals.isDebug()) {
            popupMenu.addSeparator();
            JMenu menuDebug = new JMenu("Debug");
            menuDebug.add(new DebugDumpMovieSet());
            popupMenu.add(menuDebug);
        }
        TreePopupListener popupListener = new TreePopupListener(popupMenu, this.tree);
        this.tree.addMouseListener(popupListener);
    }

    protected void initDataBindings() {
        BeanProperty movieListBeanProperty = BeanProperty.create((String)"movieSetCount");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieList, (Property)movieListBeanProperty, (Object)this.lblMovieSetCount, (Property)jLabelBeanProperty);
        autoBinding.bind();
    }
}

