/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieRenamerPreview;
import org.tinymediamanager.core.movie.MovieRenamerPreviewContainer;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieRenameTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ZebraJTable;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.movies.MovieComparator;

public class MovieRenamerPreviewDialog
extends TmmDialog {
    private static final long serialVersionUID = -8162631708278089277L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private EventList<MovieRenamerPreviewContainer> results;
    private DefaultEventTableModel<MovieRenamerPreviewContainer> movieTableModel;
    private ResultSelectionModel resultSelectionModel;
    private EventList<MediaFileContainer> oldMediaFileEventList;
    private DefaultEventTableModel<MediaFileContainer> oldMediaFileTableModel;
    private EventList<MediaFileContainer> newMediaFileEventList;
    private DefaultEventTableModel<MediaFileContainer> newMediaFileTableModel;
    private JTable tableMovies;
    private JLabel lblTitle;
    private JLabel lblDatasource;
    private JLabel lblFolderOld;
    private JLabel lblFolderNew;
    private JTable tableMediaFilesNew;
    private JTable tableMediaFilesOld;

    public MovieRenamerPreviewDialog(List<Movie> selectedMovies) {
        super(BUNDLE.getString("movie.renamerpreview"), "movieRenamerPreview");
        this.setBounds(5, 5, 950, 700);
        this.results = GlazedListsSwing.swingThreadProxyList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()));
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC}));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(0.2);
        panelContent.add((Component)splitPane, "2, 2, fill, fill");
        this.movieTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.results), (TableFormat)new ResultTableFormat());
        this.tableMovies = new ZebraJTable((TableModel)this.movieTableModel);
        DefaultEventSelectionModel tableSelectionModel = new DefaultEventSelectionModel(this.results);
        this.resultSelectionModel = new ResultSelectionModel();
        tableSelectionModel.addListSelectionListener((ListSelectionListener)this.resultSelectionModel);
        this.resultSelectionModel.selectedResults = (List)tableSelectionModel.getSelected();
        this.tableMovies.setSelectionModel((ListSelectionModel)tableSelectionModel);
        this.movieTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                ListSelectionModel selectionModel = MovieRenamerPreviewDialog.this.tableMovies.getSelectionModel();
                if (selectionModel.isSelectionEmpty() && MovieRenamerPreviewDialog.this.movieTableModel.getRowCount() > 0) {
                    selectionModel.setSelectionInterval(0, 0);
                }
                if (selectionModel.isSelectionEmpty() && MovieRenamerPreviewDialog.this.movieTableModel.getRowCount() == 0) {
                    MovieRenamerPreviewDialog.this.resultSelectionModel.setSelectedResult(null);
                }
            }
        });
        JScrollPane scrollPaneMovies = ZebraJTable.createStripedJScrollPane(this.tableMovies);
        scrollPaneMovies.setViewportView(this.tableMovies);
        splitPane.setLeftComponent(scrollPaneMovies);
        scrollPaneMovies.setMinimumSize(new Dimension(200, 200));
        JPanel panelDetails = new JPanel();
        splitPane.setRightComponent(panelDetails);
        panelDetails.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, RowSpec.decode((String)"6dlu"), RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC}));
        this.lblTitle = new JLabel("");
        TmmFontHelper.changeFont(this.lblTitle, 1.33, 1);
        panelDetails.add((Component)this.lblTitle, "2, 2, 3, 1");
        JLabel lblDatasourceT = new JLabel(BUNDLE.getString("metatag.datasource"));
        panelDetails.add((Component)lblDatasourceT, "2, 4");
        this.lblDatasource = new JLabel("");
        panelDetails.add((Component)this.lblDatasource, "4, 4");
        JLabel lblFolderOldT = new JLabel(BUNDLE.getString("renamer.oldfolder"));
        panelDetails.add((Component)lblFolderOldT, "2, 6");
        this.lblFolderOld = new JLabel("");
        panelDetails.add((Component)this.lblFolderOld, "4, 6");
        JLabel lblFolderNewT = new JLabel(BUNDLE.getString("renamer.newfolder"));
        panelDetails.add((Component)lblFolderNewT, "2, 8");
        this.lblFolderNew = new JLabel("");
        panelDetails.add((Component)this.lblFolderNew, "4, 8");
        JPanel panelMediaFiles = new JPanel();
        panelDetails.add((Component)panelMediaFiles, "2, 10, 3, 1, fill, fill");
        panelMediaFiles.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, RowSpec.decode((String)"fill:default:grow")}));
        JLabel lblOldfiles = new JLabel(BUNDLE.getString("renamer.oldfiles"));
        panelMediaFiles.add((Component)lblOldfiles, "1, 1, default, default");
        JLabel lblNewfiles = new JLabel(BUNDLE.getString("renamer.newfiles"));
        panelMediaFiles.add((Component)lblNewfiles, "3, 1, default, default");
        this.oldMediaFileEventList = GlazedLists.eventList(new ArrayList());
        this.oldMediaFileTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.oldMediaFileEventList), (TableFormat)new MediaFileTableFormat());
        this.tableMediaFilesOld = new ZebraJTable((TableModel)this.oldMediaFileTableModel);
        JScrollPane scrollPaneMediaFilesOld = ZebraJTable.createStripedJScrollPane(this.tableMediaFilesOld);
        panelMediaFiles.add((Component)scrollPaneMediaFilesOld, "1, 3, fill, fill");
        scrollPaneMediaFilesOld.setViewportView(this.tableMediaFilesOld);
        this.tableMediaFilesOld.getColumnModel().getColumn(0).setMaxWidth(25);
        this.newMediaFileEventList = GlazedLists.eventList(new ArrayList());
        this.newMediaFileTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.newMediaFileEventList), (TableFormat)new MediaFileTableFormat());
        this.tableMediaFilesNew = new ZebraJTable((TableModel)this.newMediaFileTableModel);
        JScrollPane scrollPaneMediaFilesNew = ZebraJTable.createStripedJScrollPane(this.tableMediaFilesNew);
        panelMediaFiles.add((Component)scrollPaneMediaFilesNew, "3, 3, fill, fill");
        scrollPaneMediaFilesNew.setViewportView(this.tableMediaFilesNew);
        this.tableMediaFilesNew.getColumnModel().getColumn(0).setMaxWidth(25);
        JPanel panelButtons = new JPanel();
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        panelButtons.setLayout(layout);
        panelButtons.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.getContentPane().add((Component)panelButtons, "South");
        JButton btnRename = new JButton(BUNDLE.getString("Button.rename"));
        btnRename.setToolTipText(BUNDLE.getString("movie.rename"));
        btnRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ArrayList<Movie> selectedMovies = new ArrayList<Movie>();
                ArrayList selectedResults = new ArrayList(MovieRenamerPreviewDialog.this.resultSelectionModel.selectedResults);
                for (MovieRenamerPreviewContainer result : selectedResults) {
                    selectedMovies.add(result.getMovie());
                }
                MovieRenameTask renameTask = new MovieRenameTask(selectedMovies);
                if (TmmTaskManager.getInstance().addMainTask(renameTask)) {
                    JOptionPane.showMessageDialog(null, BUNDLE.getString("onlyoneoperation"));
                } else {
                    for (MovieRenamerPreviewContainer result : selectedResults) {
                        MovieRenamerPreviewDialog.this.results.remove((Object)result);
                    }
                }
            }
        });
        panelButtons.add(btnRename);
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        btnClose.setIcon(IconManager.APPLY);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MovieRenamerPreviewDialog.this.setVisible(false);
            }
        });
        panelButtons.add(btnClose);
        MoviePreviewWorker worker = new MoviePreviewWorker(selectedMovies);
        worker.execute();
    }

    private class MediaFileContainer {
        ImageIcon icon = null;
        MediaFile mediaFile;

        private MediaFileContainer() {
        }
    }

    private class ResultSelectionModel
    extends AbstractModelObject
    implements ListSelectionListener {
        private MovieRenamerPreviewContainer selectedResult;
        private List<MovieRenamerPreviewContainer> selectedResults;
        private MovieRenamerPreviewContainer emptyResult = new MovieRenamerPreviewContainer(new Movie());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setSelectedResult(MovieRenamerPreviewContainer newValue) {
            this.selectedResult = newValue == null ? this.emptyResult : newValue;
            MovieRenamerPreviewDialog.this.lblTitle.setText(this.selectedResult.getMovie().getTitleSortable());
            MovieRenamerPreviewDialog.this.lblDatasource.setText(this.selectedResult.getMovie().getDataSource());
            if (this.selectedResult != this.emptyResult) {
                MovieRenamerPreviewDialog.this.lblFolderOld.setText(this.selectedResult.getOldPath().toString());
                MovieRenamerPreviewDialog.this.lblFolderNew.setText(this.selectedResult.getNewPath().toString());
            } else {
                MovieRenamerPreviewDialog.this.lblFolderOld.setText("");
                MovieRenamerPreviewDialog.this.lblFolderNew.setText("");
            }
            try {
                MediaFileContainer container;
                boolean found;
                MovieRenamerPreviewDialog.this.oldMediaFileEventList.getReadWriteLock().writeLock().lock();
                MovieRenamerPreviewDialog.this.oldMediaFileEventList.clear();
                for (MediaFile mf : this.selectedResult.getOldMediaFiles()) {
                    found = false;
                    container = new MediaFileContainer();
                    container.mediaFile = mf;
                    for (MediaFile mf2 : this.selectedResult.getNewMediaFiles()) {
                        if (mf2 == null || !mf.getFilename().equals(mf2.getFilename())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        container.icon = IconManager.LIST_REMOVE;
                    }
                    MovieRenamerPreviewDialog.this.oldMediaFileEventList.add((Object)container);
                }
                MovieRenamerPreviewDialog.this.newMediaFileEventList.getReadWriteLock().writeLock().lock();
                MovieRenamerPreviewDialog.this.newMediaFileEventList.clear();
                for (MediaFile mf : this.selectedResult.getNewMediaFiles()) {
                    found = false;
                    container = new MediaFileContainer();
                    container.mediaFile = mf;
                    for (MediaFile mf2 : this.selectedResult.getOldMediaFiles()) {
                        if (!mf.getFilename().equals(mf2.getFilename())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        container.icon = IconManager.LIST_ADD;
                    }
                    MovieRenamerPreviewDialog.this.newMediaFileEventList.add((Object)container);
                }
            }
            catch (Exception exception) {
            }
            finally {
                MovieRenamerPreviewDialog.this.oldMediaFileEventList.getReadWriteLock().writeLock().unlock();
                MovieRenamerPreviewDialog.this.newMediaFileEventList.getReadWriteLock().writeLock().unlock();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent arg0) {
            if (arg0.getValueIsAdjusting()) {
                return;
            }
            if (!this.selectedResults.isEmpty() && this.selectedResult != this.selectedResults.get(0)) {
                this.setSelectedResult(this.selectedResults.get(0));
            }
            if (this.selectedResults.isEmpty()) {
                this.setSelectedResult(this.emptyResult);
            }
        }
    }

    private class MoviePreviewWorker
    extends SwingWorker<Void, Void> {
        private List<Movie> moviesToProcess;

        private MoviePreviewWorker(List<Movie> movies) {
            this.moviesToProcess = new ArrayList<Movie>(movies);
        }

        @Override
        protected Void doInBackground() throws Exception {
            Collections.sort(this.moviesToProcess, new MovieComparator());
            for (Movie movie : this.moviesToProcess) {
                MovieRenamerPreviewContainer container = MovieRenamerPreview.renameMovie(movie);
                if (!container.isNeedsRename()) continue;
                MovieRenamerPreviewDialog.this.results.add((Object)container);
            }
            return null;
        }
    }

    private class MediaFileTableFormat
    implements AdvancedTableFormat<MediaFileContainer> {
        private MediaFileTableFormat() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return BUNDLE.getString("metatag.filename");
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(MediaFileContainer mediaFileContainer, int column) {
            switch (column) {
                case 0: {
                    return mediaFileContainer.icon;
                }
                case 1: {
                    return mediaFileContainer.mediaFile.getFilename();
                }
            }
            throw new IllegalStateException();
        }

        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return ImageIcon.class;
                }
                case 1: {
                    return String.class;
                }
            }
            throw new IllegalStateException();
        }

        public Comparator<MediaFileContainer> getColumnComparator(int column) {
            return null;
        }
    }

    private class ResultTableFormat
    implements TableFormat<MovieRenamerPreviewContainer> {
        private ResultTableFormat() {
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return BUNDLE.getString("metatag.movie");
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(MovieRenamerPreviewContainer result, int column) {
            switch (column) {
                case 0: {
                    return result.getMovie().getTitleSortable();
                }
            }
            throw new IllegalStateException();
        }
    }
}

