/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.LaunchUtil;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.RecursiveToStringStyle;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.util.StrgUtils;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final Pattern localePattern = Pattern.compile("messages_(.{2})_?(.{2}){0,1}\\.properties", 2);
    private static final Pattern stackingPattern1 = Pattern.compile("(.*?)[ _.-]+((?:cd|dvd|p(?:ar)?t|dis[ck])[ _.-]*[1-9]{1})(\\.[^.]+)$", 2);
    private static final Pattern stackingPattern2 = Pattern.compile("(.*?)[ _.-]+((?:cd|dvd|p(?:ar)?t|dis[ck])[ _.-]*[a-d])(\\.[^.]+)$", 2);
    private static final Pattern stackingPattern3 = Pattern.compile("(.*?)[_.-]+([a-d])(\\.[^.]+)$", 2);
    private static final Pattern stackingPattern4 = Pattern.compile("(.*?)[ \\(_.-]+([1-9][ .]?of[ .]?[1-9])[ \\)_-]?(\\.[^.]+)$", 2);
    private static final Pattern folderStackingPattern = Pattern.compile("(.*?)[ _.-]*((?:cd|dvd|p(?:ar)?t|dis[ck])[ _.-]*[1-9]{1})$", 2);

    public static String getExtension(Path path) {
        String ext = "";
        String fn = path.getFileName().toString();
        int i = fn.lastIndexOf(46);
        if (i > 0) {
            ext = fn.substring(i + 1);
        }
        return ext;
    }

    public static boolean isRegularFile(Path file) {
        try {
            BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            return (attr.isRegularFile() || attr.isOther()) && !attr.isDirectory();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isRegularFile(BasicFileAttributes attr) {
        return (attr.isRegularFile() || attr.isOther()) && !attr.isDirectory();
    }

    public static void dumpObject(Object o) {
        System.out.println(ReflectionToStringBuilder.toString((Object)o, (ToStringStyle)new RecursiveToStringStyle(5)));
    }

    public static String relPath(String parent, String child) {
        return Utils.relPath(Paths.get(parent, new String[0]), Paths.get(child, new String[0]));
    }

    public static String relPath(Path parent, Path child) {
        return parent.relativize(child).toString();
    }

    public static String getSortableName(String title) {
        if (title == null || title.isEmpty()) {
            return "";
        }
        if (title.toLowerCase(Locale.ROOT).matches("^die hard$") || title.toLowerCase(Locale.ROOT).matches("^die hard[:\\s].*")) {
            return title;
        }
        if (title.toLowerCase(Locale.ROOT).matches("^die another day$") || title.toLowerCase(Locale.ROOT).matches("^die another day[:\\s].*")) {
            return title;
        }
        for (String prfx : Settings.getInstance().getTitlePrefix()) {
            String delim = "\\s+";
            if (prfx.matches(".*['`\u00b4]$")) {
                delim = "";
            }
            if (!title.matches("(?i)^" + Pattern.quote(prfx) + delim + "(.*)")) continue;
            title = title.replaceAll("(?i)^" + Pattern.quote(prfx) + delim + "(.*)", "$1, " + prfx);
            break;
        }
        return title.trim();
    }

    public static String removeSortableName(String title) {
        if (title == null || title.isEmpty()) {
            return "";
        }
        for (String prfx : Settings.getInstance().getTitlePrefix()) {
            String delim = " ";
            if (prfx.matches(".*['`\u00b4]$")) {
                delim = "";
            }
            title = title.replaceAll("(?i)(.*), " + prfx + "$", prfx + delim + "$1");
        }
        return title.trim();
    }

    public static String cleanStackingMarkers(String filename) {
        if (!StringUtils.isEmpty((CharSequence)filename)) {
            Matcher m = stackingPattern1.matcher(filename);
            if (m.matches()) {
                return m.group(1) + m.group(3);
            }
            m = stackingPattern2.matcher(filename);
            if (m.matches()) {
                return m.group(1) + m.group(3);
            }
            m = stackingPattern3.matcher(filename);
            if (m.matches()) {
                return m.group(1) + m.group(3);
            }
            m = stackingPattern4.matcher(filename);
            if (m.matches()) {
                return m.group(1) + m.group(3);
            }
        }
        return filename;
    }

    public static String cleanFolderStackingMarkers(String filename) {
        Matcher m;
        if (!StringUtils.isEmpty((CharSequence)filename) && (m = folderStackingPattern.matcher(filename)).matches()) {
            return m.group(1);
        }
        return filename;
    }

    public static String getFolderStackingMarker(String filename) {
        Matcher m;
        if (!StringUtils.isEmpty((CharSequence)filename) && (m = folderStackingPattern.matcher(filename)).matches()) {
            return m.group(2);
        }
        return "";
    }

    public static String getStackingMarker(String filename) {
        if (!StringUtils.isEmpty((CharSequence)filename)) {
            Matcher m = stackingPattern1.matcher(filename);
            if (m.matches()) {
                return m.group(2);
            }
            m = stackingPattern2.matcher(filename);
            if (m.matches()) {
                return m.group(2);
            }
            m = stackingPattern3.matcher(filename);
            if (m.matches()) {
                return m.group(2);
            }
            m = stackingPattern4.matcher(filename);
            if (m.matches()) {
                return m.group(2);
            }
        }
        return "";
    }

    public static String substr(String str, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher m = regex.matcher(str);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    public static String getStackingPrefix(String filename) {
        String stack = Utils.getStackingMarker(filename).replaceAll("[0-9]", "");
        if (stack.length() == 1 || stack.contains("of")) {
            stack = "";
        }
        return stack;
    }

    public static int getStackingNumber(String filename) {
        String stack;
        if (!StringUtils.isEmpty((CharSequence)filename) && !(stack = Utils.getStackingMarker(filename)).isEmpty()) {
            if (stack.equalsIgnoreCase("a")) {
                return 1;
            }
            if (stack.equalsIgnoreCase("b")) {
                return 2;
            }
            if (stack.equalsIgnoreCase("c")) {
                return 3;
            }
            if (stack.equalsIgnoreCase("d")) {
                return 4;
            }
            if (stack.contains("of")) {
                stack = stack.replaceAll("of.*", "");
            }
            try {
                int s = Integer.parseInt(stack.replaceAll("[^0-9]", ""));
                return s;
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    public static boolean isValidImdbId(String imdbId) {
        if (StringUtils.isEmpty((CharSequence)imdbId)) {
            return false;
        }
        return imdbId.matches("tt\\d{7}");
    }

    public static String unquote(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceFirst("^\\\"(.*)\\\"$", "$1");
    }

    public static void trackEvent(final String event) {
        Path disable = Paths.get("tmm.uuid.disable", new String[0]);
        if (Globals.settings.isEnableAnalytics() && !Files.exists(disable, new LinkOption[0])) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.currentThread().setName("trackEventThread");
                        Path uuidFile = Paths.get("tmm.uuid", new String[0]);
                        if (!Files.exists(uuidFile, new LinkOption[0])) {
                            Utils.writeStringToFile(uuidFile, UUID.randomUUID().toString());
                        }
                        if (Files.exists(uuidFile, new LinkOption[0])) {
                            Url url;
                            InputStream in;
                            String uuid = Utils.readFileToString(uuidFile);
                            System.setProperty("tmm.uuid", uuid);
                            String session = "";
                            if ("startup".equals(event)) {
                                session = "&sc=start";
                            } else if ("shutdown".equals(event)) {
                                session = "&sc=end";
                            }
                            String ga = "v=1&tid=UA-35564534-5&cid=" + uuid + "&an=tinyMediaManager" + "&av=" + ReleaseInfo.getVersionForReporting() + "&t=event" + "&ec=" + event + "&ea=" + event + "&aip=1" + "&je=1" + session + "&ul=" + Utils.getEncProp("user.language") + "-" + Utils.getEncProp("user.country") + "&vp=" + TmmProperties.getInstance().getPropertyAsInteger("mainWindowW") + "x" + TmmProperties.getInstance().getPropertyAsInteger("mainWindowH") + "&cd1=" + Utils.getEncProp("os.name") + "&cd2=" + Utils.getEncProp("os.arch") + "&cd3=" + Utils.getEncProp("java.specification.version") + "&cd4=" + ReleaseInfo.getVersion() + "&cd5=" + (Globals.isDonator() ? "1" : "0") + "&z=" + System.currentTimeMillis();
                            if (!GraphicsEnvironment.isHeadless()) {
                                ga = ga + "&sr=" + Toolkit.getDefaultToolkit().getScreenSize().width + "x" + Toolkit.getDefaultToolkit().getScreenSize().height;
                            }
                            if ((in = (url = new Url("https://ssl.google-analytics.com/collect?" + ga)).getInputStream()) != null) {
                                try {
                                    in.close();
                                }
                                catch (Exception ignored) {}
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOGGER.warn("could not ping our update server...");
                    }
                }
            }).start();
        }
    }

    private static String getEncProp(String prop) {
        String property = System.getProperty(prop);
        if (StringUtils.isBlank((CharSequence)property)) {
            return "";
        }
        try {
            return URLEncoder.encode(property, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return URLEncoder.encode(property);
        }
    }

    public static void removeEmptyStringsFromList(List<String> list) {
        list.removeAll(Collections.singleton(null));
        list.removeAll(Collections.singleton(""));
    }

    public static String replacePlaceholders(String source, String[] replacements) {
        Matcher matcher;
        String result = source;
        int index = 0;
        Pattern pattern = Pattern.compile("\\{\\}");
        while ((matcher = pattern.matcher(result)).find()) {
            try {
                result = replacements.length > index ? result.replaceFirst(pattern.pattern(), StringEscapeUtils.escapeJava((String)replacements[index])) : result.replaceFirst(pattern.pattern(), "");
            }
            catch (Exception e) {
                result = result.replaceFirst(pattern.pattern(), "");
            }
            ++index;
        }
        return StrgUtils.removeDuplicateWhitespace((String)result);
    }

    public static boolean moveDirectorySafe(Path srcDir, Path destDir) throws IOException {
        if (srcDir == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcDir.toAbsolutePath().toString().equals(destDir.toAbsolutePath().toString())) {
            LOGGER.debug("try to move folder " + srcDir + " to " + destDir);
            if (!Files.isDirectory(srcDir, new LinkOption[0])) {
                throw new FileNotFoundException("Source '" + srcDir + "' does not exist, or is not a directory");
            }
            if (Files.exists(destDir, new LinkOption[0]) && !Files.isSameFile(destDir, srcDir)) {
                throw new FileExistsException("Destination '" + destDir + "' already exists");
            }
            if (!Files.exists(destDir.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectories(destDir.getParent(), new FileAttribute[0]);
                }
                catch (Exception e) {
                    LOGGER.error("could not create directory structure " + destDir.getParent());
                }
            }
            boolean rename = false;
            for (int i = 0; i < 5; ++i) {
                try {
                    Files.move(srcDir, destDir, StandardCopyOption.ATOMIC_MOVE);
                    rename = true;
                }
                catch (AtomicMoveNotSupportedException a) {
                    try {
                        Files.move(srcDir, destDir, StandardCopyOption.REPLACE_EXISTING);
                        rename = true;
                    }
                    catch (IOException e) {}
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (rename) break;
                try {
                    LOGGER.debug("rename did not work - sleep a while and try again...");
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.warn("I'm so excited - could not sleep");
                }
            }
            if (!rename) {
                LOGGER.error("Failed to rename directory '" + srcDir + " to " + destDir);
                LOGGER.error("Movie renaming aborted.");
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, srcDir, "message.renamer.failedrename"));
                return false;
            }
            LOGGER.info("Successfully moved folder " + srcDir + " to " + destDir);
            return true;
        }
        return true;
    }

    public static boolean moveFileSafe(Path srcFile, Path destFile) throws IOException {
        if (srcFile == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destFile == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcFile.toAbsolutePath().toString().equals(destFile.toAbsolutePath().toString())) {
            LOGGER.debug("try to move file " + srcFile + " to " + destFile);
            if (!Files.exists(srcFile, new LinkOption[0])) {
                throw new FileNotFoundException("Source '" + srcFile + "' does not exist");
            }
            if (Files.isDirectory(srcFile, new LinkOption[0])) {
                throw new IOException("Source '" + srcFile + "' is a directory");
            }
            if (Files.exists(destFile, new LinkOption[0]) && !Files.isSameFile(destFile, srcFile)) {
                throw new FileExistsException("Destination '" + destFile + "' already exists");
            }
            if (Files.isDirectory(destFile, new LinkOption[0])) {
                throw new IOException("Destination '" + destFile + "' is a directory");
            }
            boolean rename = false;
            for (int i = 0; i < 5; ++i) {
                try {
                    Files.move(srcFile, destFile, StandardCopyOption.ATOMIC_MOVE);
                    rename = true;
                }
                catch (AtomicMoveNotSupportedException a) {
                    try {
                        Files.move(srcFile, destFile, StandardCopyOption.REPLACE_EXISTING);
                        rename = true;
                    }
                    catch (IOException e) {
                        LOGGER.warn("rename problem: " + e.getMessage());
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("rename problem: " + e.getMessage());
                }
                if (rename) break;
                try {
                    LOGGER.debug("rename did not work - sleep a while and try again...");
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.warn("I'm so excited - could not sleep");
                }
            }
            if (!rename) {
                LOGGER.error("Failed to rename file '" + srcFile + " to " + destFile);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, srcFile, "message.renamer.failedrename"));
                return false;
            }
            LOGGER.info("Successfully moved file from " + srcFile + " to " + destFile);
            return true;
        }
        return true;
    }

    public static boolean copyFileSafe(Path srcFile, Path destFile) throws IOException {
        return Utils.copyFileSafe(srcFile, destFile, false);
    }

    public static boolean copyFileSafe(Path srcFile, Path destFile, boolean overwrite) throws IOException {
        if (srcFile == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destFile == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcFile.toAbsolutePath().toString().equals(destFile.toAbsolutePath().toString())) {
            LOGGER.debug("try to copy file " + srcFile + " to " + destFile);
            if (!Files.exists(srcFile, new LinkOption[0])) {
                throw new FileNotFoundException("Source '" + srcFile + "' does not exist");
            }
            if (Files.isDirectory(srcFile, new LinkOption[0])) {
                throw new IOException("Source '" + srcFile + "' is a directory");
            }
            if (!overwrite && Files.exists(destFile, new LinkOption[0]) && !Files.isSameFile(destFile, srcFile)) {
                throw new FileExistsException("Destination '" + destFile + "' already exists");
            }
            if (Files.isDirectory(destFile, new LinkOption[0])) {
                throw new IOException("Destination '" + destFile + "' is a directory");
            }
            boolean rename = false;
            for (int i = 0; i < 5; ++i) {
                try {
                    Files.copy(srcFile, destFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    rename = true;
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (rename) break;
                try {
                    LOGGER.debug("rename did not work - sleep a while and try again...");
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.warn("I'm so excited - could not sleep");
                }
            }
            if (!rename) {
                LOGGER.error("Failed to rename file '" + srcFile + " to " + destFile);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, srcFile, "message.renamer.failedrename"));
                return false;
            }
            LOGGER.info("Successfully moved file from " + srcFile + " to " + destFile);
            return true;
        }
        return true;
    }

    public static boolean deleteFileWithBackup(Path file, String datasource) {
        Path ds = Paths.get(datasource, new String[0]);
        if (!file.startsWith(ds)) {
            LOGGER.warn("could not delete file '" + file + "': datasource '" + datasource + "' does not match");
            return false;
        }
        if (Files.isDirectory(file, new LinkOption[0])) {
            LOGGER.warn("could not delete file '" + file + "': file is a directory!");
            return false;
        }
        try {
            Path backup = Paths.get(ds.toAbsolutePath().toString(), ".deletedByTMM", ds.relativize(file).toString());
            if (!Files.exists(backup.getParent(), new LinkOption[0])) {
                Files.createDirectories(backup.getParent(), new FileAttribute[0]);
            }
            Files.deleteIfExists(backup);
            return Utils.moveFileSafe(file, backup);
        }
        catch (IOException e) {
            LOGGER.warn("Could not delete file: " + e.getMessage());
            return false;
        }
    }

    public static boolean deleteFileSafely(Path file) {
        if (Files.isDirectory(file = file.toAbsolutePath(), new LinkOption[0])) {
            LOGGER.warn("Will not delete file '" + file + "': file is a directory!");
            return false;
        }
        try {
            Files.deleteIfExists(file);
        }
        catch (Exception e) {
            LOGGER.warn("Could not delete file: " + e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean deleteDirectorySafely(Path folder, String datasource) {
        folder = folder.toAbsolutePath();
        Path ds = Paths.get(datasource, new String[0]);
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            LOGGER.warn("Will not delete folder '" + folder + "': folder is a file, NOT a directory!");
            return false;
        }
        if (!folder.startsWith(ds)) {
            LOGGER.warn("Will not delete folder '" + folder + "': datasource '" + datasource + "' does not match");
            return false;
        }
        try {
            Path backup = Paths.get(ds.toAbsolutePath().toString(), ".deletedByTMM", ds.relativize(folder).toString());
            if (!Files.exists(backup.getParent(), new LinkOption[0])) {
                Files.createDirectories(backup.getParent(), new FileAttribute[0]);
            }
            Utils.deleteDirectoryRecursive(backup);
            return Utils.moveDirectorySafe(folder, backup);
        }
        catch (IOException e) {
            LOGGER.warn("could not delete directory: " + e.getMessage());
            return false;
        }
    }

    public static List<Locale> getLanguages() {
        ArrayList<Locale> loc = new ArrayList<Locale>();
        loc.add(Utils.getLocaleFromLanguage(Locale.ENGLISH.getLanguage()));
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get("locale", new String[0]));){
            for (Path path : directoryStream) {
                Matcher matcher = localePattern.matcher(path.getFileName().toString());
                if (!matcher.matches()) continue;
                Locale myloc = null;
                String language = matcher.group(1);
                String country = matcher.group(2);
                myloc = country != null ? new Locale(language, country) : Utils.getLocaleFromLanguage(language);
                if (myloc == null || loc.contains(myloc)) continue;
                loc.add(myloc);
            }
        }
        catch (Exception e) {
            LOGGER.warn("could not read locales: " + e.getMessage());
        }
        return loc;
    }

    public static Locale getLocaleFromLanguage(String language) {
        if (StringUtils.isBlank((CharSequence)language)) {
            return Locale.getDefault();
        }
        if (language.length() > 2) {
            return LocaleUtils.toLocale((String)language);
        }
        if (language.equalsIgnoreCase("en")) {
            return new Locale("en", "US");
        }
        Locale l = null;
        List countries = LocaleUtils.countriesByLanguage((String)language.toLowerCase(Locale.ROOT));
        for (Locale locale : countries) {
            if (!locale.getCountry().equalsIgnoreCase(language)) continue;
            l = locale;
        }
        if (l == null && countries.size() > 0) {
            l = (Locale)countries.get(0);
        }
        return l;
    }

    public static final void createBackupFile(Path file) {
        Utils.createBackupFile(file, true);
    }

    public static final void createBackupFile(Path file, boolean overwrite) {
        Path backup = Paths.get("backup", new String[0]);
        try {
            if (!Files.exists(backup, new LinkOption[0])) {
                Files.createDirectory(backup, new FileAttribute[0]);
            }
            if (!Files.exists(file, new LinkOption[0])) {
                return;
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String date = formatter.format(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis());
            if (!Files.exists(backup = backup.resolve(file.getFileName() + "." + date + ".zip"), new LinkOption[0]) || overwrite) {
                Utils.createZip(backup, file, "/" + file.getFileName().toString());
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not backup file " + file + ": " + e.getMessage());
        }
    }

    public static void deleteOldBackupFile(Path file, int keep) {
        ArrayList<Path> al = new ArrayList<Path>();
        String fname = file.getFileName().toString();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get("backup", new String[0]));){
            for (Path path : directoryStream) {
                if (!path.getFileName().toString().matches(fname + "\\.\\d{4}\\-\\d{2}\\-\\d{2}\\.zip") && !path.getFileName().toString().matches(fname + "\\.\\d{4}\\-\\d{2}\\-\\d{2}")) continue;
                al.add(path);
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        for (int i = 0; i < al.size() - keep; ++i) {
            Utils.deleteFileSafely((Path)al.get(i));
        }
    }

    public static final void sendWakeOnLanPacket(String macAddr) {
        String IP = "255.255.255.255";
        int port = 7;
        try {
            int i;
            byte[] MACBYTE = new byte[6];
            String[] hex = macAddr.split("(\\:|\\-)");
            for (int i2 = 0; i2 < 6; ++i2) {
                MACBYTE[i2] = (byte)Integer.parseInt(hex[i2], 16);
            }
            byte[] bytes = new byte[6 + 16 * MACBYTE.length];
            for (i = 0; i < 6; ++i) {
                bytes[i] = -1;
            }
            for (i = 6; i < bytes.length; i += MACBYTE.length) {
                System.arraycopy(MACBYTE, 0, bytes, i, MACBYTE.length);
            }
            InetAddress address = InetAddress.getByName("255.255.255.255");
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length, address, 7);
            DatagramSocket socket = new DatagramSocket();
            socket.send(packet);
            socket.close();
            LOGGER.info("Sent WOL packet to " + macAddr);
        }
        catch (Exception e) {
            LOGGER.error("Error sending WOL packet to " + macAddr, (Throwable)e);
        }
    }

    public static ProcessBuilder getPBforTMMrestart() {
        Path f = Paths.get("tmm.jar", new String[0]);
        if (!Files.exists(f, new LinkOption[0])) {
            LOGGER.error("cannot restart TMM - tmm.jar not found.");
            return null;
        }
        List<String> arguments = Utils.getJVMArguments();
        arguments.add(0, LaunchUtil.getJVMPath());
        arguments.add("-Dsilent=noupdate");
        arguments.add("-jar");
        arguments.add("getdown.jar");
        arguments.add(".");
        ProcessBuilder pb = new ProcessBuilder(arguments);
        pb.directory(Paths.get("", new String[0]).toAbsolutePath().toFile());
        return pb;
    }

    public static ProcessBuilder getPBforTMMupdate() {
        Path f = Paths.get("getdown.jar", new String[0]);
        if (!Files.exists(f, new LinkOption[0])) {
            LOGGER.error("cannot start updater - getdown.jar not found.");
            return null;
        }
        List<String> arguments = Utils.getJVMArguments();
        arguments.add(0, LaunchUtil.getJVMPath());
        arguments.add("-jar");
        arguments.add("getdown.jar");
        arguments.add(".");
        ProcessBuilder pb = new ProcessBuilder(arguments);
        pb.directory(Paths.get("", new String[0]).toAbsolutePath().toFile());
        return pb;
    }

    private static List<String> getJVMArguments() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        ArrayList<String> arguments = new ArrayList<String>(runtimeMxBean.getInputArguments());
        if (!arguments.contains("-Djava.net.preferIPv4Stack=true")) {
            arguments.add("-Djava.net.preferIPv4Stack=true");
        }
        if (!arguments.contains("-Dfile.encoding=UTF-8")) {
            arguments.add("-Dfile.encoding=UTF-8");
        }
        return arguments;
    }

    public static void deleteDirectoryRecursive(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        LOGGER.info("Deleting complete directory: " + dir);
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                LOGGER.warn("Could not delete " + file + "; " + exc.getMessage());
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static boolean isFolderEmpty(Path folder) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(folder);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
    }

    public static void createZip(Path zipFile, Path toBeAdded, String internalPath) {
        HashMap<String, String> env = new HashMap<String, String>();
        try {
            env.put("create", String.valueOf(!Files.exists(zipFile, new LinkOption[0])));
            URI fileUri = zipFile.toUri();
            URI zipUri = new URI("jar:" + fileUri.getScheme(), fileUri.getPath(), null);
            try (FileSystem zipfs = FileSystems.newFileSystem(zipUri, env);){
                Path internalTargetPath = zipfs.getPath(internalPath, new String[0]);
                if (!Files.exists(internalTargetPath.getParent(), new LinkOption[0])) {
                    Files.createDirectory(internalTargetPath.getParent(), new FileAttribute[0]);
                }
                Files.copy(toBeAdded, internalTargetPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create zip file!" + e.getMessage());
        }
    }

    public static void unzip(Path zipFile, final Path destDir) {
        HashMap<String, String> env = new HashMap<String, String>();
        try {
            if (!Files.exists(destDir, new LinkOption[0])) {
                Files.createDirectories(destDir, new FileAttribute[0]);
            }
            env.put("create", String.valueOf(!Files.exists(zipFile, new LinkOption[0])));
            URI fileUri = zipFile.toUri();
            URI zipUri = new URI("jar:" + fileUri.getScheme(), fileUri.getPath(), null);
            try (FileSystem zipfs = FileSystems.newFileSystem(zipUri, env);){
                Path root = zipfs.getPath("/", new String[0]);
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path destFile = Paths.get(destDir.toString(), file.toString());
                        LOGGER.debug("Extracting file {} to {}", (Object)file, (Object)destFile);
                        Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Path dirToCreate = Paths.get(destDir.toString(), dir.toString());
                        if (!Files.exists(dirToCreate, new LinkOption[0])) {
                            LOGGER.debug("Creating directory {}", (Object)dirToCreate);
                            Files.createDirectory(dirToCreate, new FileAttribute[0]);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create zip file!" + e.getMessage());
        }
    }

    public static final void extractTemplates() {
        Utils.extractTemplates(false);
    }

    public static final void extractTemplates(boolean force) {
        Path dest = Paths.get("templates", new String[0]);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dest);){
            for (Path path : directoryStream) {
                String fn;
                if (Files.isDirectory(path, new LinkOption[0]) || !(fn = path.getFileName().toString()).endsWith(".jar")) continue;
                if (!Files.exists(dest.resolve(Paths.get(fn.replace(".jar", ""), new String[0])), new LinkOption[0])) {
                    Utils.unzip(path, dest);
                    continue;
                }
                if (!force) continue;
                Utils.unzip(path, dest);
            }
        }
        catch (IOException e) {
            LOGGER.warn("failed to extract templates: " + e.getMessage());
        }
    }

    public static void writeStringToFile(Path file, String text) throws IOException {
        byte[] buf = text.getBytes(StandardCharsets.UTF_8);
        Files.write(file, buf, new OpenOption[0]);
    }

    public static String readFileToString(Path file) throws IOException {
        byte[] fileArray = Files.readAllBytes(file);
        return new String(fileArray, StandardCharsets.UTF_8);
    }

    public static void copyDirectoryRecursive(Path from, Path to) throws IOException {
        LOGGER.info("Copyin complete directory from " + from + " to " + to);
        Files.walkFileTree(from, new CopyFileVisitor(to));
    }

    public static void sortList(List list) {
        if (SystemUtils.IS_JAVA_1_7 && list instanceof CopyOnWriteArrayList) {
            ArrayList tempList = new ArrayList(list);
            Collections.sort(tempList);
            list.clear();
            list.addAll(tempList);
        } else {
            Collections.sort(list);
        }
    }

    public static void sortList(List list, Comparator comparator) {
        if (SystemUtils.IS_JAVA_1_7 && list instanceof CopyOnWriteArrayList) {
            ArrayList tempList = new ArrayList(list);
            Collections.sort(tempList, comparator);
            list.clear();
            list.addAll(tempList);
        } else {
            Collections.sort(list, comparator);
        }
    }

    public static void cleanOldLogs() {
        Pattern pattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
        Calendar cal = Calendar.getInstance();
        cal.add(5, -30);
        Date dateBefore30Days = cal.getTime();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get("logs", new String[0]));){
            for (Path path : directoryStream) {
                Matcher matcher = pattern.matcher(path.getFileName().toString());
                if (!matcher.find()) continue;
                try {
                    Date date = StrgUtils.parseDate((String)matcher.group());
                    if (!dateBefore30Days.after(date)) continue;
                    Utils.deleteFileSafely(path);
                }
                catch (Exception ignored) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class CopyFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path targetPath;
        private Path sourcePath = null;

        public CopyFileVisitor(Path targetPath) {
            this.targetPath = targetPath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path target;
            if (this.sourcePath == null) {
                this.sourcePath = dir;
            }
            if (!Files.exists(target = this.targetPath.resolve(this.sourcePath.relativize(dir)), new LinkOption[0])) {
                try {
                    Files.createDirectories(target, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException e) {
                }
                catch (IOException x) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.targetPath.resolve(this.sourcePath.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
            return FileVisitResult.CONTINUE;
        }
    }
}

