/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.moviemeter;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.bind.DateTypeAdapter;
import com.jakewharton.retrofit.Ok3Client;
import java.lang.reflect.Type;
import java.util.Date;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.moviemeter.services.FilmService;
import org.tinymediamanager.scraper.moviemeter.services.SearchService;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

class MovieMeter {
    public static final String API_URL = "http://www.moviemeter.nl/api/";
    public static final String PARAM_API_KEY = "api_key";
    private RestAdapter restAdapter;
    private boolean isDebug;
    private String apiKey;

    public MovieMeter(String apiKey) {
        this.apiKey = apiKey;
    }

    public MovieMeter setIsDebug(boolean isDebug) {
        this.isDebug = isDebug;
        if (this.restAdapter != null) {
            this.restAdapter.setLogLevel(isDebug ? RestAdapter.LogLevel.FULL : RestAdapter.LogLevel.NONE);
        }
        return this;
    }

    protected RestAdapter.Builder newRestAdapterBuilder() {
        return new RestAdapter.Builder();
    }

    protected RestAdapter getRestAdapter() {
        if (this.restAdapter == null) {
            RestAdapter.Builder builder = this.newRestAdapterBuilder();
            builder.setEndpoint(API_URL);
            builder.setConverter((Converter)new GsonConverter(this.getGsonBuilder().create()));
            builder.setClient((Client)new Ok3Client(TmmHttpClient.getHttpClient()));
            builder.setRequestInterceptor(new RequestInterceptor(){

                public void intercept(RequestInterceptor.RequestFacade requestFacade) {
                    requestFacade.addQueryParam(MovieMeter.PARAM_API_KEY, MovieMeter.this.apiKey);
                }
            });
            if (this.isDebug) {
                builder.setLogLevel(RestAdapter.LogLevel.FULL);
            }
            this.restAdapter = builder.build();
        }
        return this.restAdapter;
    }

    protected GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (Object)new JsonDeserializer<Integer>(){

            public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return json.getAsInt();
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        return builder;
    }

    public FilmService getFilmService() {
        return (FilmService)this.getRestAdapter().create(FilmService.class);
    }

    public SearchService getSearchService() {
        return (SearchService)this.getRestAdapter().create(SearchService.class);
    }

    static class ErrorResponse {
        @SerializedName(value="message")
        String msg;

        ErrorResponse() {
        }

        public String toString() {
            return this.msg;
        }
    }
}

