/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;

public class MessageDialog
extends JDialog {
    private static final long serialVersionUID = -9035402766767310658L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private JLabel lblImage;
    private JLabel lblText;
    private JLabel lblDescription;
    private JScrollPane scrollPane;
    private JTextPane textPane;

    public MessageDialog(Window owner, String title) {
        super(owner, title);
        if (owner != null) {
            this.setIconImages(owner.getIconImages());
        }
        this.setMinimumSize(new Dimension(300, 100));
        this.setResizable(false);
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(10dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC}));
        this.lblImage = new JLabel("");
        this.lblImage.setVisible(false);
        panelContent.add((Component)this.lblImage, "2, 2, 1, 3, fill, fill");
        this.lblText = new JLabel("");
        this.lblText.setVisible(false);
        panelContent.add((Component)this.lblText, "4, 2, fill, fill");
        this.lblDescription = new JLabel("");
        this.lblDescription.setVisible(false);
        panelContent.add((Component)this.lblDescription, "4, 4, fill, fill");
        this.scrollPane = new JScrollPane();
        this.scrollPane.setVisible(false);
        this.scrollPane.setPreferredSize(new Dimension(600, 200));
        panelContent.add((Component)this.scrollPane, "2, 6, 3, 1, fill, fill");
        this.textPane = new JTextPane();
        this.textPane.setVisible(false);
        this.textPane.setEditable(false);
        this.scrollPane.setViewportView(this.textPane);
        JPanel panelBottom = new JPanel();
        this.getContentPane().add((Component)panelBottom, "South");
        panelBottom.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC}));
        JPanel panelButtons = new JPanel();
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        panelButtons.setLayout(layout);
        panelBottom.add((Component)panelButtons, "4, 2, right, fill");
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MessageDialog.this.setVisible(false);
            }
        });
        panelButtons.add(btnClose);
    }

    public void setImage(Icon icon) {
        this.lblImage.setIcon(icon);
        this.lblImage.setVisible(true);
    }

    public void setText(String text) {
        this.lblText.setText(MessageDialog.toHTML(text));
        this.lblText.setVisible(true);
    }

    public void setDescription(String description) {
        this.lblDescription.setText(MessageDialog.toHTML(description));
        this.lblDescription.setVisible(true);
    }

    public void setDetails(String details) {
        this.textPane.setText(details);
        this.textPane.setVisible(true);
        this.textPane.setCaretPosition(0);
        this.scrollPane.setVisible(true);
    }

    public static void showExceptionWindow(Throwable ex) {
        MessageDialog dialog = new MessageDialog((Window)MainWindow.getActiveInstance(), BUNDLE.getString("tmm.problemdetected"));
        dialog.setImage(IconManager.ERROR);
        String msg = ex.getLocalizedMessage();
        dialog.setText(msg != null ? msg : "");
        dialog.setDescription(BUNDLE.getString("tmm.uicrash"));
        dialog.setDetails(MessageDialog.stackStraceAsString(ex));
        dialog.setResizable(true);
        dialog.pack();
        dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
        dialog.setVisible(true);
    }

    private static String stackStraceAsString(Throwable ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static final String toHTML(String s) {
        s = s == null ? "" : s.replaceAll("\n", "<br>");
        String tmp = s.trim().toLowerCase(Locale.ROOT);
        StringBuilder sb = new StringBuilder(s);
        if (!tmp.startsWith("<html>")) {
            sb.insert(0, "<html>");
        }
        if (!tmp.endsWith("</html>")) {
            sb.append("</html>");
        }
        return sb.toString();
    }
}

