/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.RenderFormatInfo;
import com.floreysoft.jmte.encoder.Encoder;
import com.floreysoft.jmte.encoder.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ExportTemplate;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;

public abstract class MediaEntityExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaEntityExporter.class);
    protected static final String TEMPLATE_DIRECTORY = "templates";
    protected Engine engine;
    protected Properties properties;
    protected String fileExtension;
    protected String listTemplate = "";
    protected String detailTemplate = "";
    protected Path templateDir;

    protected MediaEntityExporter(Path templatePath, TemplateType type) throws Exception {
        this.templateDir = templatePath;
        if (!Files.isDirectory(this.templateDir, new LinkOption[0])) {
            throw new Exception("illegal template path");
        }
        Path configFile = this.templateDir.resolve("template.conf");
        if (!Files.exists(configFile, new LinkOption[0])) {
            throw new Exception("illegal template config");
        }
        this.properties = new Properties();
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(configFile.toFile()));
        this.properties.load(stream);
        stream.close();
        String typeInConfig = this.properties.getProperty("type");
        if (!typeInConfig.equalsIgnoreCase(type.name())) {
            throw new Exception("illegal template");
        }
        String listTemplateFile = this.properties.getProperty("list");
        if (StringUtils.isBlank((CharSequence)listTemplateFile)) {
            throw new Exception("illegal template");
        }
        String detailTemplateFile = this.properties.getProperty("detail");
        this.fileExtension = this.properties.getProperty("extension");
        if (StringUtils.isBlank((CharSequence)this.fileExtension)) {
            this.fileExtension = "html";
        }
        this.engine = Engine.createCachingEngine();
        if (this.fileExtension.equalsIgnoreCase("html")) {
            this.engine.setEncoder((Encoder)new HtmlEncoder());
        }
        if (this.fileExtension.equalsIgnoreCase("xml")) {
            this.engine.setEncoder((Encoder)new XMLEncoder());
        }
        this.listTemplate = Utils.readFileToString(this.templateDir.resolve(listTemplateFile));
        if (StringUtils.isNotBlank((CharSequence)detailTemplateFile)) {
            this.detailTemplate = Utils.readFileToString(this.templateDir.resolve(detailTemplateFile));
        }
    }

    public abstract <T extends MediaEntity> void export(List<T> var1, Path var2) throws Exception;

    public static List<ExportTemplate> findTemplates(TemplateType type) {
        ArrayList<ExportTemplate> templatesFound = new ArrayList<ExportTemplate>();
        Path root = Paths.get(TEMPLATE_DIRECTORY, new String[0]);
        if (!Files.isDirectory(root, new LinkOption[0])) {
            return templatesFound;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(root);){
            for (Path path : directoryStream) {
                Path config;
                if (!Files.isDirectory(path, new LinkOption[0]) || !Files.exists(config = path.resolve("template.conf"), new LinkOption[0])) continue;
                Properties properties = new Properties();
                try {
                    BufferedInputStream stream = new BufferedInputStream(new FileInputStream(config.toFile()));
                    properties.load(stream);
                    stream.close();
                }
                catch (Exception e) {
                    LOGGER.warn("error in config: " + path + " | " + e.getMessage());
                    continue;
                }
                String typeInConfig = properties.getProperty("type");
                if (StringUtils.isBlank((CharSequence)typeInConfig) || !typeInConfig.equalsIgnoreCase(type.name())) continue;
                ExportTemplate template = new ExportTemplate();
                template.setName(properties.getProperty("name"));
                template.setType(type);
                template.setPath(path.toAbsolutePath().toString());
                template.setUrl(properties.getProperty("url"));
                template.setDescription(properties.getProperty("description"));
                if (StringUtils.isNotBlank((CharSequence)properties.getProperty("detail"))) {
                    template.setDetail(true);
                } else {
                    template.setDetail(false);
                }
                templatesFound.add(template);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return templatesFound;
    }

    public static class HtmlEncoder
    implements Encoder {
        public String encode(String arg0) {
            return StringEscapeUtils.escapeHtml4((String)arg0);
        }
    }

    public static class NamedDateRenderer
    implements NamedRenderer {
        private static final String DEFAULT_PATTERN = "dd.MM.yyyy HH:mm:ss Z";

        private Date convert(Object o, DateFormat dateFormat) {
            if (o instanceof Date) {
                return (Date)o;
            }
            if (o instanceof Number) {
                long longValue = ((Number)o).longValue();
                return new Date(longValue);
            }
            if (o instanceof String) {
                try {
                    try {
                        return dateFormat.parse((String)o);
                    }
                    catch (ParseException e) {
                        LOGGER.warn("cannot convert date format", (Throwable)e);
                    }
                }
                catch (com.floreysoft.jmte.message.ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }

        public String getName() {
            return "date";
        }

        public Class<?>[] getSupportedClasses() {
            return new Class[]{Date.class, String.class, Integer.class, Long.class};
        }

        public String render(Object o, String pattern, Locale locale) {
            String patternToUse = pattern != null ? pattern : DEFAULT_PATTERN;
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(patternToUse);
                Date value = this.convert(o, dateFormat);
                if (value != null) {
                    String format = dateFormat.format(value);
                    return format;
                }
            }
            catch (IllegalArgumentException | NullPointerException iae) {
                // empty catch block
            }
            return null;
        }

        public RenderFormatInfo getFormatInfo() {
            return null;
        }
    }

    public static enum TemplateType {
        MOVIE,
        TV_SHOW;

    }
}

