/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import com.jtattoo.plaf.luna.LunaLookAndFeel;
import com.sun.jna.Platform;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.ELProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.LaunchUtil;
import org.tinymediamanager.Log4jBackstop;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.TinyMediaManagerCMD;
import org.tinymediamanager.TmmOsUtils;
import org.tinymediamanager.UpgradeTasks;
import org.tinymediamanager.core.License;
import org.tinymediamanager.core.TmmModuleManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.scraper.util.PluginManager;
import org.tinymediamanager.thirdparty.MediaInfoUtils;
import org.tinymediamanager.thirdparty.upnp.Upnp;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUILogCollector;
import org.tinymediamanager.ui.TmmWindowSaver;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.dialogs.MessageDialog;
import org.tinymediamanager.ui.dialogs.WhatsNewDialog;
import org.tinymediamanager.ui.wizard.TinyMediaManagerWizard;

public class TinyMediaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TinyMediaManager.class);

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            LOGGER.debug("TMM started with: " + Arrays.toString(args));
            TinyMediaManagerCMD.parseParams(args);
            System.setProperty("java.awt.headless", "true");
        } else {
            String head = System.getProperty("java.awt.headless");
            if (head != null && head.equals("true")) {
                LOGGER.info("TMM started 'headless', and without params -> displaying syntax ");
                TinyMediaManagerCMD.printSyntax();
                System.exit(0);
            }
        }
        try {
            RandomAccessFile f = new RandomAccessFile("access.test", "rw");
            f.close();
            Files.deleteIfExists(Paths.get("access.test", new String[0]));
        }
        catch (Exception e2) {
            String msg = "Cannot write to TMM directory, have no rights - exiting.";
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(null, msg);
            } else {
                System.out.println(msg);
            }
            System.exit(1);
        }
        String dir = new File(LaunchUtil.getJVMPath()).getParentFile().getParent();
        File jfx = new File(dir, "lib/ext/jfxrt.jar");
        if (!jfx.exists() && (jfx = new File(dir, "lib/jfxrt.jar")).exists()) {
            try {
                TmmOsUtils.addPath(jfx.getAbsolutePath());
            }
            catch (Exception e) {
                LOGGER.debug("failed to load JavaFX - using old styles...");
            }
        }
        if (Globals.isDebug()) {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            URL[] urls = ((URLClassLoader)cl).getURLs();
            LOGGER.info("=== DEBUG CLASS LOADING =============================");
            for (URL url : urls) {
                LOGGER.info(url.getFile());
            }
        }
        LOGGER.info("=====================================================");
        LOGGER.info("=== tinyMediaManager (c) 2012-2016 Manuel Laggner ===");
        LOGGER.info("=====================================================");
        LOGGER.info("tmm.version      : " + ReleaseInfo.getRealVersion());
        if (Globals.isDonator()) {
            LOGGER.info("tmm.supporter    : THANKS FOR DONATING - ALL FEATURES UNLOCKED :)");
        }
        LOGGER.info("os.name          : " + System.getProperty("os.name"));
        LOGGER.info("os.version       : " + System.getProperty("os.version"));
        LOGGER.info("os.arch          : " + System.getProperty("os.arch"));
        LOGGER.trace("network.id       : " + License.getMac());
        LOGGER.info("java.version     : " + System.getProperty("java.version"));
        if (Globals.isRunningJavaWebStart()) {
            LOGGER.info("java.webstart    : true");
        }
        if (Globals.isRunningWebSwing()) {
            LOGGER.info("java.webswing    : true");
        }
        TinyMediaManager.debugCharacterEncoding("default encoding : ");
        System.setProperty("file.encoding", "UTF-8");
        System.setProperty("sun.jnu.encoding", "UTF-8");
        try {
            Field charset = Charset.class.getDeclaredField("defaultCharset");
            charset.setAccessible(true);
            charset.set(null, null);
        }
        catch (Exception e) {
            LOGGER.warn("Error resetting to UTF-8", (Throwable)e);
        }
        TinyMediaManager.debugCharacterEncoding("set encoding to  : ");
        Locale.setDefault(Utils.getLocaleFromLanguage(Globals.settings.getLanguage()));
        LOGGER.info("System language  : " + System.getProperty("user.language") + "_" + System.getProperty("user.country"));
        LOGGER.info("GUI language     : " + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry());
        LOGGER.info("Scraper language : " + MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage());
        LOGGER.info("TV Scraper lang  : " + TvShowModuleManager.SETTINGS.getScraperLanguage());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                block35: {
                    boolean newVersion = !Globals.settings.isCurrentVersion();
                    try {
                        Thread.setDefaultUncaughtExceptionHandler(new Log4jBackstop());
                        if (!GraphicsEnvironment.isHeadless()) {
                            Thread.currentThread().setName("main");
                        } else {
                            Thread.currentThread().setName("headless");
                            LOGGER.debug("starting without GUI...");
                        }
                        Toolkit tk = Toolkit.getDefaultToolkit();
                        tk.addAWTEventListener(TmmWindowSaver.getInstance(), 64L);
                        if (!GraphicsEnvironment.isHeadless()) {
                            this.setLookAndFeel();
                        }
                        this.doStartupTasks();
                        org.jdesktop.beansbinding.util.logging.Logger.getLogger((String)ELProperty.class.getName()).setLevel(Level.SEVERE);
                        TmmUILogCollector.init();
                        LOGGER.info("=====================================================");
                        SplashScreen splash = null;
                        if (!GraphicsEnvironment.isHeadless()) {
                            splash = SplashScreen.getSplashScreen();
                        }
                        Graphics2D g2 = null;
                        if (splash != null) {
                            g2 = splash.createGraphics();
                            if (g2 != null) {
                                Font font = new Font("Dialog", 0, 14);
                                g2.setFont(font);
                            } else {
                                LOGGER.debug("got no graphics from splash");
                            }
                        } else {
                            LOGGER.debug("no splash found");
                        }
                        if (g2 != null) {
                            this.updateProgress(g2, "starting tinyMediaManager", 0);
                            splash.update();
                        }
                        LOGGER.info("starting tinyMediaManager");
                        String oldVersion = Globals.settings.getVersion();
                        if (newVersion) {
                            if (g2 != null) {
                                this.updateProgress(g2, "upgrading to new version", 10);
                                splash.update();
                            }
                            UpgradeTasks.performUpgradeTasksBeforeDatabaseLoading(oldVersion);
                            Globals.settings.setCurrentVersion();
                            Globals.settings.saveSettings();
                        }
                        if (Globals.settings.useProxy()) {
                            LOGGER.info("setting proxy");
                            Globals.settings.setProxy();
                        }
                        if (g2 != null) {
                            this.updateProgress(g2, "loading MediaInfo libs", 20);
                            splash.update();
                        }
                        MediaInfoUtils.loadMediaInfo();
                        if (g2 != null) {
                            this.updateProgress(g2, "loading movie module", 30);
                            splash.update();
                        }
                        TmmModuleManager.getInstance().startUp();
                        TmmModuleManager.getInstance().registerModule(MovieModuleManager.getInstance());
                        TmmModuleManager.getInstance().enableModule(MovieModuleManager.getInstance());
                        if (g2 != null) {
                            this.updateProgress(g2, "loading TV show module", 40);
                            splash.update();
                        }
                        TmmModuleManager.getInstance().registerModule(TvShowModuleManager.getInstance());
                        TmmModuleManager.getInstance().enableModule(TvShowModuleManager.getInstance());
                        if (g2 != null) {
                            this.updateProgress(g2, "loading plugins", 50);
                            splash.update();
                        }
                        PluginManager.getInstance();
                        if (ReleaseInfo.isGitBuild()) {
                            PluginManager.loadClasspathPlugins();
                        }
                        if (g2 != null) {
                            this.updateProgress(g2, "starting services", 60);
                            splash.update();
                        }
                        Upnp u = Upnp.getInstance();
                        if (Globals.settings.isUpnpShareLibrary()) {
                            u.startWebServer();
                            u.createUpnpService();
                            u.startMediaServer();
                        }
                        if (Globals.settings.isUpnpRemotePlay()) {
                            u.createUpnpService();
                            u.sendPlayerSearchRequest();
                            u.startWebServer();
                        }
                        if (newVersion) {
                            if (g2 != null) {
                                this.updateProgress(g2, "upgrading database to new version", 70);
                                splash.update();
                            }
                            UpgradeTasks.performUpgradeTasksAfterDatabaseLoading(oldVersion);
                        }
                        if (g2 != null) {
                            this.updateProgress(g2, "loading ui", 80);
                            splash.update();
                        }
                        if (!GraphicsEnvironment.isHeadless()) {
                            MainWindow window = new MainWindow("tinyMediaManager / " + ReleaseInfo.getRealVersion());
                            if (g2 != null) {
                                this.updateProgress(g2, "finished starting :)", 100);
                                splash.update();
                            }
                            Utils.trackEvent("startup");
                            TmmWindowSaver.getInstance().loadSettings(window);
                            window.setVisible(true);
                            if (Globals.settings.newConfig) {
                                Globals.settings.writeDefaultSettings();
                                TinyMediaManagerWizard wizard = new TinyMediaManagerWizard();
                                wizard.setVisible(true);
                            }
                            if (newVersion && !ReleaseInfo.getVersion().equals(oldVersion)) {
                                Utils.trackEvent("updated");
                                this.showChangelog();
                            }
                            break block35;
                        }
                        TinyMediaManagerCMD.startCommandLineTasks();
                        while (TmmTaskManager.getInstance().poolRunning()) {
                            Thread.sleep(2000L);
                        }
                        LOGGER.info("bye bye");
                        try {
                            TmmTaskManager.getInstance().shutdown();
                            Globals.settings.saveSettings();
                            TmmTaskManager.getInstance().shutdownNow();
                            TmmModuleManager.getInstance().shutDown();
                        }
                        catch (Exception ex) {
                            LOGGER.warn(ex.getMessage());
                        }
                        System.exit(0);
                    }
                    catch (IllegalStateException e) {
                        LOGGER.error("IllegalStateException", (Throwable)e);
                        if (!GraphicsEnvironment.isHeadless() && e.getMessage().contains("file is locked")) {
                            ResourceBundle bundle = ResourceBundle.getBundle("messages", new UTF8Control());
                            MessageDialog dialog = new MessageDialog((Window)MainWindow.getActiveInstance(), bundle.getString("tmm.problemdetected"));
                            dialog.setImage(IconManager.ERROR);
                            dialog.setText(bundle.getString("tmm.nostart"));
                            dialog.setDescription(bundle.getString("tmm.nostart.instancerunning"));
                            dialog.setResizable(true);
                            dialog.pack();
                            dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                            dialog.setVisible(true);
                        }
                        System.exit(1);
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception while start of tmm", (Throwable)e);
                        if (!GraphicsEnvironment.isHeadless()) {
                            MessageDialog.showExceptionWindow(e);
                        }
                        System.exit(1);
                    }
                }
            }

            private void updateProgress(Graphics2D g2, String text, int progress) {
                Object oldAAValue = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
                g2.setComposite(AlphaComposite.Clear);
                g2.fillRect(20, 200, 480, 305);
                g2.setPaintMode();
                g2.setColor(new Color(51, 153, 255));
                g2.fillRect(22, 272, 452 * progress / 100, 21);
                g2.setColor(Color.black);
                g2.drawString(text + "...", 23, 310);
                int l = g2.getFontMetrics().stringWidth(ReleaseInfo.getRealVersion());
                g2.drawString(ReleaseInfo.getRealVersion(), 480 - l, 325);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
                LOGGER.debug("Startup (" + progress + "%) " + text);
            }

            private void setLookAndFeel() throws Exception {
                String fontFamily = Globals.settings.getFontFamily();
                try {
                    fontFamily = Font.decode(fontFamily).getFamily();
                }
                catch (Exception e) {
                    fontFamily = "Dialog";
                }
                int fontSize = Globals.settings.getFontSize();
                if (fontSize < 12) {
                    fontSize = 12;
                }
                String fontString = fontFamily + " " + fontSize;
                Properties props = new Properties();
                props.setProperty("controlTextFont", fontString);
                props.setProperty("systemTextFont", fontString);
                props.setProperty("userTextFont", fontString);
                props.setProperty("menuTextFont", fontString);
                fontSize = Math.round((float)((double)fontSize * 0.833));
                fontString = fontFamily + " " + fontSize;
                props.setProperty("subTextFont", fontString);
                props.setProperty("backgroundColor", "237 237 237");
                props.setProperty("menuBackgroundColor", "237 237 237");
                props.setProperty("controlBackgroundColor", "237 237 237");
                props.setProperty("menuColorLight", "237 237 237");
                props.setProperty("menuColorDark", "237 237 237");
                props.setProperty("toolbarColorLight", "237 237 237");
                props.setProperty("toolbarColorDark", "237 237 237");
                props.setProperty("tooltipBackgroundColor", "255 255 255");
                props.put("windowDecoration", "system");
                props.put("logoString", "");
                LunaLookAndFeel.setTheme((Properties)props);
                String laf = "com.jtattoo.plaf.luna.LunaLookAndFeel";
                UIManager.setLookAndFeel(laf);
            }

            private void doStartupTasks() {
                File desktop;
                UpgradeTasks.renameDownloadedFiles();
                Utils.extractTemplates();
                Utils.cleanOldLogs();
                if (Platform.isLinux() && !(desktop = new File("tinyMediaManager.desktop")).exists()) {
                    TmmOsUtils.createDesktopFileForLinux(desktop);
                }
            }

            private void showChangelog() {
                try {
                    final String changelog = Utils.readFileToString(Paths.get("changelog.txt", new String[0]));
                    if (StringUtils.isNotBlank((CharSequence)changelog)) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                WhatsNewDialog dialog = new WhatsNewDialog(changelog);
                                dialog.pack();
                                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                                dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                                dialog.setVisible(true);
                            }
                        });
                    }
                }
                catch (IOException e) {
                    LOGGER.warn(e.getMessage());
                }
            }
        });
    }

    private static void debugCharacterEncoding(String text) {
        String defaultCharacterEncoding = System.getProperty("file.encoding");
        byte[] bArray = new byte[]{119};
        ByteArrayInputStream is = new ByteArrayInputStream(bArray);
        InputStreamReader reader = new InputStreamReader(is);
        LOGGER.info(text + defaultCharacterEncoding + " | " + reader.getEncoding() + " | " + Charset.defaultCharset());
    }
}

